/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

import com.yahoo.language.process.LinguisticsParameters;
import com.yahoo.language.process.StemList;
import com.yahoo.language.process.Stemmer;
import com.yahoo.language.process.Token;
import com.yahoo.language.process.Tokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class StemmerImpl
implements Stemmer {
    private final Tokenizer tokenizer;

    public StemmerImpl(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Override
    public List<StemList> stem(String input, LinguisticsParameters parameters) {
        ArrayList<StemList> stems = new ArrayList<StemList>();
        for (Token token : this.tokenizer.tokenize(input, parameters)) {
            this.findStems(token, stems);
        }
        return stems;
    }

    private void findStems(Token token, List<StemList> out) {
        int len;
        if (token.isSpecialToken() || (len = token.getNumComponents()) == 0) {
            if (token.isIndexable()) {
                StemList word = new StemList(Optional.of(token.getOrig()), new String[0]);
                word.add(token.getTokenString());
                for (int i = 1; i < token.getNumStems(); ++i) {
                    word.add(token.getStem(i));
                }
                out.add(word);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                this.findStems(token.getComponent(i), out);
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + " using " + String.valueOf(this.tokenizer);
    }
}

