/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.simple;

import com.yahoo.language.process.Token;
import com.yahoo.language.process.TokenScript;
import com.yahoo.language.process.TokenType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SimpleToken
implements Token {
    private final List<Token> components = new ArrayList<Token>();
    private final String original;
    private TokenType type = TokenType.UNKNOWN;
    private TokenScript script = TokenScript.UNKNOWN;
    private String tokenString;
    private List<String> stems = null;
    private boolean specialToken = false;
    private long offset = 0L;

    public SimpleToken(String original) {
        this(original, (String)null);
    }

    public SimpleToken(String original, String tokenString) {
        this.original = original;
        this.tokenString = tokenString;
    }

    private SimpleToken(String original, List<String> stems) {
        this.type = TokenType.ALPHABETIC;
        this.original = original;
        this.tokenString = stems.get(0);
        this.stems = List.copyOf(stems.subList(1, stems.size()));
    }

    @Override
    public String getOrig() {
        return this.original;
    }

    @Override
    public int getNumStems() {
        return (this.tokenString != null ? 1 : 0) + (this.stems != null ? this.stems.size() : 0);
    }

    @Override
    public String getStem(int i) {
        if (i == 0) {
            return this.tokenString;
        }
        if (this.stems != null && i - 1 < this.stems.size()) {
            return this.stems.get(i - 1);
        }
        return this.tokenString;
    }

    @Override
    public int getNumComponents() {
        return this.components.size();
    }

    @Override
    public Token getComponent(int i) {
        return this.components.get(i);
    }

    public SimpleToken addStem(String stem) {
        if (this.stems == null) {
            this.stems = new ArrayList<String>();
        }
        this.stems.add(stem);
        return this;
    }

    public SimpleToken addComponent(Token token) {
        this.components.add(token);
        return this;
    }

    @Override
    public String getTokenString() {
        return this.tokenString;
    }

    public SimpleToken setTokenString(String string) {
        this.tokenString = string;
        return this;
    }

    @Override
    public TokenType getType() {
        return this.type;
    }

    public SimpleToken setType(TokenType type) {
        this.type = type;
        return this;
    }

    @Override
    public TokenScript getScript() {
        return this.script;
    }

    public SimpleToken setScript(TokenScript script) {
        this.script = script;
        return this;
    }

    @Override
    public boolean isSpecialToken() {
        return this.specialToken;
    }

    public SimpleToken setSpecialToken(boolean specialToken) {
        this.specialToken = specialToken;
        return this;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    public SimpleToken setOffset(long offset) {
        this.offset = offset;
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Token)) {
            return false;
        }
        Token other = (Token)o;
        if (this.getType() != other.getType()) {
            return false;
        }
        if (!Objects.equals(this.getOrig(), other.getOrig())) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (!Objects.equals((Object)this.getScript(), (Object)other.getScript())) {
            return false;
        }
        if (!Objects.equals(this.getTokenString(), other.getTokenString())) {
            return false;
        }
        if (this.isSpecialToken() != other.isSpecialToken()) {
            return false;
        }
        if (this.getNumComponents() != other.getNumComponents()) {
            return false;
        }
        int len = this.getNumComponents();
        for (int i = 0; i < len; ++i) {
            if (Objects.equals(this.getComponent(i), other.getComponent(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.original.hashCode();
    }

    public String toString() {
        StringBuilder s = new StringBuilder("token '" + this.tokenString + "'");
        StringBuilder extra = new StringBuilder();
        if (this.stems != null && !this.stems.isEmpty()) {
            extra.append("stems: ").append(this.stems);
        }
        if (!this.tokenString.equals(this.original)) {
            if (!extra.isEmpty()) {
                extra.append(", ");
            }
            extra.append("original: '").append(this.original).append("'");
        }
        if (!extra.isEmpty()) {
            s.append(" (").append((CharSequence)extra).append(")");
        }
        return s.toString();
    }

    public String toDetailString() {
        return "token : " + this.getClass().getSimpleName() + " {\n" + SimpleToken.toString(this, "    ") + "}";
    }

    private static String toString(Token token, String indent) {
        StringBuilder builder = new StringBuilder();
        builder.append(indent).append("components : {\n");
        int len = token.getNumComponents();
        for (int i = 0; i < len; ++i) {
            Token comp = token.getComponent(i);
            builder.append(indent).append("    [").append(i).append("] : ").append(comp.getClass().getSimpleName());
            builder.append(" {\n").append(SimpleToken.toString(comp, indent + "        "));
            builder.append(indent).append("    }\n");
        }
        builder.append(indent).append("}\n");
        builder.append(indent).append("offset : ").append(token.getOffset()).append("\n");
        builder.append(indent).append("orig : ").append(SimpleToken.quoteString(token.getOrig())).append("\n");
        builder.append(indent).append("script : ").append((Object)token.getScript()).append("\n");
        builder.append(indent).append("special : ").append(token.isSpecialToken()).append("\n");
        builder.append(indent).append("token string : ").append(SimpleToken.quoteString(token.getTokenString())).append("\n");
        builder.append(indent).append("type : ").append((Object)token.getType()).append("\n");
        return builder.toString();
    }

    private static String quoteString(String str) {
        return str != null ? "'" + str + "'" : null;
    }

    @Override
    public boolean isIndexable() {
        return this.getType().isIndexable() && !this.getOrig().isEmpty();
    }

    public static SimpleToken fromStems(String original, List<String> stems) {
        return new SimpleToken(original, stems);
    }
}

