/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

import com.yahoo.api.annotations.Beta;
import com.yahoo.language.process.InvocationContext;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public interface Embedder {
    public static final String defaultEmbedderId = "default";
    public static final Embedder throwsOnUse = new FailingEmbedder();

    default public Map<String, Embedder> asMap() {
        return this.asMap(defaultEmbedderId);
    }

    default public Map<String, Embedder> asMap(String name) {
        return Map.of(name, this);
    }

    public List<Integer> embed(String var1, Context var2);

    default public String decode(List<Integer> tokens, Context context) {
        throw new UnsupportedOperationException("Decode is not implemented");
    }

    public Tensor embed(String var1, Context var2, TensorType var3);

    public static class FailingEmbedder
    implements Embedder {
        private final String message;

        public FailingEmbedder() {
            this("No embedder has been configured");
        }

        public FailingEmbedder(String message) {
            this.message = message;
        }

        @Override
        public List<Integer> embed(String text, Context context) {
            throw new IllegalStateException(this.message);
        }

        @Override
        public Tensor embed(String text, Context context, TensorType tensorType) {
            throw new IllegalStateException(this.message);
        }

        public boolean equals(Object other) {
            return other instanceof FailingEmbedder;
        }

        public int hashCode() {
            return this.getClass().getName().hashCode();
        }

        public static Function<String, Embedder> factory() {
            return FailingEmbedder::new;
        }
    }

    @Beta
    public static interface Runtime {
        public void sampleEmbeddingLatency(double var1, Context var3);

        public void sampleSequenceLength(long var1, Context var3);

        public static Runtime testInstance() {
            return new Runtime(){

                @Override
                public void sampleEmbeddingLatency(double millis, Context ctx) {
                }

                @Override
                public void sampleSequenceLength(long length, Context ctx) {
                }
            };
        }
    }

    public static class Context
    extends InvocationContext<Context> {
        public Context(String destination) {
            super(destination);
        }

        public Context(String destination, Map<Object, Object> cache) {
            super(destination, cache);
        }

        public Context(Context other) {
            super(other);
        }

        public Context copy() {
            return new Context(this);
        }

        public String getEmbedderId() {
            return this.getComponentId();
        }

        public Context setEmbedderId(String componentId) {
            return (Context)this.setComponentId(componentId);
        }
    }
}

