/**
 * This file is generated from a config definition file.
 * ------------   D O   N O T   E D I T !   ------------
 */

package com.yahoo.cloud.config.log;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of logd
 *
 * Copyright Yahoo. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class LogdConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "d990b8d5b58421a1bd40bcba0079621c";
  public final static String CONFIG_DEF_NAME = "logd";
  public final static String CONFIG_DEF_NAMESPACE = "cloud.config.log";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=cloud.config.log",
    "stateport int default=0",
    "logserver.host string default=\"localhost\"",
    "logserver.rpcport int default=5822",
    "logserver.use bool default=true",
    "loglevel.fatal.forward bool default=true",
    "loglevel.error.forward bool default=true",
    "loglevel.warning.forward bool default=true",
    "loglevel.config.forward bool default=true",
    "loglevel.info.forward bool default=true",
    "loglevel.event.forward bool default=true",
    "loglevel.debug.forward bool default=false",
    "loglevel.spam.forward bool default=false",
    "rotate.size int default=10000000",
    "rotate.age int default=86400",
    "remove.totalmegabytes int default=1000",
    "remove.age int default=30"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer stateport = null;
    public Logserver.Builder logserver = new Logserver.Builder();
    public Loglevel.Builder loglevel = new Loglevel.Builder();
    public Rotate.Builder rotate = new Rotate.Builder();
    public Remove.Builder remove = new Remove.Builder();

    public Builder() { }

    public Builder(LogdConfig config) {
      stateport(config.stateport());
      logserver(new Logserver.Builder(config.logserver()));
      loglevel(new Loglevel.Builder(config.loglevel()));
      rotate(new Rotate.Builder(config.rotate()));
      remove(new Remove.Builder(config.remove()));
    }

    private Builder override(Builder __superior) {
      if (__superior.stateport != null)
        stateport(__superior.stateport);
      logserver(logserver.override(__superior.logserver));
      loglevel(loglevel.override(__superior.loglevel));
      rotate(rotate.override(__superior.rotate));
      remove(remove.override(__superior.remove));
      return this;
    }

    public Builder stateport(int __value) {
      stateport = __value;
      return this;
    }

    private Builder stateport(String __value) {
      return stateport(Integer.valueOf(__value));
    }

    public Builder logserver(Logserver.Builder __builder) {
      logserver = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder logserver(java.util.function.Consumer<Logserver.Builder> __func) {
      Logserver.Builder __inner = new Logserver.Builder();
      __func.accept(__inner);
      logserver = __inner;
      return this;
    }

    public Builder loglevel(Loglevel.Builder __builder) {
      loglevel = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder loglevel(java.util.function.Consumer<Loglevel.Builder> __func) {
      Loglevel.Builder __inner = new Loglevel.Builder();
      __func.accept(__inner);
      loglevel = __inner;
      return this;
    }

    public Builder rotate(Rotate.Builder __builder) {
      rotate = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder rotate(java.util.function.Consumer<Rotate.Builder> __func) {
      Rotate.Builder __inner = new Rotate.Builder();
      __func.accept(__inner);
      rotate = __inner;
      return this;
    }

    public Builder remove(Remove.Builder __builder) {
      remove = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder remove(java.util.function.Consumer<Remove.Builder> __func) {
      Remove.Builder __inner = new Remove.Builder();
      __func.accept(__inner);
      remove = __inner;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public LogdConfig build() {
      return new LogdConfig(this);
    }

  }

  // Port to serve status and metrics on
  private final IntegerNode stateport;
  private final Logserver logserver;
  private final Loglevel loglevel;
  private final Rotate rotate;
  private final Remove remove;

  public LogdConfig(Builder builder) {
    this(builder, true);
  }

  private LogdConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "logd must be initialized: " + builder.__uninitialized);

    stateport = (builder.stateport == null) ?
        new IntegerNode(0) : new IntegerNode(builder.stateport);
    logserver = new Logserver(builder.logserver, throwIfUninitialized);
    loglevel = new Loglevel(builder.loglevel, throwIfUninitialized);
    rotate = new Rotate(builder.rotate, throwIfUninitialized);
    remove = new Remove(builder.remove, throwIfUninitialized);
  }

  /**
   * @return logd.stateport
   */
  public int stateport() {
    return stateport.value();
  }

  /**
   * @return logd.logserver
   */
  public Logserver logserver() {
    return logserver;
  }

  /**
   * @return logd.loglevel
   */
  public Loglevel loglevel() {
    return loglevel;
  }

  /**
   * @return logd.rotate
   */
  public Rotate rotate() {
    return rotate;
  }

  /**
   * @return logd.remove
   */
  public Remove remove() {
    return remove;
  }

  private ChangesRequiringRestart getChangesRequiringRestart(LogdConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("logd");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents logd.logserver
   */
  public final static class Logserver extends InnerNode { 

    public static class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private String host = null;
      private Integer rpcport = null;
      private Boolean use = null;

      public Builder() { }

      public Builder(Logserver config) {
        host(config.host());
        rpcport(config.rpcport());
        use(config.use());
      }

      private Builder override(Builder __superior) {
        if (__superior.host != null)
          host(__superior.host);
        if (__superior.rpcport != null)
          rpcport(__superior.rpcport);
        if (__superior.use != null)
          use(__superior.use);
        return this;
      }

      public Builder host(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        host = __value;
        return this;
      }


      public Builder rpcport(int __value) {
        rpcport = __value;
        return this;
      }

      private Builder rpcport(String __value) {
        return rpcport(Integer.valueOf(__value));
      }

      public Builder use(boolean __value) {
        use = __value;
        return this;
      }

      private Builder use(String __value) {
        return use(Boolean.valueOf(__value));
      }

      public Logserver build() {
        return new Logserver(this);
      }

    }

    // Host to contact the logserver on.
    private final StringNode host;
    // RPC port of logserver.
    private final IntegerNode rpcport;
    // Forward to a logserver. Other logserver configuration is irrelevant if false.
    private final BooleanNode use;

    public Logserver(Builder builder) {
      this(builder, true);
    }

    private Logserver(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "logd.logserver must be initialized: " + builder.__uninitialized);

      host = (builder.host == null) ?
          new StringNode("localhost") : new StringNode(builder.host);
      rpcport = (builder.rpcport == null) ?
          new IntegerNode(5822) : new IntegerNode(builder.rpcport);
      use = (builder.use == null) ?
          new BooleanNode(true) : new BooleanNode(builder.use);
    }

    /**
     * @return logd.logserver.host
     */
    public String host() {
      return host.value();
    }

    /**
     * @return logd.logserver.rpcport
     */
    public int rpcport() {
      return rpcport.value();
    }

    /**
     * @return logd.logserver.use
     */
    public boolean use() {
      return use.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Logserver newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("logserver");
      return changes;
    }
  }

  /**
   * This class represents logd.loglevel
   */
  public final static class Loglevel extends InnerNode { 

    public static class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public Fatal.Builder fatal = new Fatal.Builder();
      public Error.Builder error = new Error.Builder();
      public Warning.Builder warning = new Warning.Builder();
      public Config.Builder config = new Config.Builder();
      public Info.Builder info = new Info.Builder();
      public Event.Builder event = new Event.Builder();
      public Debug.Builder debug = new Debug.Builder();
      public Spam.Builder spam = new Spam.Builder();

      public Builder() { }

      public Builder(Loglevel config) {
        fatal(new Fatal.Builder(config.fatal()));
        error(new Error.Builder(config.error()));
        warning(new Warning.Builder(config.warning()));
        config(new Config.Builder(config.config()));
        info(new Info.Builder(config.info()));
        event(new Event.Builder(config.event()));
        debug(new Debug.Builder(config.debug()));
        spam(new Spam.Builder(config.spam()));
      }

      private Builder override(Builder __superior) {
        fatal(fatal.override(__superior.fatal));
        error(error.override(__superior.error));
        warning(warning.override(__superior.warning));
        config(config.override(__superior.config));
        info(info.override(__superior.info));
        event(event.override(__superior.event));
        debug(debug.override(__superior.debug));
        spam(spam.override(__superior.spam));
        return this;
      }

      public Builder fatal(Fatal.Builder __builder) {
        fatal = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder fatal(java.util.function.Consumer<Fatal.Builder> __func) {
        Fatal.Builder __inner = new Fatal.Builder();
        __func.accept(__inner);
        fatal = __inner;
        return this;
      }

      public Builder error(Error.Builder __builder) {
        error = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder error(java.util.function.Consumer<Error.Builder> __func) {
        Error.Builder __inner = new Error.Builder();
        __func.accept(__inner);
        error = __inner;
        return this;
      }

      public Builder warning(Warning.Builder __builder) {
        warning = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder warning(java.util.function.Consumer<Warning.Builder> __func) {
        Warning.Builder __inner = new Warning.Builder();
        __func.accept(__inner);
        warning = __inner;
        return this;
      }

      public Builder config(Config.Builder __builder) {
        config = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder config(java.util.function.Consumer<Config.Builder> __func) {
        Config.Builder __inner = new Config.Builder();
        __func.accept(__inner);
        config = __inner;
        return this;
      }

      public Builder info(Info.Builder __builder) {
        info = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder info(java.util.function.Consumer<Info.Builder> __func) {
        Info.Builder __inner = new Info.Builder();
        __func.accept(__inner);
        info = __inner;
        return this;
      }

      public Builder event(Event.Builder __builder) {
        event = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder event(java.util.function.Consumer<Event.Builder> __func) {
        Event.Builder __inner = new Event.Builder();
        __func.accept(__inner);
        event = __inner;
        return this;
      }

      public Builder debug(Debug.Builder __builder) {
        debug = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder debug(java.util.function.Consumer<Debug.Builder> __func) {
        Debug.Builder __inner = new Debug.Builder();
        __func.accept(__inner);
        debug = __inner;
        return this;
      }

      public Builder spam(Spam.Builder __builder) {
        spam = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder spam(java.util.function.Consumer<Spam.Builder> __func) {
        Spam.Builder __inner = new Spam.Builder();
        __func.accept(__inner);
        spam = __inner;
        return this;
      }

      public Loglevel build() {
        return new Loglevel(this);
      }

    }

    private final Fatal fatal;
    private final Error error;
    private final Warning warning;
    private final Config config;
    private final Info info;
    private final Event event;
    private final Debug debug;
    private final Spam spam;

    public Loglevel(Builder builder) {
      this(builder, true);
    }

    private Loglevel(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "logd.loglevel must be initialized: " + builder.__uninitialized);

      fatal = new Fatal(builder.fatal, throwIfUninitialized);
      error = new Error(builder.error, throwIfUninitialized);
      warning = new Warning(builder.warning, throwIfUninitialized);
      config = new Config(builder.config, throwIfUninitialized);
      info = new Info(builder.info, throwIfUninitialized);
      event = new Event(builder.event, throwIfUninitialized);
      debug = new Debug(builder.debug, throwIfUninitialized);
      spam = new Spam(builder.spam, throwIfUninitialized);
    }

    /**
     * @return logd.loglevel.fatal
     */
    public Fatal fatal() {
      return fatal;
    }

    /**
     * @return logd.loglevel.error
     */
    public Error error() {
      return error;
    }

    /**
     * @return logd.loglevel.warning
     */
    public Warning warning() {
      return warning;
    }

    /**
     * @return logd.loglevel.config
     */
    public Config config() {
      return config;
    }

    /**
     * @return logd.loglevel.info
     */
    public Info info() {
      return info;
    }

    /**
     * @return logd.loglevel.event
     */
    public Event event() {
      return event;
    }

    /**
     * @return logd.loglevel.debug
     */
    public Debug debug() {
      return debug;
    }

    /**
     * @return logd.loglevel.spam
     */
    public Spam spam() {
      return spam;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Loglevel newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("loglevel");
      return changes;
    }

    /**
     * This class represents logd.loglevel.fatal
     */
    public final static class Fatal extends InnerNode { 

      public static class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Boolean forward = null;

        public Builder() { }

        public Builder(Fatal config) {
          forward(config.forward());
        }

        private Builder override(Builder __superior) {
          if (__superior.forward != null)
            forward(__superior.forward);
          return this;
        }

        public Builder forward(boolean __value) {
          forward = __value;
          return this;
        }

        private Builder forward(String __value) {
          return forward(Boolean.valueOf(__value));
        }

        public Fatal build() {
          return new Fatal(this);
        }

      }

      // Loglevel config whether they should be stored and/or forwarded
      private final BooleanNode forward;

      public Fatal(Builder builder) {
        this(builder, true);
      }

      private Fatal(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "logd.loglevel.fatal must be initialized: " + builder.__uninitialized);

        forward = (builder.forward == null) ?
            new BooleanNode(true) : new BooleanNode(builder.forward);
      }

      /**
       * @return logd.loglevel.fatal.forward
       */
      public boolean forward() {
        return forward.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Fatal newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("fatal");
        return changes;
      }
    }

    /**
     * This class represents logd.loglevel.error
     */
    public final static class Error extends InnerNode { 

      public static class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Boolean forward = null;

        public Builder() { }

        public Builder(Error config) {
          forward(config.forward());
        }

        private Builder override(Builder __superior) {
          if (__superior.forward != null)
            forward(__superior.forward);
          return this;
        }

        public Builder forward(boolean __value) {
          forward = __value;
          return this;
        }

        private Builder forward(String __value) {
          return forward(Boolean.valueOf(__value));
        }

        public Error build() {
          return new Error(this);
        }

      }

      private final BooleanNode forward;

      public Error(Builder builder) {
        this(builder, true);
      }

      private Error(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "logd.loglevel.error must be initialized: " + builder.__uninitialized);

        forward = (builder.forward == null) ?
            new BooleanNode(true) : new BooleanNode(builder.forward);
      }

      /**
       * @return logd.loglevel.error.forward
       */
      public boolean forward() {
        return forward.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Error newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("error");
        return changes;
      }
    }

    /**
     * This class represents logd.loglevel.warning
     */
    public final static class Warning extends InnerNode { 

      public static class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Boolean forward = null;

        public Builder() { }

        public Builder(Warning config) {
          forward(config.forward());
        }

        private Builder override(Builder __superior) {
          if (__superior.forward != null)
            forward(__superior.forward);
          return this;
        }

        public Builder forward(boolean __value) {
          forward = __value;
          return this;
        }

        private Builder forward(String __value) {
          return forward(Boolean.valueOf(__value));
        }

        public Warning build() {
          return new Warning(this);
        }

      }

      private final BooleanNode forward;

      public Warning(Builder builder) {
        this(builder, true);
      }

      private Warning(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "logd.loglevel.warning must be initialized: " + builder.__uninitialized);

        forward = (builder.forward == null) ?
            new BooleanNode(true) : new BooleanNode(builder.forward);
      }

      /**
       * @return logd.loglevel.warning.forward
       */
      public boolean forward() {
        return forward.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Warning newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("warning");
        return changes;
      }
    }

    /**
     * This class represents logd.loglevel.config
     */
    public final static class Config extends InnerNode { 

      public static class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Boolean forward = null;

        public Builder() { }

        public Builder(Config config) {
          forward(config.forward());
        }

        private Builder override(Builder __superior) {
          if (__superior.forward != null)
            forward(__superior.forward);
          return this;
        }

        public Builder forward(boolean __value) {
          forward = __value;
          return this;
        }

        private Builder forward(String __value) {
          return forward(Boolean.valueOf(__value));
        }

        public Config build() {
          return new Config(this);
        }

      }

      private final BooleanNode forward;

      public Config(Builder builder) {
        this(builder, true);
      }

      private Config(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "logd.loglevel.config must be initialized: " + builder.__uninitialized);

        forward = (builder.forward == null) ?
            new BooleanNode(true) : new BooleanNode(builder.forward);
      }

      /**
       * @return logd.loglevel.config.forward
       */
      public boolean forward() {
        return forward.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Config newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("config");
        return changes;
      }
    }

    /**
     * This class represents logd.loglevel.info
     */
    public final static class Info extends InnerNode { 

      public static class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Boolean forward = null;

        public Builder() { }

        public Builder(Info config) {
          forward(config.forward());
        }

        private Builder override(Builder __superior) {
          if (__superior.forward != null)
            forward(__superior.forward);
          return this;
        }

        public Builder forward(boolean __value) {
          forward = __value;
          return this;
        }

        private Builder forward(String __value) {
          return forward(Boolean.valueOf(__value));
        }

        public Info build() {
          return new Info(this);
        }

      }

      private final BooleanNode forward;

      public Info(Builder builder) {
        this(builder, true);
      }

      private Info(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "logd.loglevel.info must be initialized: " + builder.__uninitialized);

        forward = (builder.forward == null) ?
            new BooleanNode(true) : new BooleanNode(builder.forward);
      }

      /**
       * @return logd.loglevel.info.forward
       */
      public boolean forward() {
        return forward.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Info newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("info");
        return changes;
      }
    }

    /**
     * This class represents logd.loglevel.event
     */
    public final static class Event extends InnerNode { 

      public static class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Boolean forward = null;

        public Builder() { }

        public Builder(Event config) {
          forward(config.forward());
        }

        private Builder override(Builder __superior) {
          if (__superior.forward != null)
            forward(__superior.forward);
          return this;
        }

        public Builder forward(boolean __value) {
          forward = __value;
          return this;
        }

        private Builder forward(String __value) {
          return forward(Boolean.valueOf(__value));
        }

        public Event build() {
          return new Event(this);
        }

      }

      private final BooleanNode forward;

      public Event(Builder builder) {
        this(builder, true);
      }

      private Event(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "logd.loglevel.event must be initialized: " + builder.__uninitialized);

        forward = (builder.forward == null) ?
            new BooleanNode(true) : new BooleanNode(builder.forward);
      }

      /**
       * @return logd.loglevel.event.forward
       */
      public boolean forward() {
        return forward.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Event newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("event");
        return changes;
      }
    }

    /**
     * This class represents logd.loglevel.debug
     */
    public final static class Debug extends InnerNode { 

      public static class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Boolean forward = null;

        public Builder() { }

        public Builder(Debug config) {
          forward(config.forward());
        }

        private Builder override(Builder __superior) {
          if (__superior.forward != null)
            forward(__superior.forward);
          return this;
        }

        public Builder forward(boolean __value) {
          forward = __value;
          return this;
        }

        private Builder forward(String __value) {
          return forward(Boolean.valueOf(__value));
        }

        public Debug build() {
          return new Debug(this);
        }

      }

      private final BooleanNode forward;

      public Debug(Builder builder) {
        this(builder, true);
      }

      private Debug(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "logd.loglevel.debug must be initialized: " + builder.__uninitialized);

        forward = (builder.forward == null) ?
            new BooleanNode(false) : new BooleanNode(builder.forward);
      }

      /**
       * @return logd.loglevel.debug.forward
       */
      public boolean forward() {
        return forward.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Debug newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("debug");
        return changes;
      }
    }

    /**
     * This class represents logd.loglevel.spam
     */
    public final static class Spam extends InnerNode { 

      public static class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Boolean forward = null;

        public Builder() { }

        public Builder(Spam config) {
          forward(config.forward());
        }

        private Builder override(Builder __superior) {
          if (__superior.forward != null)
            forward(__superior.forward);
          return this;
        }

        public Builder forward(boolean __value) {
          forward = __value;
          return this;
        }

        private Builder forward(String __value) {
          return forward(Boolean.valueOf(__value));
        }

        public Spam build() {
          return new Spam(this);
        }

      }

      private final BooleanNode forward;

      public Spam(Builder builder) {
        this(builder, true);
      }

      private Spam(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "logd.loglevel.spam must be initialized: " + builder.__uninitialized);

        forward = (builder.forward == null) ?
            new BooleanNode(false) : new BooleanNode(builder.forward);
      }

      /**
       * @return logd.loglevel.spam.forward
       */
      public boolean forward() {
        return forward.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Spam newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("spam");
        return changes;
      }
    }
  }

  /**
   * This class represents logd.rotate
   */
  public final static class Rotate extends InnerNode { 

    public static class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Integer size = null;
      private Integer age = null;

      public Builder() { }

      public Builder(Rotate config) {
        size(config.size());
        age(config.age());
      }

      private Builder override(Builder __superior) {
        if (__superior.size != null)
          size(__superior.size);
        if (__superior.age != null)
          age(__superior.age);
        return this;
      }

      public Builder size(int __value) {
        size = __value;
        return this;
      }

      private Builder size(String __value) {
        return size(Integer.valueOf(__value));
      }

      public Builder age(int __value) {
        age = __value;
        return this;
      }

      private Builder age(String __value) {
        return age(Integer.valueOf(__value));
      }

      public Rotate build() {
        return new Rotate(this);
      }

    }

    // when the logfile reaches this size, rotate it
    private final IntegerNode size;
    // when the logfile reaches this age (in seconds), rotate it
    private final IntegerNode age;

    public Rotate(Builder builder) {
      this(builder, true);
    }

    private Rotate(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "logd.rotate must be initialized: " + builder.__uninitialized);

      size = (builder.size == null) ?
          new IntegerNode(10000000) : new IntegerNode(builder.size);
      age = (builder.age == null) ?
          new IntegerNode(86400) : new IntegerNode(builder.age);
    }

    /**
     * @return logd.rotate.size
     */
    public int size() {
      return size.value();
    }

    /**
     * @return logd.rotate.age
     */
    public int age() {
      return age.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Rotate newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("rotate");
      return changes;
    }
  }

  /**
   * This class represents logd.remove
   */
  public final static class Remove extends InnerNode { 

    public static class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Integer totalmegabytes = null;
      private Integer age = null;

      public Builder() { }

      public Builder(Remove config) {
        totalmegabytes(config.totalmegabytes());
        age(config.age());
      }

      private Builder override(Builder __superior) {
        if (__superior.totalmegabytes != null)
          totalmegabytes(__superior.totalmegabytes);
        if (__superior.age != null)
          age(__superior.age);
        return this;
      }

      public Builder totalmegabytes(int __value) {
        totalmegabytes = __value;
        return this;
      }

      private Builder totalmegabytes(String __value) {
        return totalmegabytes(Integer.valueOf(__value));
      }

      public Builder age(int __value) {
        age = __value;
        return this;
      }

      private Builder age(String __value) {
        return age(Integer.valueOf(__value));
      }

      public Remove build() {
        return new Remove(this);
      }

    }

    // remove old logfiles so total size does not exceed this (in megabytes)
    private final IntegerNode totalmegabytes;
    // remove old logfiles older than this (in days)
    private final IntegerNode age;

    public Remove(Builder builder) {
      this(builder, true);
    }

    private Remove(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "logd.remove must be initialized: " + builder.__uninitialized);

      totalmegabytes = (builder.totalmegabytes == null) ?
          new IntegerNode(1000) : new IntegerNode(builder.totalmegabytes);
      age = (builder.age == null) ?
          new IntegerNode(30) : new IntegerNode(builder.age);
    }

    /**
     * @return logd.remove.totalmegabytes
     */
    public int totalmegabytes() {
      return totalmegabytes.value();
    }

    /**
     * @return logd.remove.age
     */
    public int age() {
      return age.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Remove newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("remove");
      return changes;
    }
  }

}
