/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.network.rpc;

import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.jrt.slobrok.api.SlobrokList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SlobrokConfigSubscriber
implements ConfigSubscriber.SingleSubscriber<SlobroksConfig> {
    private static final Logger log = Logger.getLogger(SlobrokConfigSubscriber.class.getName());
    private final SlobrokList slobroks = new SlobrokList();
    private ConfigSubscriber subscriber;

    public SlobrokConfigSubscriber(String configId) {
        log.log(Level.FINE, "new location brokerconfig subscriber with config id: " + configId);
        this.subscriber = new ConfigSubscriber();
        this.subscriber.subscribe((ConfigSubscriber.SingleSubscriber)this, SlobroksConfig.class, configId);
    }

    public SlobrokConfigSubscriber(SlobroksConfig slobroksConfig) {
        log.log(Level.FINE, "new location brokerconfig subscriber with fixed list: " + String.valueOf(slobroksConfig));
        this.configure(slobroksConfig);
    }

    public void configure(SlobroksConfig config) {
        String[] list = new String[config.slobrok().size()];
        for (int i = 0; i < config.slobrok().size(); ++i) {
            list[i] = config.slobrok(i).connectionspec();
        }
        this.slobroks.setup(list);
    }

    public SlobrokList getSlobroks() {
        return new SlobrokList(this.slobroks);
    }

    public void shutdown() {
        if (this.subscriber != null) {
            this.subscriber.close();
        }
    }
}

