/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metrics.set;

import ai.vespa.metrics.ContainerMetrics;
import ai.vespa.metrics.HostedNodeAdminMetrics;
import ai.vespa.metrics.SearchNodeMetrics;
import ai.vespa.metrics.StorageMetrics;
import ai.vespa.metrics.set.Metric;
import ai.vespa.metrics.set.MetricSet;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AutoscalingMetrics {
    public static final MetricSet autoscalingMetricSet = AutoscalingMetrics.create();

    private static MetricSet create() {
        ArrayList<String> metrics = new ArrayList<String>();
        metrics.add(HostedNodeAdminMetrics.CPU_UTIL.baseName());
        metrics.add(HostedNodeAdminMetrics.GPU_UTIL.baseName());
        metrics.add(HostedNodeAdminMetrics.MEM_UTIL.baseName());
        metrics.add(HostedNodeAdminMetrics.GPU_MEM_USED.baseName());
        metrics.add(HostedNodeAdminMetrics.GPU_MEM_TOTAL.baseName());
        metrics.add(SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_MEMORY.average());
        metrics.add(HostedNodeAdminMetrics.DISK_UTIL.baseName());
        metrics.add(SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_DISK.average());
        metrics.add(ContainerMetrics.APPLICATION_GENERATION.last());
        metrics.add(SearchNodeMetrics.CONTENT_PROTON_CONFIG_GENERATION.last());
        metrics.add(ContainerMetrics.IN_SERVICE.last());
        metrics.add(ContainerMetrics.QUERIES.rate());
        metrics.add(SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_QUERIES.rate());
        metrics.add(ContainerMetrics.FEED_HTTP_REQUESTS.rate());
        metrics.add(StorageMetrics.VDS_FILESTOR_ALLTHREADS_PUT_COUNT.rate());
        metrics.add(StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_COUNT.rate());
        metrics.add(StorageMetrics.VDS_FILESTOR_ALLTHREADS_UPDATE_COUNT.rate());
        return new MetricSet("autoscaling", AutoscalingMetrics.toMetrics(metrics));
    }

    private static Set<Metric> toMetrics(List<String> metrics) {
        return metrics.stream().map(Metric::new).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }
}

