/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metrics.set;

import ai.vespa.metrics.ClusterControllerMetrics;
import ai.vespa.metrics.ContainerMetrics;
import ai.vespa.metrics.DistributorMetrics;
import ai.vespa.metrics.LogdMetrics;
import ai.vespa.metrics.NodeAdminMetrics;
import ai.vespa.metrics.RoutingLayerMetrics;
import ai.vespa.metrics.SearchNodeMetrics;
import ai.vespa.metrics.SentinelMetrics;
import ai.vespa.metrics.SlobrokMetrics;
import ai.vespa.metrics.StorageMetrics;
import ai.vespa.metrics.Suffix;
import ai.vespa.metrics.VespaMetrics;
import ai.vespa.metrics.set.BasicMetricSets;
import ai.vespa.metrics.set.DefaultVespaMetrics;
import ai.vespa.metrics.set.Metric;
import ai.vespa.metrics.set.MetricSet;
import ai.vespa.metrics.set.MicrometerMetrics;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Vespa9VespaMetricSet {
    public static final MetricSet vespa9vespaMetricSet = Vespa9VespaMetricSet.createMetricSet();

    private static MetricSet createMetricSet() {
        return new MetricSet("vespa9vespa", Vespa9VespaMetricSet.getVespaMetrics(), List.of(DefaultVespaMetrics.defaultVespaMetricSet, BasicMetricSets.containerHttpStatusMetrics(), MicrometerMetrics.asMetricSet()));
    }

    private static Set<Metric> getVespaMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        metrics.addAll(Vespa9VespaMetricSet.getSearchNodeMetrics());
        metrics.addAll(Vespa9VespaMetricSet.getStorageMetrics());
        metrics.addAll(Vespa9VespaMetricSet.getDistributorMetrics());
        metrics.addAll(Vespa9VespaMetricSet.getDocprocMetrics());
        metrics.addAll(Vespa9VespaMetricSet.getClusterControllerMetrics());
        metrics.addAll(Vespa9VespaMetricSet.getSearchChainMetrics());
        metrics.addAll(Vespa9VespaMetricSet.getContainerMetrics());
        metrics.addAll(Vespa9VespaMetricSet.getSentinelMetrics());
        metrics.addAll(Vespa9VespaMetricSet.getOtherMetrics());
        return Collections.unmodifiableSet(metrics);
    }

    private static Set<Metric> getSentinelMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        Vespa9VespaMetricSet.addMetric(metrics, SentinelMetrics.SENTINEL_RESTARTS.count());
        Vespa9VespaMetricSet.addMetric(metrics, SentinelMetrics.SENTINEL_TOTAL_RESTARTS.max());
        return metrics;
    }

    private static Set<Metric> getOtherMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        Vespa9VespaMetricSet.addMetric(metrics, SlobrokMetrics.SLOBROK_HEARTBEATS_FAILED.count());
        Vespa9VespaMetricSet.addMetric(metrics, SlobrokMetrics.SLOBROK_MISSING_CONSENSUS.count());
        Vespa9VespaMetricSet.addMetric(metrics, LogdMetrics.LOGD_PROCESSED_LINES.count());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JRT_TRANSPORT_TLS_CERTIFICATE_VERIFICATION_FAILURES.baseName());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JRT_TRANSPORT_PEER_AUTHORIZATION_FAILURES.baseName());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JRT_TRANSPORT_SERVER_TLS_CONNECTIONS_ESTABLISHED.baseName());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JRT_TRANSPORT_CLIENT_TLS_CONNECTIONS_ESTABLISHED.baseName());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JRT_TRANSPORT_SERVER_UNENCRYPTED_CONNECTIONS_ESTABLISHED.baseName());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JRT_TRANSPORT_CLIENT_UNENCRYPTED_CONNECTIONS_ESTABLISHED.baseName());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_TLS_HANDSHAKES_FAILED.count());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_PEER_AUTHORIZATION_FAILURES.count());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_CLIENT_TLS_CONNECTIONS_ESTABLISHED.count());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_SERVER_TLS_CONNECTIONS_ESTABLISHED.count());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_CLIENT_INSECURE_CONNECTIONS_ESTABLISHED.count());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_SERVER_INSECURE_CONNECTIONS_ESTABLISHED.count());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_TLS_CONNECTIONS_BROKEN.count());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_FAILED_TLS_CONFIG_RELOADS.count());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_RPC_CAPABILITY_CHECKS_FAILED.count());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_STATUS_CAPABILITY_CHECKS_FAILED.count());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_FNET_NUM_CONNECTIONS.count());
        Vespa9VespaMetricSet.addMetric(metrics, NodeAdminMetrics.ENDPOINT_CERTIFICATE_EXPIRY_SECONDS.baseName());
        Vespa9VespaMetricSet.addMetric(metrics, NodeAdminMetrics.NODE_CERTIFICATE_EXPIRY_SECONDS.baseName());
        Vespa9VespaMetricSet.addMetric(metrics, RoutingLayerMetrics.WORKER_CONNECTIONS.max());
        return metrics;
    }

    private static Set<Metric> getContainerMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.APPLICATION_GENERATION.baseName());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HANDLED_REQUESTS.count());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HANDLED_LATENCY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.SERVER_NUM_OPEN_CONNECTIONS, EnumSet.of(Suffix.max, Suffix.average));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.SERVER_NUM_CONNECTIONS, EnumSet.of(Suffix.max, Suffix.average));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.SERVER_BYTES_RECEIVED, EnumSet.of(Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.SERVER_BYTES_SENT, EnumSet.of(Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_THREAD_POOL_UNHANDLED_EXCEPTIONS, EnumSet.of(Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_THREAD_POOL_WORK_QUEUE_CAPACITY, EnumSet.of(Suffix.max));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_THREAD_POOL_WORK_QUEUE_SIZE, EnumSet.of(Suffix.sum, Suffix.count, Suffix.min, Suffix.max));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_THREAD_POOL_REJECTED_TASKS, EnumSet.of(Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_THREAD_POOL_SIZE.max());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_THREAD_POOL_MAX_ALLOWED_SIZE.max());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_THREAD_POOL_ACTIVE_THREADS, EnumSet.of(Suffix.sum, Suffix.count, Suffix.min, Suffix.max));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JETTY_THREADPOOL_BUSY_THREADS, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JETTY_THREADPOOL_TOTAL_THREADS.max());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JETTY_THREADPOOL_QUEUE_SIZE.max());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JETTY_HTTP_COMPLIANCE_VIOLATION.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_PENDING, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_NUM_OPERATIONS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_NUM_UPDATES.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_NUM_REMOVES.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_NUM_PUTS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_SUCCEEDED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_PARSE_ERROR.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_CONDITION_NOT_MET.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_NOT_FOUND.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_FAILED_UNKNOWN.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_FAILED_INSUFFICIENT_STORAGE.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_FAILED_TIMEOUT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_QUEUED_OPERATIONS.last());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_QUEUED_BYTES.last());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_QUEUED_AGE.last());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_MBUS_WINDOW_SIZE.last());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_HEAP_TOTAL.average());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_HEAP_FREE.average());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_HEAP_USED, EnumSet.of(Suffix.average, Suffix.max));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_DIRECT_TOTAL.average());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_DIRECT_FREE.average());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_DIRECT_USED, EnumSet.of(Suffix.average, Suffix.max));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_DIRECT_COUNT.max());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_NATIVE_TOTAL.average());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_NATIVE_FREE.average());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_NATIVE_USED.average());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_MEMORY_MAPPINGS.max());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_OPEN_FILE_DESCRIPTORS.max());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_GC_MS.max());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.CPU.baseName());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_DEACTIVATED_CONTAINERS_TOTAL.sum());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_SINGLETON_IS_ACTIVE, EnumSet.of(Suffix.min, Suffix.max));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_REQUEST_PREMATURELY_CLOSED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_REQUEST_REQUESTS_PER_CONNECTION, EnumSet.of(Suffix.sum, Suffix.count, Suffix.min, Suffix.max, Suffix.average));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_REQUEST_URI_LENGTH, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_REQUEST_CONTENT_SIZE, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_REQUESTS.count());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_MISSING_CLIENT_CERT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_EXPIRED_CLIENT_CERT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_INVALID_CLIENT_CERT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_INCOMPATIBLE_PROTOCOLS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_INCOMPATIBLE_CHIFERS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_CONNECTION_CLOSED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_UNKNOWN.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_FILTER_RULE_BLOCKED_REQUESTS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_FILTER_RULE_ALLOWED_REQUESTS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_HANDLER_UNHANDLED_EXCEPTIONS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_APPLICATION_FAILED_COMPONENT_GRAPHS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_APPLICATION_COMPONENT_GRAPH_RECONFIGURATIONS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.FEED_LATENCY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.FEED_HTTP_REQUESTS, EnumSet.of(Suffix.count, Suffix.rate));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_TLS_CAPABILITY_CHECKS_SUCCEEDED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_TLS_CAPABILITY_CHECKS_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.EMBEDDER_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.EMBEDDER_SEQUENCE_LENGTH, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        return metrics;
    }

    private static Set<Metric> getClusterControllerMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.DOWN_COUNT.max());
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.INITIALIZING_COUNT.max());
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.MAINTENANCE_COUNT.max());
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.RETIRED_COUNT.max());
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.UP_COUNT.max());
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.NODES_NOT_CONVERGED.max());
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.CLUSTER_BUCKETS_OUT_OF_SYNC_RATIO.max());
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.STORED_DOCUMENT_COUNT.max());
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.CLUSTER_STATE_CHANGE_COUNT.baseName());
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.WORK_MS, EnumSet.of(Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.IS_MASTER.max());
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.NODE_EVENT_COUNT.baseName());
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.RESOURCE_USAGE_NODES_ABOVE_LIMIT.max());
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.RESOURCE_USAGE_MAX_MEMORY_UTILIZATION.max());
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.RESOURCE_USAGE_MAX_DISK_UTILIZATION.max());
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.RESOURCE_USAGE_MEMORY_LIMIT.max());
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.RESOURCE_USAGE_DISK_LIMIT.max());
        Vespa9VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.REINDEXING_PROGRESS.max());
        return metrics;
    }

    private static Set<Metric> getDocprocMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        metrics.add(new Metric("documents_processed.rate"));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.DOCPROC_PROC_TIME, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.DOCPROC_DOCUMENTS, EnumSet.of(Suffix.sum));
        return metrics;
    }

    private static Set<Metric> getSearchChainMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.PEAK_QPS.max());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.SEARCH_CONNECTIONS, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.QUERIES.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.QUERY_CONTAINER_LATENCY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.QUERY_LATENCY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.ninety_five_percentile, Suffix.ninety_nine_percentile));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.QUERY_TIMEOUT, EnumSet.of(Suffix.sum, new Suffix[]{Suffix.count, Suffix.max, Suffix.min, Suffix.ninety_five_percentile, Suffix.ninety_nine_percentile}));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.FAILED_QUERIES.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.DEGRADED_QUERIES.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.HITS_PER_QUERY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.ninety_five_percentile, Suffix.ninety_nine_percentile));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.SEARCH_CONNECTIONS, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.QUERY_HIT_OFFSET, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.DOCUMENTS_COVERED.count());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.DOCUMENTS_TOTAL.count());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.DOCUMENTS_TARGET_TOTAL.count());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_RENDER_LATENCY, EnumSet.of(Suffix.min, Suffix.max, Suffix.count, Suffix.sum));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.QUERY_ITEM_COUNT, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.TOTAL_HITS_PER_QUERY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.ninety_five_percentile, Suffix.ninety_nine_percentile));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.EMPTY_RESULTS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.REQUESTS_OVER_QUOTA, EnumSet.of(Suffix.rate, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.RELEVANCE_AT_1, EnumSet.of(Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.RELEVANCE_AT_3, EnumSet.of(Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.RELEVANCE_AT_10, EnumSet.of(Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_TIMEOUT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_BACKENDS_OOS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_PLUGIN_FAILURE.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_BACKEND_COMMUNICATION_ERROR.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_EMPTY_DOCUMENT_SUMMARIES.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_INVALID_QUERY_PARAMETER.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_INTERNAL_SERVER_ERROR.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_MISCONFIGURED_SERVER.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_INVALID_QUERY_TRANSFORMATION.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_RESULTS_WITH_ERRORS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_UNSPECIFIED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_UNHANDLED_EXCEPTION.rate());
        return metrics;
    }

    private static Set<Metric> getSearchNodeMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_DOCUMENTS_TOTAL.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_DOCUMENTS_READY.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_DOCUMENTS_ACTIVE.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_DOCUMENTS_REMOVED.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_INDEX_DOCS_IN_MEMORY.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_HEART_BEAT_AGE.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCSUM_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_SEARCH_PROTOCOL_QUERY_REQUEST_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_SEARCH_PROTOCOL_QUERY_REPLY_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_SEARCH_PROTOCOL_DOCSUM_REQUEST_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_SEARCH_PROTOCOL_DOCSUM_REPLY_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_PROTON_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_PROTON_ACCEPTED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_PROTON_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_FLUSH_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_FLUSH_ACCEPTED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_MATCH_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_MATCH_ACCEPTED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_MATCH_WAKEUPS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_MATCH_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_DOCSUM_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_DOCSUM_ACCEPTED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_DOCSUM_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_SHARED_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_SHARED_ACCEPTED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_SHARED_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_WARMUP_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_WARMUP_ACCEPTED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_WARMUP_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_FIELD_WRITER_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_FIELD_WRITER_ACCEPTED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_FIELD_WRITER_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_FIELD_WRITER_SATURATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_JOB_ATTRIBUTE_FLUSH.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_JOB_MEMORY_INDEX_FLUSH.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_JOB_DISK_INDEX_FUSION.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_JOB_DOCUMENT_STORE_FLUSH.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_JOB_DOCUMENT_STORE_COMPACT.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_JOB_BUCKET_MOVE.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_JOB_LID_SPACE_COMPACT.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_JOB_REMOVED_DOCUMENTS_PRUNE.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_MASTER_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_MASTER_ACCEPTED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_MASTER_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_INDEX_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_INDEX_ACCEPTED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_INDEX_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_SUMMARY_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_SUMMARY_ACCEPTED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_SUMMARY_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_LID_SPACE_LID_LIMIT.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_LID_SPACE_USED_LIDS.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_LID_SPACE_LID_LIMIT.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_LID_SPACE_USED_LIDS.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_REMOVED_LID_SPACE_LID_LIMIT.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_REMOVED_LID_SPACE_USED_LIDS.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_BUCKET_MOVE_BUCKETS_PENDING.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_DISK.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_DISK_USAGE_TOTAL.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_DISK_USAGE_TOTAL_UTILIZATION.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_DISK_USAGE_TRANSIENT.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_MEMORY.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_MEMORY_USAGE_TOTAL.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_MEMORY_USAGE_TOTAL_UTILIZATION.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_MEMORY_USAGE_TRANSIENT.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_MEMORY_MAPPINGS.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_MALLOC_ARENA.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_ATTRIBUTE_RESOURCE_USAGE_ADDRESS_SPACE.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_ATTRIBUTE_RESOURCE_USAGE_FEEDING_BLOCKED.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_CPU_UTIL_SETUP, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_CPU_UTIL_READ, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_CPU_UTIL_WRITE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_CPU_UTIL_COMPACT, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_CPU_UTIL_OTHER, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_TRANSACTIONLOG_ENTRIES.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_DISK_USAGE.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_DISK_BLOAT.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_MAX_BUCKET_SPREAD.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_MEMORY_USAGE_ALLOCATED_BYTES.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_DISK_USAGE.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_DISK_BLOAT.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_MAX_BUCKET_SPREAD.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_MEMORY_USAGE_ALLOCATED_BYTES.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_REMOVED_DOCUMENT_STORE_MEMORY_USAGE_ALLOCATED_BYTES.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_CACHE_MEMORY_USAGE.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_CACHE_HIT_RATE.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_CACHE_LOOKUPS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_CACHE_INVALIDATIONS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_CACHE_MEMORY_USAGE.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_CACHE_HIT_RATE.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_CACHE_LOOKUPS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_CACHE_INVALIDATIONS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_ATTRIBUTE_MEMORY_USAGE_ALLOCATED_BYTES.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_ATTRIBUTE_DISK_USAGE.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_ATTRIBUTE_MEMORY_USAGE_ALLOCATED_BYTES.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_INDEX_INDEXES.max());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_INDEX_MEMORY_USAGE_ALLOCATED_BYTES.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_INDEX_IO_SEARCH_READ_BYTES, EnumSet.of(Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_INDEX_IO_SEARCH_CACHED_READ_BYTES, EnumSet.of(Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_INDEX_DISK_USAGE.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_INDEX_CACHE_POSTINGLIST_MEMORY_USAGE.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_INDEX_CACHE_POSTINGLIST_HIT_RATE.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_INDEX_CACHE_POSTINGLIST_LOOKUPS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_INDEX_CACHE_POSTINGLIST_INVALIDATIONS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_INDEX_CACHE_BITVECTOR_MEMORY_USAGE.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_INDEX_CACHE_BITVECTOR_HIT_RATE.average());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_INDEX_CACHE_BITVECTOR_LOOKUPS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_INDEX_CACHE_BITVECTOR_INVALIDATIONS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_QUERIES.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_QUERY_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_QUERY_SETUP_TIME, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_DOCS_MATCHED, EnumSet.of(Suffix.rate));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_QUERIES.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_SOFT_DOOMED_QUERIES.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_SOFT_DOOM_FACTOR, EnumSet.of(Suffix.min, Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_QUERY_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_QUERY_SETUP_TIME, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_GROUPING_TIME, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_RERANK_TIME, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_DOCS_MATCHED, EnumSet.of(Suffix.rate, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_LIMITED_QUERIES.rate());
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_FEEDING_COMMIT_OPERATIONS, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count, Suffix.rate));
        Vespa9VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_FEEDING_COMMIT_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        return metrics;
    }

    private static Set<Metric> getStorageMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_DATASTORED_ALLDISKS_BUCKETS.average());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_DATASTORED_ALLDISKS_DOCS.average());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_DATASTORED_ALLDISKS_BYTES.average());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_VISITOR_ALLTHREADS_AVERAGEVISITORLIFETIME, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_VISITOR_ALLTHREADS_AVERAGEQUEUEWAIT, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_VISITOR_ALLTHREADS_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_VISITOR_ALLTHREADS_COMPLETED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_VISITOR_ALLTHREADS_CREATED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_VISITOR_ALLTHREADS_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_VISITOR_ALLTHREADS_AVERAGEMESSAGESENDTIME, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_VISITOR_ALLTHREADS_AVERAGEPROCESSINGTIME, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_AVERAGEQUEUEWAIT, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ACTIVE_OPERATIONS_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ACTIVE_OPERATIONS_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_THROTTLE_WINDOW_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_THROTTLE_WAITING_THREADS, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_THROTTLE_ACTIVE_TOKENS, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_MERGEMETADATAREADLATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_MERGEDATAREADLATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_MERGEDATAWRITELATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_MERGE_PUT_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_MERGE_REMOVE_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLSTRIPES_THROTTLED_RPC_DIRECT_DISPATCHES.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLSTRIPES_THROTTLED_PERSISTENCE_THREAD_POLLS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLSTRIPES_TIMEOUTS_WAITING_FOR_THROTTLE_TOKEN.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_PUT_COUNT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_PUT_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_PUT_TEST_AND_SET_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_PUT_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_PUT_REQUEST_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_COUNT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_TEST_AND_SET_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_REQUEST_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_GET_COUNT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_GET_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_GET_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_GET_REQUEST_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_UPDATE_COUNT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_UPDATE_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_UPDATE_TEST_AND_SET_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_UPDATE_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_UPDATE_REQUEST_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_CREATEITERATOR_COUNT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_CREATEITERATOR_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_VISIT_COUNT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_VISIT_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_LOCATION_COUNT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_LOCATION_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_SPLITBUCKETS_COUNT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_JOINBUCKETS_COUNT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_DELETEBUCKETS_COUNT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_DELETEBUCKETS_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_DELETEBUCKETS_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_BY_GID_COUNT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_BY_GID_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_BY_GID_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_SETBUCKETSTATES_COUNT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_AVERAGEQUEUEWAITINGTIME, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_ACTIVE_WINDOW_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_ESTIMATED_MERGE_MEMORY_USAGE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_BOUNCED_DUE_TO_BACK_PRESSURE.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_LOCALLYEXECUTEDMERGES_OK.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_MERGECHAINS_OK.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_MERGECHAINS_FAILURES_BUSY.rate());
        Vespa9VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_MERGECHAINS_FAILURES_TOTAL.rate());
        return metrics;
    }

    private static Set<Metric> getDistributorMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_BUCKETS_RECHECKING.average());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_IDEALSTATE_DIFF.average());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_BUCKETS_TOOFEWCOPIES.average());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_BUCKETS_TOOMANYCOPIES.average());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_BUCKETS.average());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_BUCKETS_NOTRUSTED.average());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_MAX_OBSERVED_TIME_SINCE_LAST_GC_SEC.average());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_DELETE_BUCKET_DONE_OK.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_DELETE_BUCKET_DONE_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_DELETE_BUCKET_PENDING.average());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_MERGE_BUCKET_DONE_OK.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_MERGE_BUCKET_DONE_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_MERGE_BUCKET_PENDING.average());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_SPLIT_BUCKET_DONE_OK.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_SPLIT_BUCKET_DONE_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_SPLIT_BUCKET_PENDING.average());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_JOIN_BUCKET_DONE_OK.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_JOIN_BUCKET_DONE_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_JOIN_BUCKET_PENDING.average());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_GARBAGE_COLLECTION_DONE_OK.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_GARBAGE_COLLECTION_DONE_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_GARBAGE_COLLECTION_PENDING.average());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_GARBAGE_COLLECTION_DOCUMENTS_REMOVED, EnumSet.of(Suffix.count, Suffix.rate));
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_OK.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_TOTAL.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_NOTFOUND.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_TEST_AND_SET_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_CONCURRENT_MUTATIONS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_NOTCONNECTED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_NOTREADY.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_WRONGDISTRIBUTOR.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_SAFE_TIME_NOT_REACHED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_STORAGEFAILURE.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_TIMEOUT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_BUSY.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_INCONSISTENT_BUCKET.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_REMOVES_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_REMOVES_OK.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_REMOVES_FAILURES_TOTAL.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_REMOVES_FAILURES_NOTFOUND.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_REMOVES_FAILURES_TEST_AND_SET_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_REMOVES_FAILURES_CONCURRENT_MUTATIONS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_UPDATES_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_UPDATES_OK.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_UPDATES_FAILURES_TOTAL.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_UPDATES_FAILURES_NOTFOUND.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_UPDATES_FAILURES_TEST_AND_SET_FAILED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_UPDATES_FAILURES_CONCURRENT_MUTATIONS.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_UPDATES_DIVERGING_TIMESTAMP_UPDATES.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_REMOVELOCATIONS_OK.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_REMOVELOCATIONS_FAILURES_TOTAL.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_GETS_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_GETS_OK.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_GETS_FAILURES_TOTAL.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_GETS_FAILURES_NOTFOUND.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_OK.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_TOTAL.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_NOTREADY.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_NOTCONNECTED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_WRONGDISTRIBUTOR.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_SAFE_TIME_NOT_REACHED.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_STORAGEFAILURE.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_TIMEOUT.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_BUSY.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_INCONSISTENT_BUCKET.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_NOTFOUND.rate());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_DOCSSTORED.average());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_BYTESSTORED.average());
        Vespa9VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_BOUNCER_CLOCK_SKEW_ABORTS.count());
        return metrics;
    }

    private static void addMetric(Set<Metric> metrics, String nameWithSuffix) {
        metrics.add(new Metric(nameWithSuffix));
    }

    private static void addMetric(Set<Metric> metrics, VespaMetrics metric, EnumSet<Suffix> suffixes) {
        suffixes.forEach(suffix -> metrics.add(new Metric(metric.baseName() + "." + suffix.suffix())));
    }

    private static void addMetric(Set<Metric> metrics, String metricName, Iterable<String> aggregateSuffices) {
        for (String suffix : aggregateSuffices) {
            metrics.add(new Metric(metricName + "." + suffix));
        }
    }
}

