/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metrics.docs;

import ai.vespa.metrics.ClusterControllerMetrics;
import ai.vespa.metrics.ConfigServerMetrics;
import ai.vespa.metrics.ContainerMetrics;
import ai.vespa.metrics.DistributorMetrics;
import ai.vespa.metrics.LogdMetrics;
import ai.vespa.metrics.NodeAdminMetrics;
import ai.vespa.metrics.SearchNodeMetrics;
import ai.vespa.metrics.SentinelMetrics;
import ai.vespa.metrics.SlobrokMetrics;
import ai.vespa.metrics.StorageMetrics;
import ai.vespa.metrics.Unit;
import ai.vespa.metrics.VespaMetrics;
import ai.vespa.metrics.docs.MetricDocumentation;
import ai.vespa.metrics.docs.MetricSetDocumentation;
import ai.vespa.metrics.docs.UnitDocumentation;
import ai.vespa.metrics.set.DefaultMetrics;
import ai.vespa.metrics.set.MetricSet;
import ai.vespa.metrics.set.MicrometerMetrics;
import ai.vespa.metrics.set.VespaMetricSet;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;

public class DocumentationGenerator {
    public static void main(String[] args) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Expected exactly one argument: directory to write to");
        }
        String path = args[0];
        Map<String, VespaMetrics[]> metrics = DocumentationGenerator.getMetrics();
        metrics.forEach((metricType, metricArray) -> MetricDocumentation.writeMetricDocumentation(path, metricArray, metricType));
        Map<String, MetricSet> metricSets = DocumentationGenerator.getMetricSets();
        metricSets.forEach((name, metricSet) -> MetricSetDocumentation.writeMetricSetDocumentation(path, name, metricSet, metrics));
        UnitDocumentation.writeUnitDocumentation(path, Unit.values());
    }

    private static Map<String, VespaMetrics[]> getMetrics() {
        return Map.of("Container", (VespaMetrics[])Stream.concat(Arrays.stream(ContainerMetrics.values()), Arrays.stream(MicrometerMetrics.values())).toArray(VespaMetrics[]::new), "SearchNode", SearchNodeMetrics.values(), "Storage", StorageMetrics.values(), "Distributor", DistributorMetrics.values(), "ConfigServer", ConfigServerMetrics.values(), "Logd", LogdMetrics.values(), "NodeAdmin", NodeAdminMetrics.values(), "Slobrok", SlobrokMetrics.values(), "Sentinel", SentinelMetrics.values(), "ClusterController", ClusterControllerMetrics.values());
    }

    private static Map<String, MetricSet> getMetricSets() {
        return Map.of("Vespa", VespaMetricSet.vespaMetricSet, "Default", DefaultMetrics.defaultMetricSet);
    }
}

