/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metrics.set;

import ai.vespa.metrics.ClusterControllerMetrics;
import ai.vespa.metrics.ContainerMetrics;
import ai.vespa.metrics.DistributorMetrics;
import ai.vespa.metrics.NodeAdminMetrics;
import ai.vespa.metrics.SearchNodeMetrics;
import ai.vespa.metrics.SentinelMetrics;
import ai.vespa.metrics.StorageMetrics;
import ai.vespa.metrics.Suffix;
import ai.vespa.metrics.set.DefaultVespaMetrics;
import ai.vespa.metrics.set.MetricSet;
import java.util.EnumSet;
import java.util.List;

public class DefaultMetrics {
    public static final String defaultMetricSetId = "default";
    public static final MetricSet defaultMetricSet = DefaultMetrics.createMetricSet();

    private static MetricSet createMetricSet() {
        return new MetricSet(defaultMetricSetId, List.of(), List.of(DefaultVespaMetrics.defaultVespaMetricSet, DefaultMetrics.getContainerMetrics(), DefaultMetrics.getSearchChainMetrics(), DefaultMetrics.getDocprocMetrics(), DefaultMetrics.getSearchNodeMetrics(), DefaultMetrics.getContentMetrics(), DefaultMetrics.getStorageMetrics(), DefaultMetrics.getDistributorMetrics(), DefaultMetrics.getClusterControllerMetrics(), DefaultMetrics.getSentinelMetrics(), DefaultMetrics.getOtherMetrics()));
    }

    private static MetricSet getContainerMetrics() {
        return new MetricSet.Builder("default-container").metric(ContainerMetrics.HTTP_STATUS_1XX.rate()).metric(ContainerMetrics.HTTP_STATUS_2XX.rate()).metric(ContainerMetrics.HTTP_STATUS_3XX.rate()).metric(ContainerMetrics.HTTP_STATUS_4XX.rate()).metric(ContainerMetrics.HTTP_STATUS_5XX.rate()).metric(ContainerMetrics.JDISC_GC_MS, EnumSet.of(Suffix.max, Suffix.average)).metric(ContainerMetrics.MEM_HEAP_FREE.average()).metric(ContainerMetrics.FEED_LATENCY, EnumSet.of(Suffix.sum, Suffix.count)).metric(ContainerMetrics.JDISC_THREAD_POOL_SIZE.max()).metric(ContainerMetrics.JDISC_THREAD_POOL_ACTIVE_THREADS, EnumSet.of(Suffix.sum, Suffix.count, Suffix.min, Suffix.max)).metric(ContainerMetrics.JDISC_THREAD_POOL_WORK_QUEUE_CAPACITY.max()).metric(ContainerMetrics.JDISC_THREAD_POOL_WORK_QUEUE_SIZE, EnumSet.of(Suffix.sum, Suffix.count, Suffix.min, Suffix.max)).metric(ContainerMetrics.SERVER_ACTIVE_THREADS.average()).metric(ContainerMetrics.JDISC_SINGLETON_IS_ACTIVE, EnumSet.of(Suffix.max, Suffix.last)).metric(ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_MISSING_CLIENT_CERT.rate()).metric(ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_INCOMPATIBLE_PROTOCOLS.rate()).metric(ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_INCOMPATIBLE_CHIFERS.rate()).metric(ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_UNKNOWN.rate()).metric(ContainerMetrics.JDISC_APPLICATION_FAILED_COMPONENT_GRAPHS.rate()).metric(ContainerMetrics.ATHENZ_TENANT_CERT_EXPIRY_SECONDS, EnumSet.of(Suffix.min, Suffix.max, Suffix.last)).build();
    }

    private static MetricSet getSearchChainMetrics() {
        return new MetricSet.Builder("default-search-chain").metric(ContainerMetrics.QUERIES.rate()).metric(ContainerMetrics.QUERY_LATENCY, EnumSet.of(Suffix.sum, new Suffix[]{Suffix.count, Suffix.max, Suffix.ninety_five_percentile, Suffix.ninety_nine_percentile, Suffix.average})).metric(ContainerMetrics.HITS_PER_QUERY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.average)).metric(ContainerMetrics.TOTAL_HITS_PER_QUERY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.average)).metric(ContainerMetrics.DEGRADED_QUERIES.rate()).metric(ContainerMetrics.FAILED_QUERIES.rate()).build();
    }

    private static MetricSet getDocprocMetrics() {
        return new MetricSet.Builder("default-docproc").metric(ContainerMetrics.DOCPROC_DOCUMENTS.sum()).build();
    }

    private static MetricSet getSearchNodeMetrics() {
        return new MetricSet.Builder("default-search-node").metric(SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_DISK.average()).metric(SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_MEMORY.average()).metric(SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_FEEDING_BLOCKED, EnumSet.of(Suffix.max, Suffix.last)).build();
    }

    private static MetricSet getContentMetrics() {
        return new MetricSet.Builder("default-content").metric(SearchNodeMetrics.CONTENT_PROTON_SEARCH_PROTOCOL_DOCSUM_REQUESTED_DOCUMENTS.rate()).metric(SearchNodeMetrics.CONTENT_PROTON_SEARCH_PROTOCOL_DOCSUM_LATENCY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.average)).metric(SearchNodeMetrics.CONTENT_PROTON_SEARCH_PROTOCOL_QUERY_LATENCY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.average)).metric(SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_DOCUMENTS_TOTAL, EnumSet.of(Suffix.max, Suffix.last)).metric(SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_DOCUMENTS_READY, EnumSet.of(Suffix.max, Suffix.last)).metric(SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_DOCUMENTS_ACTIVE, EnumSet.of(Suffix.max, Suffix.last)).metric(SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_DISK_USAGE.last()).metric(SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MEMORY_USAGE_ALLOCATED_BYTES.last()).metric(SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_DISK.average()).metric(SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_MEMORY.average()).metric(SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_DOCS_MATCHED.rate()).metric(SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_DOCS_RERANKED.rate()).metric(SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_QUERY_SETUP_TIME, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.average)).metric(SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_QUERY_LATENCY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.average)).metric(SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_RERANK_TIME, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.average)).metric(SearchNodeMetrics.CONTENT_PROTON_TRANSACTIONLOG_DISK_USAGE.last()).build();
    }

    private static MetricSet getStorageMetrics() {
        return new MetricSet.Builder("default-storage").metric(StorageMetrics.VDS_FILESTOR_ALLTHREADS_PUT_COUNT.rate()).metric(StorageMetrics.VDS_FILESTOR_ALLTHREADS_UPDATE_COUNT.rate()).metric(StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_COUNT.rate()).build();
    }

    private static MetricSet getDistributorMetrics() {
        return new MetricSet.Builder("default-distributor").metric(DistributorMetrics.VDS_DISTRIBUTOR_DOCSSTORED.average()).metric(DistributorMetrics.VDS_BOUNCER_CLOCK_SKEW_ABORTS.count()).build();
    }

    private static MetricSet getClusterControllerMetrics() {
        return new MetricSet.Builder("default-cluster-controller").metric(ClusterControllerMetrics.DOWN_COUNT, EnumSet.of(Suffix.max, Suffix.last)).metric(ClusterControllerMetrics.MAINTENANCE_COUNT, EnumSet.of(Suffix.max, Suffix.last)).metric(ClusterControllerMetrics.UP_COUNT, EnumSet.of(Suffix.max, Suffix.last)).metric(ClusterControllerMetrics.IS_MASTER, EnumSet.of(Suffix.max, Suffix.last)).metric(ClusterControllerMetrics.RESOURCE_USAGE_NODES_ABOVE_LIMIT, EnumSet.of(Suffix.max, Suffix.last)).metric(ClusterControllerMetrics.RESOURCE_USAGE_MAX_MEMORY_UTILIZATION, EnumSet.of(Suffix.last, Suffix.max)).metric(ClusterControllerMetrics.RESOURCE_USAGE_MAX_DISK_UTILIZATION, EnumSet.of(Suffix.last, Suffix.max)).build();
    }

    private static MetricSet getSentinelMetrics() {
        return new MetricSet.Builder("default-sentinel").metric(SentinelMetrics.SENTINEL_TOTAL_RESTARTS, EnumSet.of(Suffix.max, Suffix.sum, Suffix.last)).build();
    }

    private static MetricSet getOtherMetrics() {
        return new MetricSet.Builder("default-other").metric(NodeAdminMetrics.ENDPOINT_CERTIFICATE_EXPIRY_SECONDS.baseName()).metric(NodeAdminMetrics.NODE_CERTIFICATE_EXPIRY_SECONDS.baseName()).build();
    }

    private DefaultMetrics() {
    }
}

