/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.opennlp;

import com.yahoo.language.Language;
import com.yahoo.language.detect.Detection;
import com.yahoo.language.detect.Detector;
import com.yahoo.language.detect.Hint;
import com.yahoo.language.simple.SimpleDetector;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import opennlp.tools.langdetect.LanguageDetectorConfig;
import opennlp.tools.langdetect.LanguageDetectorME;
import opennlp.tools.langdetect.LanguageDetectorModel;

class OpenNlpDetector
implements Detector {
    private static final Object monitor = new Object();
    private static LanguageDetectorModel model;
    private final SimpleDetector simple = new SimpleDetector();
    private final Map<String, Language> languagesByISO3 = new HashMap<String, Language>();
    private final LanguageDetectorME detector = new LanguageDetectorME(OpenNlpDetector.loadModel());
    private final LanguageDetectorConfig config = new LanguageDetectorConfig();

    OpenNlpDetector() {
        this.config.setMinDiff(0.02);
        this.config.setChunkSize(32);
        this.config.setMaxLength(256);
        for (Locale locale : Locale.getAvailableLocales()) {
            Language language = Language.fromLocale((Locale)locale);
            if (language == null) continue;
            this.languagesByISO3.put(locale.getISO3Language(), language);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LanguageDetectorModel loadModel() {
        Object object = monitor;
        synchronized (object) {
            if (model == null) {
                try {
                    model = new LanguageDetectorModel(OpenNlpDetector.class.getResourceAsStream("/models/langdetect-183.bin"));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        return model;
    }

    public Detection detect(byte[] input, int offset, int length, Hint hint) {
        Charset encoding = Charset.forName(this.simple.guessEncoding(input, offset, length));
        return new Detection(this.detectLanguage(new String(input, offset, length, encoding)), encoding.name(), false);
    }

    public Detection detect(ByteBuffer input, Hint hint) {
        if (input.hasArray()) {
            return this.detect(input.array(), input.arrayOffset() + input.position(), input.remaining(), hint);
        }
        byte[] buffer = new byte[input.remaining()];
        input.get(buffer);
        return this.detect(buffer, 0, buffer.length, hint);
    }

    public Detection detect(String input, Hint hint) {
        return new Detection(this.detectLanguage(input), StandardCharsets.UTF_8.name(), false);
    }

    private Language detectLanguage(String input) {
        opennlp.tools.langdetect.Language prediction = this.detector.probingPredictLanguages((CharSequence)input, this.config).getLanguages()[0];
        Language result = prediction.getConfidence() > 0.02 ? this.languagesByISO3.get(prediction.getLang()) : null;
        return result != null ? result : this.simple.guessLanguage(input.substring(0, Math.min(input.length(), 256)));
    }
}

