/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.opennlp;

import com.yahoo.language.Language;
import com.yahoo.language.LinguisticsCase;
import com.yahoo.language.process.Normalizer;
import com.yahoo.language.process.SpecialTokenRegistry;
import com.yahoo.language.process.StemMode;
import com.yahoo.language.process.Token;
import com.yahoo.language.process.Tokenizer;
import com.yahoo.language.process.Transformer;
import com.yahoo.language.simple.SimpleNormalizer;
import com.yahoo.language.simple.SimpleTokenizer;
import com.yahoo.language.simple.SimpleTransformer;
import java.util.List;
import opennlp.tools.stemmer.Stemmer;
import opennlp.tools.stemmer.snowball.SnowballStemmer;

public class OpenNlpTokenizer
implements Tokenizer {
    private final Normalizer normalizer;
    private final Transformer transformer;
    private final SimpleTokenizer simpleTokenizer;
    private final SpecialTokenRegistry specialTokenRegistry;

    public OpenNlpTokenizer() {
        this((Normalizer)new SimpleNormalizer(), (Transformer)new SimpleTransformer());
    }

    public OpenNlpTokenizer(Normalizer normalizer, Transformer transformer) {
        this(normalizer, transformer, new SpecialTokenRegistry(List.of()));
    }

    public OpenNlpTokenizer(Normalizer normalizer, Transformer transformer, SpecialTokenRegistry specialTokenRegistry) {
        this.normalizer = normalizer;
        this.transformer = transformer;
        this.specialTokenRegistry = specialTokenRegistry;
        this.simpleTokenizer = new SimpleTokenizer(normalizer, transformer, specialTokenRegistry);
    }

    public Iterable<Token> tokenize(String input, Language language, StemMode stemMode, boolean removeAccents) {
        Stemmer stemmer = this.stemmerFor(language, stemMode);
        if (stemmer == null) {
            return this.simpleTokenizer.tokenize(input, language, stemMode, removeAccents);
        }
        return this.simpleTokenizer.tokenize(input, token -> this.processToken((String)token, language, stemMode, removeAccents, stemmer));
    }

    private String processToken(String token, Language language, StemMode stemMode, boolean removeAccents, Stemmer stemmer) {
        token = this.normalizer.normalize(token);
        token = LinguisticsCase.toLowerCase((String)token);
        if (removeAccents) {
            token = this.transformer.accentDrop(token, language);
        }
        if (stemMode != StemMode.NONE) {
            token = stemmer.stem((CharSequence)token).toString();
        }
        return token;
    }

    private Stemmer stemmerFor(Language language, StemMode stemMode) {
        if (language == null || language == Language.ENGLISH || stemMode == StemMode.NONE) {
            return null;
        }
        SnowballStemmer.ALGORITHM algorithm = this.algorithmFor(language);
        if (algorithm == null) {
            return null;
        }
        return new SnowballStemmer(algorithm);
    }

    private SnowballStemmer.ALGORITHM algorithmFor(Language language) {
        return switch (language) {
            case Language.DANISH -> SnowballStemmer.ALGORITHM.DANISH;
            case Language.DUTCH -> SnowballStemmer.ALGORITHM.DUTCH;
            case Language.FINNISH -> SnowballStemmer.ALGORITHM.FINNISH;
            case Language.FRENCH -> SnowballStemmer.ALGORITHM.FRENCH;
            case Language.GERMAN -> SnowballStemmer.ALGORITHM.GERMAN;
            case Language.HUNGARIAN -> SnowballStemmer.ALGORITHM.HUNGARIAN;
            case Language.IRISH -> SnowballStemmer.ALGORITHM.IRISH;
            case Language.ITALIAN -> SnowballStemmer.ALGORITHM.ITALIAN;
            case Language.NORWEGIAN_BOKMAL -> SnowballStemmer.ALGORITHM.NORWEGIAN;
            case Language.NORWEGIAN_NYNORSK -> SnowballStemmer.ALGORITHM.NORWEGIAN;
            case Language.PORTUGUESE -> SnowballStemmer.ALGORITHM.PORTUGUESE;
            case Language.ROMANIAN -> SnowballStemmer.ALGORITHM.ROMANIAN;
            case Language.RUSSIAN -> SnowballStemmer.ALGORITHM.RUSSIAN;
            case Language.SPANISH -> SnowballStemmer.ALGORITHM.SPANISH;
            case Language.SWEDISH -> SnowballStemmer.ALGORITHM.SWEDISH;
            case Language.TURKISH -> SnowballStemmer.ALGORITHM.TURKISH;
            case Language.ENGLISH -> SnowballStemmer.ALGORITHM.ENGLISH;
            default -> null;
        };
    }
}

