/**
 * This file is generated from a config definition file.
 * ------------   D O   N O T   E D I T !   ------------
 */

package com.yahoo.searchlib;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of translogserver
 *
 * Copyright Yahoo. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class TranslogserverConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "c1ce57179c37c70725be8631e6ab0ef0";
  public final static String CONFIG_DEF_NAME = "translogserver";
  public final static String CONFIG_DEF_NAMESPACE = "searchlib";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=searchlib",
    "listenport int default=13700 restart",
    "filesizemax int default=50000000",
    "servername string default=\"tls\" restart",
    "basedir string default=\"tmp\" restart",
    "usefsync bool default=true",
    "maxthreads int default=0 restart",
    "crcmethod enum {ccitt_crc32, xxh64} default=xxh64",
    "compression.type enum {NONE, NONE_MULTI, LZ4, ZSTD} default=ZSTD",
    "compression.level int default=3",
    "chunk.sizelimit int default = 256000"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer listenport = null;
    private Integer filesizemax = null;
    private String servername = null;
    private String basedir = null;
    private Boolean usefsync = null;
    private Integer maxthreads = null;
    private Crcmethod.Enum crcmethod = null;
    public Compression.Builder compression = new Compression.Builder();
    public Chunk.Builder chunk = new Chunk.Builder();

    public Builder() { }

    public Builder(TranslogserverConfig config) {
      listenport(config.listenport());
      filesizemax(config.filesizemax());
      servername(config.servername());
      basedir(config.basedir());
      usefsync(config.usefsync());
      maxthreads(config.maxthreads());
      crcmethod(config.crcmethod());
      compression(new Compression.Builder(config.compression()));
      chunk(new Chunk.Builder(config.chunk()));
    }

    private Builder override(Builder __superior) {
      if (__superior.listenport != null)
        listenport(__superior.listenport);
      if (__superior.filesizemax != null)
        filesizemax(__superior.filesizemax);
      if (__superior.servername != null)
        servername(__superior.servername);
      if (__superior.basedir != null)
        basedir(__superior.basedir);
      if (__superior.usefsync != null)
        usefsync(__superior.usefsync);
      if (__superior.maxthreads != null)
        maxthreads(__superior.maxthreads);
      if (__superior.crcmethod != null)
        crcmethod(__superior.crcmethod);
      compression(compression.override(__superior.compression));
      chunk(chunk.override(__superior.chunk));
      return this;
    }

    public Builder listenport(int __value) {
      listenport = __value;
      return this;
    }

    private Builder listenport(String __value) {
      return listenport(Integer.valueOf(__value));
    }

    public Builder filesizemax(int __value) {
      filesizemax = __value;
      return this;
    }

    private Builder filesizemax(String __value) {
      return filesizemax(Integer.valueOf(__value));
    }

    public Builder servername(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      servername = __value;
      return this;
    }


    public Builder basedir(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      basedir = __value;
      return this;
    }


    public Builder usefsync(boolean __value) {
      usefsync = __value;
      return this;
    }

    private Builder usefsync(String __value) {
      return usefsync(Boolean.valueOf(__value));
    }

    public Builder maxthreads(int __value) {
      maxthreads = __value;
      return this;
    }

    private Builder maxthreads(String __value) {
      return maxthreads(Integer.valueOf(__value));
    }

    public Builder crcmethod(Crcmethod.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      crcmethod = __value;
      return this;
    }

    private Builder crcmethod(String __value) {
      return crcmethod(Crcmethod.Enum.valueOf(__value));
    }

    public Builder compression(Compression.Builder __builder) {
      compression = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder compression(java.util.function.Consumer<Compression.Builder> __func) {
      Compression.Builder __inner = new Compression.Builder();
      __func.accept(__inner);
      compression = __inner;
      return this;
    }

    public Builder chunk(Chunk.Builder __builder) {
      chunk = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder chunk(java.util.function.Consumer<Chunk.Builder> __func) {
      Chunk.Builder __inner = new Chunk.Builder();
      __func.accept(__inner);
      chunk = __inner;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public TranslogserverConfig build() {
      return new TranslogserverConfig(this);
    }

  }

  // Port number to use for listening.
  private final IntegerNode listenport;
  // Max file size (50M)
  private final IntegerNode filesizemax;
  // Server name to identify server.
  private final StringNode servername;
  // Base directory. The default is not used as it is decided by the model.
  private final StringNode basedir;
  // Use fsync after each commit.
  // If not the below interval is used.
  private final BooleanNode usefsync;
  // Number of threads available for visiting/subscription.
  private final IntegerNode maxthreads;
  // Default crc method used
  private final Crcmethod crcmethod;
  private final Compression compression;
  private final Chunk chunk;

  public TranslogserverConfig(Builder builder) {
    this(builder, true);
  }

  private TranslogserverConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "translogserver must be initialized: " + builder.__uninitialized);

    listenport = (builder.listenport == null) ?
        new IntegerNode(13700) : new IntegerNode(builder.listenport);
    filesizemax = (builder.filesizemax == null) ?
        new IntegerNode(50000000) : new IntegerNode(builder.filesizemax);
    servername = (builder.servername == null) ?
        new StringNode("tls") : new StringNode(builder.servername);
    basedir = (builder.basedir == null) ?
        new StringNode("tmp") : new StringNode(builder.basedir);
    usefsync = (builder.usefsync == null) ?
        new BooleanNode(true) : new BooleanNode(builder.usefsync);
    maxthreads = (builder.maxthreads == null) ?
        new IntegerNode(0) : new IntegerNode(builder.maxthreads);
    crcmethod = (builder.crcmethod == null) ?
        new Crcmethod(Crcmethod.xxh64) : new Crcmethod(builder.crcmethod);
    compression = new Compression(builder.compression, throwIfUninitialized);
    chunk = new Chunk(builder.chunk, throwIfUninitialized);
  }

  /**
   * @return translogserver.listenport
   */
  public int listenport() {
    return listenport.value();
  }

  /**
   * @return translogserver.filesizemax
   */
  public int filesizemax() {
    return filesizemax.value();
  }

  /**
   * @return translogserver.servername
   */
  public String servername() {
    return servername.value();
  }

  /**
   * @return translogserver.basedir
   */
  public String basedir() {
    return basedir.value();
  }

  /**
   * @return translogserver.usefsync
   */
  public boolean usefsync() {
    return usefsync.value();
  }

  /**
   * @return translogserver.maxthreads
   */
  public int maxthreads() {
    return maxthreads.value();
  }

  /**
   * @return translogserver.crcmethod
   */
  public Crcmethod.Enum crcmethod() {
    return crcmethod.value();
  }

  /**
   * @return translogserver.compression
   */
  public Compression compression() {
    return compression;
  }

  /**
   * @return translogserver.chunk
   */
  public Chunk chunk() {
    return chunk;
  }

  private ChangesRequiringRestart getChangesRequiringRestart(TranslogserverConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("translogserver");
      changes.compare(this.listenport, newConfig.listenport, "listenport", "Port number to use for listening.");
      changes.compare(this.servername, newConfig.servername, "servername", "Server name to identify server.");
      changes.compare(this.basedir, newConfig.basedir, "basedir", "Base directory. The default is not used as it is decided by the model.");
      changes.compare(this.maxthreads, newConfig.maxthreads, "maxthreads", "Number of threads available for visiting/subscription.");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return true;
  }

  /**
   * This class represents translogserver.crcmethod
   * 
   * Default crc method used
   */
  public final static class Crcmethod extends EnumNode<Crcmethod.Enum> {

    public Crcmethod(){
      this.value = null;
    }

    public Crcmethod(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {ccitt_crc32, xxh64}
    public final static Enum ccitt_crc32 = Enum.ccitt_crc32;
    public final static Enum xxh64 = Enum.xxh64;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

  /**
   * This class represents translogserver.compression
   */
  public final static class Compression extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Type.Enum type = null;
      private Integer level = null;

      public Builder() { }

      public Builder(Compression config) {
        type(config.type());
        level(config.level());
      }

      private Builder override(Builder __superior) {
        if (__superior.type != null)
          type(__superior.type);
        if (__superior.level != null)
          level(__superior.level);
        return this;
      }

      public Builder type(Type.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        type = __value;
        return this;
      }

      private Builder type(String __value) {
        return type(Type.Enum.valueOf(__value));
      }

      public Builder level(int __value) {
        level = __value;
        return this;
      }

      private Builder level(String __value) {
        return level(Integer.valueOf(__value));
      }

      public Compression build() {
        return new Compression(this);
      }

    }

    // Control compression type.
    private final Type type;
    // Control compression level
    // LZ4 has normal range 1..9 while ZSTD has range 1..19
    // 9 is a reasonable default for both
    private final IntegerNode level;

    public Compression(Builder builder) {
      this(builder, true);
    }

    private Compression(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "translogserver.compression must be initialized: " + builder.__uninitialized);

      type = (builder.type == null) ?
          new Type(Type.ZSTD) : new Type(builder.type);
      level = (builder.level == null) ?
          new IntegerNode(3) : new IntegerNode(builder.level);
    }

    /**
     * @return translogserver.compression.type
     */
    public Type.Enum type() {
      return type.value();
    }

    /**
     * @return translogserver.compression.level
     */
    public int level() {
      return level.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Compression newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("compression");
      return changes;
    }

    /**
     * This class represents translogserver.compression.type
     * 
     * Control compression type.
     */
    public final static class Type extends EnumNode<Type.Enum> {

      public Type(){
        this.value = null;
      }

      public Type(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {NONE, NONE_MULTI, LZ4, ZSTD}
      public final static Enum NONE = Enum.NONE;
      public final static Enum NONE_MULTI = Enum.NONE_MULTI;
      public final static Enum LZ4 = Enum.LZ4;
      public final static Enum ZSTD = Enum.ZSTD;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }
  }

  /**
   * This class represents translogserver.chunk
   */
  public final static class Chunk extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Integer sizelimit = null;

      public Builder() { }

      public Builder(Chunk config) {
        sizelimit(config.sizelimit());
      }

      private Builder override(Builder __superior) {
        if (__superior.sizelimit != null)
          sizelimit(__superior.sizelimit);
        return this;
      }

      public Builder sizelimit(int __value) {
        sizelimit = __value;
        return this;
      }

      private Builder sizelimit(String __value) {
        return sizelimit(Integer.valueOf(__value));
      }

      public Chunk build() {
        return new Chunk(this);
      }

    }

    // How large a chunk can grow in memory before beeing flushed
    private final IntegerNode sizelimit;

    public Chunk(Builder builder) {
      this(builder, true);
    }

    private Chunk(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "translogserver.chunk must be initialized: " + builder.__uninitialized);

      sizelimit = (builder.sizelimit == null) ?
          new IntegerNode(256000) : new IntegerNode(builder.sizelimit);
    }

    /**
     * @return translogserver.chunk.sizelimit
     */
    public int sizelimit() {
      return sizelimit.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Chunk newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("chunk");
      return changes;
    }
  }

}
