/* RankingExpressionParser.java */
/* Generated by: ParserGeneratorCC: Do not edit this line. RankingExpressionParser.java */
package com.yahoo.searchlib.rankingexpression.parser;

import com.yahoo.searchlib.rankingexpression.rule.*;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.evaluation.StringValue;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.tensor.*;
import com.yahoo.tensor.functions.*;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@SuppressWarnings({"rawtypes", "unchecked"})
public class RankingExpressionParser implements RankingExpressionParserConstants {

  final public List<ReferenceNode> featureList() throws ParseException {List<ReferenceNode> ret = new ArrayList<ReferenceNode>();
    ReferenceNode exp;
    label_1:
    while (true) {
      exp = feature();
ret.add(exp);
      switch (jj_nt.kind) {
      case IF:
      case IN:
      case F:
      case ABS:
      case ACOS:
      case ASIN:
      case ATAN:
      case CEIL:
      case COS:
      case COSH:
      case ELU:
      case EXP:
      case FABS:
      case FLOOR:
      case ISNAN:
      case LOG:
      case LOG10:
      case RELU:
      case ROUND:
      case SIGMOID:
      case SIGN:
      case SIN:
      case SINH:
      case SQUARE:
      case SQRT:
      case TAN:
      case TANH:
      case ERF:
      case ATAN2:
      case FMOD:
      case LDEXP:
      case POW:
      case BIT:
      case HAMMING:
      case MAP:
      case REDUCE:
      case JOIN:
      case MERGE:
      case RENAME:
      case CONCAT:
      case TENSOR:
      case RANGE:
      case DIAG:
      case RANDOM:
      case L1_NORMALIZE:
      case L2_NORMALIZE:
      case EUCLIDEAN_DISTANCE:
      case COSINE_SIMILARITY:
      case MATMUL:
      case SOFTMAX:
      case XW_PLUS_B:
      case ARGMAX:
      case ARGMIN:
      case CELL_CAST:
      case EXPAND:
      case AVG:
      case COUNT:
      case MAX:
      case MEDIAN:
      case MIN:
      case PROD:
      case SUM:
      case TRUE:
      case FALSE:
      case IDENTIFIER:{
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
    }
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ExpressionNode rankingExpression() throws ParseException {ExpressionNode ret;
    ret = expression();
    jj_consume_token(0);
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ExpressionNode expression() throws ParseException {ExpressionNode left, right;
    List<ExpressionNode> rightList;
    left = operationExpression();
    switch (jj_nt.kind) {
    case IN:{
      jj_consume_token(IN);
      rightList = expressionList();
left =  new SetMembershipNode(left, rightList);
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      ;
    }
{if ("" != null) return left;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ExpressionNode operationExpression() throws ParseException {ExpressionNode left, right = null;
    Operator operator;
    left = value();
    label_2:
    while (true) {
      switch (jj_nt.kind) {
      case ADD:
      case SUB:
      case DIV:
      case MUL:
      case MOD:
      case POWOP:
      case GREATEREQUAL:
      case GREATER:
      case LESSEQUAL:
      case LESS:
      case APPROX:
      case NOTEQUAL:
      case EQUAL:
      case AND:
      case OR:{
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      operator = binaryOperator();
      right = value();
left = OperationNode.resolve(left, operator, right);
    }
{if ("" != null) return left;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Operator binaryOperator() throws ParseException {
    switch (jj_nt.kind) {
    case OR:{
      jj_consume_token(OR);
{if ("" != null) return Operator.or;}
      break;
      }
    case AND:{
      jj_consume_token(AND);
{if ("" != null) return Operator.and;}
      break;
      }
    case GREATEREQUAL:{
      jj_consume_token(GREATEREQUAL);
{if ("" != null) return Operator.largerOrEqual;}
      break;
      }
    case GREATER:{
      jj_consume_token(GREATER);
{if ("" != null) return Operator.larger;}
      break;
      }
    case LESSEQUAL:{
      jj_consume_token(LESSEQUAL);
{if ("" != null) return Operator.smallerOrEqual;}
      break;
      }
    case LESS:{
      jj_consume_token(LESS);
{if ("" != null) return Operator.smaller;}
      break;
      }
    case APPROX:{
      jj_consume_token(APPROX);
{if ("" != null) return Operator.approxEqual;}
      break;
      }
    case NOTEQUAL:{
      jj_consume_token(NOTEQUAL);
{if ("" != null) return Operator.notEqual;}
      break;
      }
    case EQUAL:{
      jj_consume_token(EQUAL);
{if ("" != null) return Operator.equal;}
      break;
      }
    case ADD:{
      jj_consume_token(ADD);
{if ("" != null) return Operator.plus;}
      break;
      }
    case SUB:{
      jj_consume_token(SUB);
{if ("" != null) return Operator.minus;}
      break;
      }
    case DIV:{
      jj_consume_token(DIV);
{if ("" != null) return Operator.divide;}
      break;
      }
    case MUL:{
      jj_consume_token(MUL);
{if ("" != null) return Operator.multiply;}
      break;
      }
    case MOD:{
      jj_consume_token(MOD);
{if ("" != null) return Operator.modulo;}
      break;
      }
    case POWOP:{
      jj_consume_token(POWOP);
{if ("" != null) return Operator.power;}
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return null;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ExpressionNode value() throws ParseException {ExpressionNode value;
    boolean neg = false;
    boolean not = false;
    List valueAddress;
    switch (jj_nt.kind) {
    case NOT:{
      jj_consume_token(NOT);
not = true;
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    if (jj_2_1(2)) {
      jj_consume_token(SUB);
neg = true;
    } else {
      ;
    }
    switch (jj_nt.kind) {
    case INTEGER:
    case FLOAT:
    case SUB:
    case STRING:
    case TRUE:
    case FALSE:{
      value = constantPrimitive(neg);
      break;
      }
    case LBRACE:
    case DOLLAR:
    case IF:
    case IN:
    case F:
    case ABS:
    case ACOS:
    case ASIN:
    case ATAN:
    case CEIL:
    case COS:
    case COSH:
    case ELU:
    case EXP:
    case FABS:
    case FLOOR:
    case ISNAN:
    case LOG:
    case LOG10:
    case RELU:
    case ROUND:
    case SIGMOID:
    case SIGN:
    case SIN:
    case SINH:
    case SQUARE:
    case SQRT:
    case TAN:
    case TANH:
    case ERF:
    case ATAN2:
    case FMOD:
    case LDEXP:
    case POW:
    case BIT:
    case HAMMING:
    case MAP:
    case REDUCE:
    case JOIN:
    case MERGE:
    case RENAME:
    case CONCAT:
    case TENSOR:
    case RANGE:
    case DIAG:
    case RANDOM:
    case L1_NORMALIZE:
    case L2_NORMALIZE:
    case EUCLIDEAN_DISTANCE:
    case COSINE_SIMILARITY:
    case MATMUL:
    case SOFTMAX:
    case XW_PLUS_B:
    case ARGMAX:
    case ARGMIN:
    case CELL_CAST:
    case EXPAND:
    case AVG:
    case COUNT:
    case MAX:
    case MEDIAN:
    case MIN:
    case PROD:
    case SUM:
    case IDENTIFIER:{
      if (jj_2_2(2)) {
        value = ifExpression();
      } else if (jj_2_3(4)) {
        value = function();
      } else {
        switch (jj_nt.kind) {
        case IF:
        case IN:
        case F:
        case ABS:
        case ACOS:
        case ASIN:
        case ATAN:
        case CEIL:
        case COS:
        case COSH:
        case ELU:
        case EXP:
        case FABS:
        case FLOOR:
        case ISNAN:
        case LOG:
        case LOG10:
        case RELU:
        case ROUND:
        case SIGMOID:
        case SIGN:
        case SIN:
        case SINH:
        case SQUARE:
        case SQRT:
        case TAN:
        case TANH:
        case ERF:
        case ATAN2:
        case FMOD:
        case LDEXP:
        case POW:
        case BIT:
        case HAMMING:
        case MAP:
        case REDUCE:
        case JOIN:
        case MERGE:
        case RENAME:
        case CONCAT:
        case TENSOR:
        case RANGE:
        case DIAG:
        case RANDOM:
        case L1_NORMALIZE:
        case L2_NORMALIZE:
        case EUCLIDEAN_DISTANCE:
        case COSINE_SIMILARITY:
        case MATMUL:
        case SOFTMAX:
        case XW_PLUS_B:
        case ARGMAX:
        case ARGMIN:
        case CELL_CAST:
        case EXPAND:
        case AVG:
        case COUNT:
        case MAX:
        case MEDIAN:
        case MIN:
        case PROD:
        case SUM:
        case TRUE:
        case FALSE:
        case IDENTIFIER:{
          value = feature();
          break;
          }
        case DOLLAR:{
          value = legacyQueryFeature();
          break;
          }
        case LBRACE:{
          jj_consume_token(LBRACE);
          value = expression();
          jj_consume_token(RBRACE);
value = new EmbracedNode(value);
          break;
          }
        default:
          jj_la1[5] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
value = neg ? new NegativeNode(value) : value;
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_4(2)) {
      valueAddress = valueAddress();
value = new TensorFunctionNode(new Slice(TensorFunctionNode.wrap(value), valueAddress));
    } else {
      ;
    }
value = not ? new NotNode(value) : value;
        {if ("" != null) return value;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public IfNode ifExpression() throws ParseException {ExpressionNode condition, ifTrue, ifFalse;
    Double trueProbability = null;
    jj_consume_token(IF);
    jj_consume_token(LBRACE);
    condition = expression();
    jj_consume_token(COMMA);
    ifTrue = expression();
    jj_consume_token(COMMA);
    ifFalse = expression();
    switch (jj_nt.kind) {
    case COMMA:{
      jj_consume_token(COMMA);
      trueProbability = doubleNumber();
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
{if ("" != null) return new IfNode(condition, ifTrue, ifFalse, trueProbability);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ReferenceNode feature() throws ParseException {List<ExpressionNode> args = null;
    String name, out = null;
    name = identifier();
    switch (jj_nt.kind) {
    case LBRACE:{
      jj_consume_token(LBRACE);
      args = args();
      jj_consume_token(RBRACE);
      break;
      }
    default:
      jj_la1[8] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case DOT:{
      jj_consume_token(DOT);
      out = outs();
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      ;
    }
if (args == null && out == null) // know the difference between "foo" and "foo()"
             {if ("" != null) return new ReferenceNode(name);}
         else
             {if ("" != null) return new ReferenceNode(name, args, out);}
    throw new IllegalStateException ("Missing return statement in function");
}

// Rank properties are referenced by $propertyname
  final public ReferenceNode legacyQueryFeature() throws ParseException {String name;
    jj_consume_token(DOLLAR);
    name = identifier();
{if ("" != null) return new ReferenceNode("query", Arrays.asList((ExpressionNode)new NameNode(name)), null);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String outs() throws ParseException {StringBuilder ret = new StringBuilder();
    String str;
    str = out();
ret.append(str);
    label_3:
    while (true) {
      switch (jj_nt.kind) {
      case DOT:{
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        break label_3;
      }
      jj_consume_token(DOT);
ret.append(token.image);
      str = out();
ret.append(str);
    }
{if ("" != null) return ret.toString();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String out() throws ParseException {Function fnc;
    String name;
    switch (jj_nt.kind) {
    case INTEGER:{
      jj_consume_token(INTEGER);
{if ("" != null) return token.image;}
      break;
      }
    case FLOAT:{
      jj_consume_token(FLOAT);
{if ("" != null) return token.image;}
      break;
      }
    case IF:
    case IN:
    case F:
    case ABS:
    case ACOS:
    case ASIN:
    case ATAN:
    case CEIL:
    case COS:
    case COSH:
    case ELU:
    case EXP:
    case FABS:
    case FLOOR:
    case ISNAN:
    case LOG:
    case LOG10:
    case RELU:
    case ROUND:
    case SIGMOID:
    case SIGN:
    case SIN:
    case SINH:
    case SQUARE:
    case SQRT:
    case TAN:
    case TANH:
    case ERF:
    case ATAN2:
    case FMOD:
    case LDEXP:
    case POW:
    case BIT:
    case HAMMING:
    case MAP:
    case REDUCE:
    case JOIN:
    case MERGE:
    case RENAME:
    case CONCAT:
    case TENSOR:
    case RANGE:
    case DIAG:
    case RANDOM:
    case L1_NORMALIZE:
    case L2_NORMALIZE:
    case EUCLIDEAN_DISTANCE:
    case COSINE_SIMILARITY:
    case MATMUL:
    case SOFTMAX:
    case XW_PLUS_B:
    case ARGMAX:
    case ARGMIN:
    case CELL_CAST:
    case EXPAND:
    case AVG:
    case COUNT:
    case MAX:
    case MEDIAN:
    case MIN:
    case PROD:
    case SUM:
    case TRUE:
    case FALSE:
    case IDENTIFIER:{
      name = identifier();
{if ("" != null) return name;}
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return null;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<ExpressionNode> args() throws ParseException {List<ExpressionNode> arguments = new ArrayList<ExpressionNode>();
    ExpressionNode argument;
    switch (jj_nt.kind) {
    case INTEGER:
    case FLOAT:
    case LBRACE:
    case SUB:
    case DOLLAR:
    case STRING:
    case IF:
    case IN:
    case F:
    case NOT:
    case ABS:
    case ACOS:
    case ASIN:
    case ATAN:
    case CEIL:
    case COS:
    case COSH:
    case ELU:
    case EXP:
    case FABS:
    case FLOOR:
    case ISNAN:
    case LOG:
    case LOG10:
    case RELU:
    case ROUND:
    case SIGMOID:
    case SIGN:
    case SIN:
    case SINH:
    case SQUARE:
    case SQRT:
    case TAN:
    case TANH:
    case ERF:
    case ATAN2:
    case FMOD:
    case LDEXP:
    case POW:
    case BIT:
    case HAMMING:
    case MAP:
    case REDUCE:
    case JOIN:
    case MERGE:
    case RENAME:
    case CONCAT:
    case TENSOR:
    case RANGE:
    case DIAG:
    case RANDOM:
    case L1_NORMALIZE:
    case L2_NORMALIZE:
    case EUCLIDEAN_DISTANCE:
    case COSINE_SIMILARITY:
    case MATMUL:
    case SOFTMAX:
    case XW_PLUS_B:
    case ARGMAX:
    case ARGMIN:
    case CELL_CAST:
    case EXPAND:
    case AVG:
    case COUNT:
    case MAX:
    case MEDIAN:
    case MIN:
    case PROD:
    case SUM:
    case TRUE:
    case FALSE:
    case IDENTIFIER:{
      argument = expression();
arguments.add(argument);
      label_4:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:{
          break;
          }
        default:
          jj_la1[12] = jj_gen;
          break label_4;
        }
        jj_consume_token(COMMA);
        argument = expression();
arguments.add(argument);
      }
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      ;
    }
{if ("" != null) return arguments;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ExpressionNode function() throws ParseException {ExpressionNode function;
    if (jj_2_5(2)) {
      function = scalarOrTensorFunction();
    } else {
      switch (jj_nt.kind) {
      case MAP:
      case REDUCE:
      case JOIN:
      case MERGE:
      case RENAME:
      case CONCAT:
      case TENSOR:
      case RANGE:
      case DIAG:
      case RANDOM:
      case L1_NORMALIZE:
      case L2_NORMALIZE:
      case EUCLIDEAN_DISTANCE:
      case COSINE_SIMILARITY:
      case MATMUL:
      case SOFTMAX:
      case XW_PLUS_B:
      case ARGMAX:
      case ARGMIN:
      case CELL_CAST:
      case EXPAND:
      case AVG:
      case COUNT:
      case MAX:
      case MEDIAN:
      case MIN:
      case PROD:
      case SUM:{
        function = tensorFunction();
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return function;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public FunctionNode scalarOrTensorFunction() throws ParseException {Function function;
    ExpressionNode arg1, arg2;
    switch (jj_nt.kind) {
    case ABS:
    case ACOS:
    case ASIN:
    case ATAN:
    case CEIL:
    case COS:
    case COSH:
    case ELU:
    case EXP:
    case FABS:
    case FLOOR:
    case ISNAN:
    case LOG:
    case LOG10:
    case RELU:
    case ROUND:
    case SIGMOID:
    case SIGN:
    case SIN:
    case SINH:
    case SQUARE:
    case SQRT:
    case TAN:
    case TANH:
    case ERF:{
      function = unaryFunctionName();
      jj_consume_token(LBRACE);
      arg1 = expression();
      jj_consume_token(RBRACE);
{if ("" != null) return new FunctionNode(function, arg1);}
      break;
      }
    case ATAN2:
    case FMOD:
    case LDEXP:
    case POW:
    case BIT:
    case HAMMING:
    case MAX:
    case MIN:{
      function = binaryFunctionName();
      jj_consume_token(LBRACE);
      arg1 = expression();
      jj_consume_token(COMMA);
      arg2 = expression();
      jj_consume_token(RBRACE);
{if ("" != null) return new FunctionNode(function, arg1, arg2);}
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorFunction() throws ParseException {TensorFunctionNode tensorExpression;
    switch (jj_nt.kind) {
    case MAP:{
      tensorExpression = tensorMap();
      break;
      }
    case REDUCE:{
      tensorExpression = tensorReduce();
      break;
      }
    case AVG:
    case COUNT:
    case MAX:
    case MEDIAN:
    case MIN:
    case PROD:
    case SUM:{
      tensorExpression = tensorReduceComposites();
      break;
      }
    case JOIN:{
      tensorExpression = tensorJoin();
      break;
      }
    case MERGE:{
      tensorExpression = tensorMerge();
      break;
      }
    case RENAME:{
      tensorExpression = tensorRename();
      break;
      }
    case CONCAT:{
      tensorExpression = tensorConcat();
      break;
      }
    case TENSOR:{
      tensorExpression = tensorGenerate();
      break;
      }
    case RANGE:{
      tensorExpression = tensorRange();
      break;
      }
    case DIAG:{
      tensorExpression = tensorDiag();
      break;
      }
    case RANDOM:{
      tensorExpression = tensorRandom();
      break;
      }
    case L1_NORMALIZE:{
      tensorExpression = tensorL1Normalize();
      break;
      }
    case L2_NORMALIZE:{
      tensorExpression = tensorL2Normalize();
      break;
      }
    case EUCLIDEAN_DISTANCE:{
      tensorExpression = tensorEuclideanDistance();
      break;
      }
    case COSINE_SIMILARITY:{
      tensorExpression = tensorCosineSimilarity();
      break;
      }
    case MATMUL:{
      tensorExpression = tensorMatmul();
      break;
      }
    case SOFTMAX:{
      tensorExpression = tensorSoftmax();
      break;
      }
    case XW_PLUS_B:{
      tensorExpression = tensorXwPlusB();
      break;
      }
    case ARGMAX:{
      tensorExpression = tensorArgmax();
      break;
      }
    case ARGMIN:{
      tensorExpression = tensorArgmin();
      break;
      }
    case CELL_CAST:{
      tensorExpression = tensorCellCast();
      break;
      }
    case EXPAND:{
      tensorExpression = tensorExpand();
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return tensorExpression;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorMap() throws ParseException {ExpressionNode tensor;
    LambdaFunctionNode doubleMapper;
    jj_consume_token(MAP);
    jj_consume_token(LBRACE);
    tensor = expression();
    jj_consume_token(COMMA);
    doubleMapper = lambdaFunction();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new Map(TensorFunctionNode.wrap(tensor),
                                            doubleMapper.asDoubleUnaryOperator()));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorReduce() throws ParseException {ExpressionNode tensor;
    Reduce.Aggregator aggregator;
    List<String> dimensions = null;
    jj_consume_token(REDUCE);
    jj_consume_token(LBRACE);
    tensor = expression();
    jj_consume_token(COMMA);
    aggregator = tensorReduceAggregator();
    dimensions = tagCommaLeadingList();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new Reduce(TensorFunctionNode.wrap(tensor), aggregator, dimensions));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorReduceComposites() throws ParseException {ExpressionNode tensor;
    Reduce.Aggregator aggregator;
    List<String> dimensions = null;
    aggregator = tensorReduceAggregator();
    jj_consume_token(LBRACE);
    tensor = expression();
    dimensions = tagCommaLeadingList();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new Reduce(TensorFunctionNode.wrap(tensor), aggregator, dimensions));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorJoin() throws ParseException {ExpressionNode tensor1, tensor2;
    LambdaFunctionNode doubleJoiner;
    jj_consume_token(JOIN);
    jj_consume_token(LBRACE);
    tensor1 = expression();
    jj_consume_token(COMMA);
    tensor2 = expression();
    jj_consume_token(COMMA);
    doubleJoiner = lambdaFunction();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new Join(TensorFunctionNode.wrap(tensor1),
                                 TensorFunctionNode.wrap(tensor2),
                                 doubleJoiner.asDoubleBinaryOperator()));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorMerge() throws ParseException {ExpressionNode tensor1, tensor2;
    LambdaFunctionNode doubleMerger;
    jj_consume_token(MERGE);
    jj_consume_token(LBRACE);
    tensor1 = expression();
    jj_consume_token(COMMA);
    tensor2 = expression();
    jj_consume_token(COMMA);
    doubleMerger = lambdaFunction();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new Merge(TensorFunctionNode.wrap(tensor1),
                                    TensorFunctionNode.wrap(tensor2),
                                     doubleMerger.asDoubleBinaryOperator()));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorRename() throws ParseException {ExpressionNode tensor;
    List<String> fromDimensions, toDimensions;
    jj_consume_token(RENAME);
    jj_consume_token(LBRACE);
    tensor = expression();
    jj_consume_token(COMMA);
    fromDimensions = bracedIdentifierList();
    jj_consume_token(COMMA);
    toDimensions = bracedIdentifierList();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new Rename(TensorFunctionNode.wrap(tensor), fromDimensions, toDimensions));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorConcat() throws ParseException {ExpressionNode tensor1, tensor2;
    String dimension;
    jj_consume_token(CONCAT);
    jj_consume_token(LBRACE);
    tensor1 = expression();
    jj_consume_token(COMMA);
    tensor2 = expression();
    jj_consume_token(COMMA);
    dimension = tag();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new Concat(TensorFunctionNode.wrap(tensor1),
                                               TensorFunctionNode.wrap(tensor2),
                                               dimension));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorGenerate() throws ParseException {TensorType type;
    List dimensionOrder = new ArrayList();
    TensorFunctionNode expression;
    jj_consume_token(TENSOR);
    type = tensorType(dimensionOrder);
    switch (jj_nt.kind) {
    case LBRACE:{
      expression = tensorGenerateBody(type);
      break;
      }
    case COLON:{
      expression = tensorValueBody(type, dimensionOrder);
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return expression;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorGenerateBody(TensorType type) throws ParseException {ExpressionNode generator;
    jj_consume_token(LBRACE);
    generator = expression();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(Generate.bound(type, TensorFunctionNode.wrapScalar(generator)));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorRange() throws ParseException {TensorType type;
    jj_consume_token(RANGE);
    type = tensorType(null);
{if ("" != null) return new TensorFunctionNode(new Range(type));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorDiag() throws ParseException {TensorType type;
    jj_consume_token(DIAG);
    type = tensorType(null);
{if ("" != null) return new TensorFunctionNode(new Diag(type));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorRandom() throws ParseException {TensorType type;
    jj_consume_token(RANDOM);
    type = tensorType(null);
{if ("" != null) return new TensorFunctionNode(new Random(type));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorL1Normalize() throws ParseException {ExpressionNode tensor;
    String dimension;
    jj_consume_token(L1_NORMALIZE);
    jj_consume_token(LBRACE);
    tensor = expression();
    jj_consume_token(COMMA);
    dimension = identifier();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new L1Normalize(TensorFunctionNode.wrap(tensor), dimension));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorL2Normalize() throws ParseException {ExpressionNode tensor;
    String dimension;
    jj_consume_token(L2_NORMALIZE);
    jj_consume_token(LBRACE);
    tensor = expression();
    jj_consume_token(COMMA);
    dimension = identifier();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new L2Normalize(TensorFunctionNode.wrap(tensor), dimension));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorEuclideanDistance() throws ParseException {ExpressionNode tensor1, tensor2;
    String dimension;
    jj_consume_token(EUCLIDEAN_DISTANCE);
    jj_consume_token(LBRACE);
    tensor1 = expression();
    jj_consume_token(COMMA);
    tensor2 = expression();
    jj_consume_token(COMMA);
    dimension = identifier();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new EuclideanDistance(TensorFunctionNode.wrap(tensor1),
                                                          TensorFunctionNode.wrap(tensor2),
                                                          dimension));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorCosineSimilarity() throws ParseException {ExpressionNode tensor1, tensor2;
    String dimension;
    jj_consume_token(COSINE_SIMILARITY);
    jj_consume_token(LBRACE);
    tensor1 = expression();
    jj_consume_token(COMMA);
    tensor2 = expression();
    jj_consume_token(COMMA);
    dimension = identifier();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new CosineSimilarity(TensorFunctionNode.wrap(tensor1),
                                                          TensorFunctionNode.wrap(tensor2),
                                                          dimension));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorMatmul() throws ParseException {ExpressionNode tensor1, tensor2;
    String dimension;
    jj_consume_token(MATMUL);
    jj_consume_token(LBRACE);
    tensor1 = expression();
    jj_consume_token(COMMA);
    tensor2 = expression();
    jj_consume_token(COMMA);
    dimension = identifier();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new Matmul(TensorFunctionNode.wrap(tensor1),
                                   TensorFunctionNode.wrap(tensor2),
                                   dimension));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorSoftmax() throws ParseException {ExpressionNode tensor;
    String dimension;
    jj_consume_token(SOFTMAX);
    jj_consume_token(LBRACE);
    tensor = expression();
    jj_consume_token(COMMA);
    dimension = identifier();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new Softmax(TensorFunctionNode.wrap(tensor), dimension));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorXwPlusB() throws ParseException {ExpressionNode tensor1, tensor2, tensor3;
    String dimension;
    jj_consume_token(XW_PLUS_B);
    jj_consume_token(LBRACE);
    tensor1 = expression();
    jj_consume_token(COMMA);
    tensor2 = expression();
    jj_consume_token(COMMA);
    tensor3 = expression();
    jj_consume_token(COMMA);
    dimension = identifier();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new XwPlusB(TensorFunctionNode.wrap(tensor1),
                                                TensorFunctionNode.wrap(tensor2),
                                                TensorFunctionNode.wrap(tensor3),
                                                dimension));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorExpand() throws ParseException {ExpressionNode argument;
    String dimension;
    jj_consume_token(EXPAND);
    jj_consume_token(LBRACE);
    argument = expression();
    jj_consume_token(COMMA);
    dimension = identifier();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new Expand(TensorFunctionNode.wrap(argument), dimension));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorArgmax() throws ParseException {ExpressionNode tensor;
    List<String> dimensions = null;
    jj_consume_token(ARGMAX);
    jj_consume_token(LBRACE);
    tensor = expression();
    dimensions = tagCommaLeadingList();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new Argmax(TensorFunctionNode.wrap(tensor), dimensions));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorArgmin() throws ParseException {ExpressionNode tensor;
    List<String> dimensions = null;
    jj_consume_token(ARGMIN);
    jj_consume_token(LBRACE);
    tensor = expression();
    dimensions = tagCommaLeadingList();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new Argmin(TensorFunctionNode.wrap(tensor), dimensions));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorCellCast() throws ParseException {ExpressionNode tensor;
    String valueType;
    jj_consume_token(CELL_CAST);
    jj_consume_token(LBRACE);
    tensor = expression();
    jj_consume_token(COMMA);
    valueType = identifier();
    jj_consume_token(RBRACE);
{if ("" != null) return new TensorFunctionNode(new CellCast(TensorFunctionNode.wrap(tensor), TensorType.Value.fromId(valueType)));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public LambdaFunctionNode lambdaFunction() throws ParseException {List<String> variables;
    ExpressionNode functionExpression;
    jj_consume_token(F);
    jj_consume_token(LBRACE);
    variables = identifierList();
    jj_consume_token(RBRACE);
    jj_consume_token(LBRACE);
    functionExpression = expression();
    jj_consume_token(RBRACE);
{if ("" != null) return new LambdaFunctionNode(variables, functionExpression);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Reduce.Aggregator tensorReduceAggregator() throws ParseException {
    switch (jj_nt.kind) {
    case AVG:{
      jj_consume_token(AVG);
      break;
      }
    case COUNT:{
      jj_consume_token(COUNT);
      break;
      }
    case MAX:{
      jj_consume_token(MAX);
      break;
      }
    case MEDIAN:{
      jj_consume_token(MEDIAN);
      break;
      }
    case MIN:{
      jj_consume_token(MIN);
      break;
      }
    case PROD:{
      jj_consume_token(PROD);
      break;
      }
    case SUM:{
      jj_consume_token(SUM);
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return Reduce.Aggregator.valueOf(token.image);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorType tensorType(List dimensionOrder) throws ParseException {TensorType.Builder builder;
    TensorType.Value valueType;
    valueType = optionalTensorValueTypeParameter();
builder = new TensorType.Builder(valueType);
    jj_consume_token(LBRACE);
    switch (jj_nt.kind) {
    case IF:
    case IN:
    case F:
    case ABS:
    case ACOS:
    case ASIN:
    case ATAN:
    case CEIL:
    case COS:
    case COSH:
    case ELU:
    case EXP:
    case FABS:
    case FLOOR:
    case ISNAN:
    case LOG:
    case LOG10:
    case RELU:
    case ROUND:
    case SIGMOID:
    case SIGN:
    case SIN:
    case SINH:
    case SQUARE:
    case SQRT:
    case TAN:
    case TANH:
    case ERF:
    case ATAN2:
    case FMOD:
    case LDEXP:
    case POW:
    case BIT:
    case HAMMING:
    case MAP:
    case REDUCE:
    case JOIN:
    case MERGE:
    case RENAME:
    case CONCAT:
    case TENSOR:
    case RANGE:
    case DIAG:
    case RANDOM:
    case L1_NORMALIZE:
    case L2_NORMALIZE:
    case EUCLIDEAN_DISTANCE:
    case COSINE_SIMILARITY:
    case MATMUL:
    case SOFTMAX:
    case XW_PLUS_B:
    case ARGMAX:
    case ARGMIN:
    case CELL_CAST:
    case EXPAND:
    case AVG:
    case COUNT:
    case MAX:
    case MEDIAN:
    case MIN:
    case PROD:
    case SUM:
    case TRUE:
    case FALSE:
    case IDENTIFIER:{
      tensorTypeDimension(builder, dimensionOrder);
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    label_5:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMA);
      tensorTypeDimension(builder, dimensionOrder);
    }
    jj_consume_token(RBRACE);
{if ("" != null) return builder.build();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorType.Value optionalTensorValueTypeParameter() throws ParseException {String valueType = "double";
    switch (jj_nt.kind) {
    case LESS:{
      jj_consume_token(LESS);
      valueType = identifier();
      jj_consume_token(GREATER);
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      ;
    }
{if ("" != null) return TensorType.Value.fromId(valueType);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void tensorTypeDimension(TensorType.Builder builder, List dimensionOrder) throws ParseException {String name;
    int size;
    name = identifier();
// Keep track of the order in which dimensions are written, if necessary
        if (dimensionOrder != null)
            dimensionOrder.add(name);
    switch (jj_nt.kind) {
    case LCURLY:{
      jj_consume_token(LCURLY);
      jj_consume_token(RCURLY);
builder.mapped(name);
      break;
      }
    default:
      jj_la1[22] = jj_gen;
      if (jj_2_6(2)) {
        jj_consume_token(LSQUARE);
        jj_consume_token(RSQUARE);
builder.indexed(name);
      } else {
        switch (jj_nt.kind) {
        case LSQUARE:{
          jj_consume_token(LSQUARE);
          size = integerNumber();
          jj_consume_token(RSQUARE);
builder.indexed(name, size);
          break;
          }
        default:
          jj_la1[23] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
}

// This is needed not to parse tensor functions but for the "reserved names as literals" workaround cludge
  final public String tensorFunctionName() throws ParseException {Reduce.Aggregator aggregator;
    switch (jj_nt.kind) {
    case F:{
      jj_consume_token(F);
{if ("" != null) return token.image;}
      break;
      }
    case MAP:{
      jj_consume_token(MAP);
{if ("" != null) return token.image;}
      break;
      }
    case REDUCE:{
      jj_consume_token(REDUCE);
{if ("" != null) return token.image;}
      break;
      }
    case JOIN:{
      jj_consume_token(JOIN);
{if ("" != null) return token.image;}
      break;
      }
    case MERGE:{
      jj_consume_token(MERGE);
{if ("" != null) return token.image;}
      break;
      }
    case RENAME:{
      jj_consume_token(RENAME);
{if ("" != null) return token.image;}
      break;
      }
    case CONCAT:{
      jj_consume_token(CONCAT);
{if ("" != null) return token.image;}
      break;
      }
    case TENSOR:{
      jj_consume_token(TENSOR);
{if ("" != null) return token.image;}
      break;
      }
    case RANGE:{
      jj_consume_token(RANGE);
{if ("" != null) return token.image;}
      break;
      }
    case DIAG:{
      jj_consume_token(DIAG);
{if ("" != null) return token.image;}
      break;
      }
    case RANDOM:{
      jj_consume_token(RANDOM);
{if ("" != null) return token.image;}
      break;
      }
    case L1_NORMALIZE:{
      jj_consume_token(L1_NORMALIZE);
{if ("" != null) return token.image;}
      break;
      }
    case L2_NORMALIZE:{
      jj_consume_token(L2_NORMALIZE);
{if ("" != null) return token.image;}
      break;
      }
    case EUCLIDEAN_DISTANCE:{
      jj_consume_token(EUCLIDEAN_DISTANCE);
{if ("" != null) return token.image;}
      break;
      }
    case COSINE_SIMILARITY:{
      jj_consume_token(COSINE_SIMILARITY);
{if ("" != null) return token.image;}
      break;
      }
    case MATMUL:{
      jj_consume_token(MATMUL);
{if ("" != null) return token.image;}
      break;
      }
    case SOFTMAX:{
      jj_consume_token(SOFTMAX);
{if ("" != null) return token.image;}
      break;
      }
    case XW_PLUS_B:{
      jj_consume_token(XW_PLUS_B);
{if ("" != null) return token.image;}
      break;
      }
    case ARGMAX:{
      jj_consume_token(ARGMAX);
{if ("" != null) return token.image;}
      break;
      }
    case ARGMIN:{
      jj_consume_token(ARGMIN);
{if ("" != null) return token.image;}
      break;
      }
    case CELL_CAST:{
      jj_consume_token(CELL_CAST);
{if ("" != null) return token.image;}
      break;
      }
    case EXPAND:{
      jj_consume_token(EXPAND);
{if ("" != null) return token.image;}
      break;
      }
    case AVG:
    case COUNT:
    case MAX:
    case MEDIAN:
    case MIN:
    case PROD:
    case SUM:{
      aggregator = tensorReduceAggregator();
{if ("" != null) return aggregator.toString();}
      break;
      }
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Function unaryFunctionName() throws ParseException {
    switch (jj_nt.kind) {
    case ABS:{
      jj_consume_token(ABS);
{if ("" != null) return Function.abs;}
      break;
      }
    case ACOS:{
      jj_consume_token(ACOS);
{if ("" != null) return Function.acos;}
      break;
      }
    case ASIN:{
      jj_consume_token(ASIN);
{if ("" != null) return Function.asin;}
      break;
      }
    case ATAN:{
      jj_consume_token(ATAN);
{if ("" != null) return Function.atan;}
      break;
      }
    case CEIL:{
      jj_consume_token(CEIL);
{if ("" != null) return Function.ceil;}
      break;
      }
    case COS:{
      jj_consume_token(COS);
{if ("" != null) return Function.cos;}
      break;
      }
    case COSH:{
      jj_consume_token(COSH);
{if ("" != null) return Function.cosh;}
      break;
      }
    case ELU:{
      jj_consume_token(ELU);
{if ("" != null) return Function.elu;}
      break;
      }
    case EXP:{
      jj_consume_token(EXP);
{if ("" != null) return Function.exp;}
      break;
      }
    case FABS:{
      jj_consume_token(FABS);
{if ("" != null) return Function.fabs;}
      break;
      }
    case FLOOR:{
      jj_consume_token(FLOOR);
{if ("" != null) return Function.floor;}
      break;
      }
    case ISNAN:{
      jj_consume_token(ISNAN);
{if ("" != null) return Function.isNan;}
      break;
      }
    case LOG:{
      jj_consume_token(LOG);
{if ("" != null) return Function.log;}
      break;
      }
    case LOG10:{
      jj_consume_token(LOG10);
{if ("" != null) return Function.log10;}
      break;
      }
    case RELU:{
      jj_consume_token(RELU);
{if ("" != null) return Function.relu;}
      break;
      }
    case ROUND:{
      jj_consume_token(ROUND);
{if ("" != null) return Function.round;}
      break;
      }
    case SIGMOID:{
      jj_consume_token(SIGMOID);
{if ("" != null) return Function.sigmoid;}
      break;
      }
    case SIGN:{
      jj_consume_token(SIGN);
{if ("" != null) return Function.sign;}
      break;
      }
    case SIN:{
      jj_consume_token(SIN);
{if ("" != null) return Function.sin;}
      break;
      }
    case SINH:{
      jj_consume_token(SINH);
{if ("" != null) return Function.sinh;}
      break;
      }
    case SQUARE:{
      jj_consume_token(SQUARE);
{if ("" != null) return Function.square;}
      break;
      }
    case SQRT:{
      jj_consume_token(SQRT);
{if ("" != null) return Function.sqrt;}
      break;
      }
    case TAN:{
      jj_consume_token(TAN);
{if ("" != null) return Function.tan;}
      break;
      }
    case TANH:{
      jj_consume_token(TANH);
{if ("" != null) return Function.tanh;}
      break;
      }
    case ERF:{
      jj_consume_token(ERF);
{if ("" != null) return Function.erf;}
      break;
      }
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Function binaryFunctionName() throws ParseException {
    switch (jj_nt.kind) {
    case ATAN2:{
      jj_consume_token(ATAN2);
{if ("" != null) return Function.atan2;}
      break;
      }
    case FMOD:{
      jj_consume_token(FMOD);
{if ("" != null) return Function.fmod;}
      break;
      }
    case LDEXP:{
      jj_consume_token(LDEXP);
{if ("" != null) return Function.ldexp;}
      break;
      }
    case MAX:{
      jj_consume_token(MAX);
{if ("" != null) return Function.max;}
      break;
      }
    case MIN:{
      jj_consume_token(MIN);
{if ("" != null) return Function.min;}
      break;
      }
    case POW:{
      jj_consume_token(POW);
{if ("" != null) return Function.pow;}
      break;
      }
    case BIT:{
      jj_consume_token(BIT);
{if ("" != null) return Function.bit;}
      break;
      }
    case HAMMING:{
      jj_consume_token(HAMMING);
{if ("" != null) return Function.hamming;}
      break;
      }
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<ExpressionNode> expressionList() throws ParseException {List<ExpressionNode> list = new ArrayList<ExpressionNode>();
    ExpressionNode expression;
    jj_consume_token(LSQUARE);
    expression = expression();
list.add(expression);
    label_6:
    while (true) {
      if (jj_2_7(2)) {
      } else {
        break label_6;
      }
      jj_consume_token(COMMA);
      expression = expression();
list.add(expression);
    }
    jj_consume_token(RSQUARE);
{if ("" != null) return list;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public double doubleNumber() throws ParseException {String sign = "";
    switch (jj_nt.kind) {
    case SUB:{
      jj_consume_token(SUB);
sign = "-";
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case FLOAT:{
      jj_consume_token(FLOAT);
      break;
      }
    case INTEGER:{
      jj_consume_token(INTEGER);
      break;
      }
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return Double.parseDouble(sign + token.image);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public int integerNumber() throws ParseException {String sign = "";
    switch (jj_nt.kind) {
    case SUB:{
      jj_consume_token(SUB);
sign = "-";
      break;
      }
    default:
      jj_la1[29] = jj_gen;
      ;
    }
    jj_consume_token(INTEGER);
{if ("" != null) return Integer.parseInt(sign + token.image);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String identifier() throws ParseException {String name;
    Function func;
    if (jj_2_8(2)) {
      name = tensorFunctionName();
{if ("" != null) return name;}
    } else {
      switch (jj_nt.kind) {
      case ABS:
      case ACOS:
      case ASIN:
      case ATAN:
      case CEIL:
      case COS:
      case COSH:
      case ELU:
      case EXP:
      case FABS:
      case FLOOR:
      case ISNAN:
      case LOG:
      case LOG10:
      case RELU:
      case ROUND:
      case SIGMOID:
      case SIGN:
      case SIN:
      case SINH:
      case SQUARE:
      case SQRT:
      case TAN:
      case TANH:
      case ERF:{
        func = unaryFunctionName();
{if ("" != null) return func.toString();}
        break;
        }
      case ATAN2:
      case FMOD:
      case LDEXP:
      case POW:
      case BIT:
      case HAMMING:
      case MAX:
      case MIN:{
        func = binaryFunctionName();
{if ("" != null) return func.toString();}
        break;
        }
      case IF:{
        jj_consume_token(IF);
{if ("" != null) return token.image;}
        break;
        }
      case IN:{
        jj_consume_token(IN);
{if ("" != null) return token.image;}
        break;
        }
      case IDENTIFIER:{
        jj_consume_token(IDENTIFIER);
{if ("" != null) return token.image;}
        break;
        }
      case TRUE:{
        jj_consume_token(TRUE);
{if ("" != null) return token.image;}
        break;
        }
      case FALSE:{
        jj_consume_token(FALSE);
{if ("" != null) return token.image;}
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<String> identifierList() throws ParseException {List<String> list = new ArrayList<String>();
    String element;
    switch (jj_nt.kind) {
    case IF:
    case IN:
    case F:
    case ABS:
    case ACOS:
    case ASIN:
    case ATAN:
    case CEIL:
    case COS:
    case COSH:
    case ELU:
    case EXP:
    case FABS:
    case FLOOR:
    case ISNAN:
    case LOG:
    case LOG10:
    case RELU:
    case ROUND:
    case SIGMOID:
    case SIGN:
    case SIN:
    case SINH:
    case SQUARE:
    case SQRT:
    case TAN:
    case TANH:
    case ERF:
    case ATAN2:
    case FMOD:
    case LDEXP:
    case POW:
    case BIT:
    case HAMMING:
    case MAP:
    case REDUCE:
    case JOIN:
    case MERGE:
    case RENAME:
    case CONCAT:
    case TENSOR:
    case RANGE:
    case DIAG:
    case RANDOM:
    case L1_NORMALIZE:
    case L2_NORMALIZE:
    case EUCLIDEAN_DISTANCE:
    case COSINE_SIMILARITY:
    case MATMUL:
    case SOFTMAX:
    case XW_PLUS_B:
    case ARGMAX:
    case ARGMIN:
    case CELL_CAST:
    case EXPAND:
    case AVG:
    case COUNT:
    case MAX:
    case MEDIAN:
    case MIN:
    case PROD:
    case SUM:
    case TRUE:
    case FALSE:
    case IDENTIFIER:{
      element = identifier();
list.add(element);
      break;
      }
    default:
      jj_la1[31] = jj_gen;
      ;
    }
    label_7:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        break label_7;
      }
      jj_consume_token(COMMA);
      element = identifier();
list.add(element);
    }
{if ("" != null) return list;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<String> bracedIdentifierList() throws ParseException {List<String> list = new ArrayList<String>();
    String element;
    switch (jj_nt.kind) {
    case IF:
    case IN:
    case F:
    case ABS:
    case ACOS:
    case ASIN:
    case ATAN:
    case CEIL:
    case COS:
    case COSH:
    case ELU:
    case EXP:
    case FABS:
    case FLOOR:
    case ISNAN:
    case LOG:
    case LOG10:
    case RELU:
    case ROUND:
    case SIGMOID:
    case SIGN:
    case SIN:
    case SINH:
    case SQUARE:
    case SQRT:
    case TAN:
    case TANH:
    case ERF:
    case ATAN2:
    case FMOD:
    case LDEXP:
    case POW:
    case BIT:
    case HAMMING:
    case MAP:
    case REDUCE:
    case JOIN:
    case MERGE:
    case RENAME:
    case CONCAT:
    case TENSOR:
    case RANGE:
    case DIAG:
    case RANDOM:
    case L1_NORMALIZE:
    case L2_NORMALIZE:
    case EUCLIDEAN_DISTANCE:
    case COSINE_SIMILARITY:
    case MATMUL:
    case SOFTMAX:
    case XW_PLUS_B:
    case ARGMAX:
    case ARGMIN:
    case CELL_CAST:
    case EXPAND:
    case AVG:
    case COUNT:
    case MAX:
    case MEDIAN:
    case MIN:
    case PROD:
    case SUM:
    case TRUE:
    case FALSE:
    case IDENTIFIER:{
      element = identifier();
{if ("" != null) return Collections.singletonList(element);}
      break;
      }
    case LBRACE:{
      jj_consume_token(LBRACE);
      list = identifierList();
      jj_consume_token(RBRACE);
{if ("" != null) return list;}
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

// An identifier or integer
  final public String tag() throws ParseException {String name;
    switch (jj_nt.kind) {
    case IF:
    case IN:
    case F:
    case ABS:
    case ACOS:
    case ASIN:
    case ATAN:
    case CEIL:
    case COS:
    case COSH:
    case ELU:
    case EXP:
    case FABS:
    case FLOOR:
    case ISNAN:
    case LOG:
    case LOG10:
    case RELU:
    case ROUND:
    case SIGMOID:
    case SIGN:
    case SIN:
    case SINH:
    case SQUARE:
    case SQRT:
    case TAN:
    case TANH:
    case ERF:
    case ATAN2:
    case FMOD:
    case LDEXP:
    case POW:
    case BIT:
    case HAMMING:
    case MAP:
    case REDUCE:
    case JOIN:
    case MERGE:
    case RENAME:
    case CONCAT:
    case TENSOR:
    case RANGE:
    case DIAG:
    case RANDOM:
    case L1_NORMALIZE:
    case L2_NORMALIZE:
    case EUCLIDEAN_DISTANCE:
    case COSINE_SIMILARITY:
    case MATMUL:
    case SOFTMAX:
    case XW_PLUS_B:
    case ARGMAX:
    case ARGMIN:
    case CELL_CAST:
    case EXPAND:
    case AVG:
    case COUNT:
    case MAX:
    case MEDIAN:
    case MIN:
    case PROD:
    case SUM:
    case TRUE:
    case FALSE:
    case IDENTIFIER:{
      name = identifier();
{if ("" != null) return name;}
      break;
      }
    case SUB:{
      jj_consume_token(SUB);
      jj_consume_token(INTEGER);
{if ("" != null) return "-" + token.image;}
      break;
      }
    case INTEGER:{
      jj_consume_token(INTEGER);
{if ("" != null) return token.image;}
      break;
      }
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<String> tagCommaLeadingList() throws ParseException {List<String> list = new ArrayList<String>();
    String element;
    label_8:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[35] = jj_gen;
        break label_8;
      }
      jj_consume_token(COMMA);
      element = tag();
list.add(element);
    }
{if ("" != null) return list;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ExpressionNode constantPrimitive(boolean negate) throws ParseException {String value;
    ExpressionNode node;
    switch (jj_nt.kind) {
    case SUB:{
      jj_consume_token(SUB);
negate = !negate;
      break;
      }
    default:
      jj_la1[36] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case INTEGER:
    case FLOAT:{
      switch (jj_nt.kind) {
      case INTEGER:{
        jj_consume_token(INTEGER);
value = token.image;
        break;
        }
      case FLOAT:{
        jj_consume_token(FLOAT);
value = token.image;
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
node = new ConstantNode(Value.parse(negate ? ("-" + value) : value));
      break;
      }
    case STRING:
    case TRUE:
    case FALSE:{
      switch (jj_nt.kind) {
      case STRING:{
        jj_consume_token(STRING);
        break;
        }
      case TRUE:{
        jj_consume_token(TRUE);
        break;
        }
      case FALSE:{
        jj_consume_token(FALSE);
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
node = new ConstantNode(Value.parse(token.image));
        if (negate) node = new NegativeNode(node);
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return node;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public TensorFunctionNode tensorValueBody(TensorType type, List dimensionOrder) throws ParseException {DynamicTensor dynamicTensor;
    jj_consume_token(COLON);
    if (jj_2_9(2)) {
      dynamicTensor = mixedTensorValueBody(type, dimensionOrder);
    } else {
      switch (jj_nt.kind) {
      case LCURLY:{
        dynamicTensor = mappedTensorValueBody(type);
        break;
        }
      case LSQUARE:{
        dynamicTensor = indexedTensorValueBody(type, dimensionOrder);
        break;
        }
      default:
        jj_la1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return new TensorFunctionNode(dynamicTensor);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public DynamicTensor mappedTensorValueBody(TensorType type) throws ParseException {java.util.Map cells = new LinkedHashMap();
    jj_consume_token(LCURLY);
    switch (jj_nt.kind) {
    case LCURLY:{
      tensorCell(type, cells);
      break;
      }
    default:
      jj_la1[41] = jj_gen;
      ;
    }
    label_9:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[42] = jj_gen;
        break label_9;
      }
      jj_consume_token(COMMA);
      tensorCell(type, cells);
    }
    jj_consume_token(RCURLY);
{if ("" != null) return DynamicTensor.from(type, TensorFunctionNode.wrapScalars(cells));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public DynamicTensor mixedTensorValueBody(TensorType type, List dimensionOrder) throws ParseException {java.util.Map cells = new LinkedHashMap();
    jj_consume_token(LCURLY);
    keyValueOrMixedBlock(type, dimensionOrder, cells);
    label_10:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        break label_10;
      }
      jj_consume_token(COMMA);
      keyValueOrMixedBlock(type, dimensionOrder, cells);
    }
    jj_consume_token(RCURLY);
{if ("" != null) return DynamicTensor.from(type, cells);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public DynamicTensor indexedTensorValueBody(TensorType type, List dimensionOrder) throws ParseException {List cells;
    cells = indexedTensorCells();
{if ("" != null) return DynamicTensor.from(type, TensorFunctionNode.wrapScalars(type, dimensionOrder, cells));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void keyValueOrMixedBlock(TensorType type, List dimensionOrder, java.util.Map cellMap) throws ParseException {
    if (jj_2_10(3)) {
      mixedBlock(type, dimensionOrder, cellMap);
    } else {
      switch (jj_nt.kind) {
      case INTEGER:
      case SUB:
      case STRING:
      case IF:
      case IN:
      case F:
      case ABS:
      case ACOS:
      case ASIN:
      case ATAN:
      case CEIL:
      case COS:
      case COSH:
      case ELU:
      case EXP:
      case FABS:
      case FLOOR:
      case ISNAN:
      case LOG:
      case LOG10:
      case RELU:
      case ROUND:
      case SIGMOID:
      case SIGN:
      case SIN:
      case SINH:
      case SQUARE:
      case SQRT:
      case TAN:
      case TANH:
      case ERF:
      case ATAN2:
      case FMOD:
      case LDEXP:
      case POW:
      case BIT:
      case HAMMING:
      case MAP:
      case REDUCE:
      case JOIN:
      case MERGE:
      case RENAME:
      case CONCAT:
      case TENSOR:
      case RANGE:
      case DIAG:
      case RANDOM:
      case L1_NORMALIZE:
      case L2_NORMALIZE:
      case EUCLIDEAN_DISTANCE:
      case COSINE_SIMILARITY:
      case MATMUL:
      case SOFTMAX:
      case XW_PLUS_B:
      case ARGMAX:
      case ARGMIN:
      case CELL_CAST:
      case EXPAND:
      case AVG:
      case COUNT:
      case MAX:
      case MEDIAN:
      case MIN:
      case PROD:
      case SUM:
      case TRUE:
      case FALSE:
      case IDENTIFIER:{
        keyValue(type, cellMap);
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

  final public void keyValue(TensorType type, java.util.Map cellMap) throws ParseException {String label;
    ExpressionNode value;
    label = label();
    jj_consume_token(COLON);
    value = expression();
cellMap.put(TensorAddress.ofLabels(label), TensorFunctionNode.wrapScalar(value));
}

  final public void mixedBlock(TensorType type, List dimensionOrder, java.util.Map cellMap) throws ParseException {String label;
    List cells;
    label = label();
    jj_consume_token(COLON);
    cells = indexedTensorCells();
TensorFunctionNode.wrapScalarBlock(type, dimensionOrder, label, cells, cellMap);
}

  final public List indexedTensorCells() throws ParseException {List cells = new ArrayList();
    jj_consume_token(LSQUARE);
    indexedTensorCellSubspaceList(cells);
    jj_consume_token(RSQUARE);
{if ("" != null) return cells;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void indexedTensorCellSubspaceList(List cells) throws ParseException {
    indexedTensorCellSubspace(cells);
    label_11:
    while (true) {
      if (jj_2_11(2)) {
      } else {
        break label_11;
      }
      jj_consume_token(COMMA);
      indexedTensorCellSubspace(cells);
    }
}

  final public void indexedTensorCellSubspace(List cells) throws ParseException {ExpressionNode value;
    switch (jj_nt.kind) {
    case LSQUARE:{
      jj_consume_token(LSQUARE);
      indexedTensorCellSubspaceList(cells);
      jj_consume_token(RSQUARE);
      break;
      }
    case INTEGER:
    case FLOAT:
    case LBRACE:
    case SUB:
    case DOLLAR:
    case STRING:
    case IF:
    case IN:
    case F:
    case NOT:
    case ABS:
    case ACOS:
    case ASIN:
    case ATAN:
    case CEIL:
    case COS:
    case COSH:
    case ELU:
    case EXP:
    case FABS:
    case FLOOR:
    case ISNAN:
    case LOG:
    case LOG10:
    case RELU:
    case ROUND:
    case SIGMOID:
    case SIGN:
    case SIN:
    case SINH:
    case SQUARE:
    case SQRT:
    case TAN:
    case TANH:
    case ERF:
    case ATAN2:
    case FMOD:
    case LDEXP:
    case POW:
    case BIT:
    case HAMMING:
    case MAP:
    case REDUCE:
    case JOIN:
    case MERGE:
    case RENAME:
    case CONCAT:
    case TENSOR:
    case RANGE:
    case DIAG:
    case RANDOM:
    case L1_NORMALIZE:
    case L2_NORMALIZE:
    case EUCLIDEAN_DISTANCE:
    case COSINE_SIMILARITY:
    case MATMUL:
    case SOFTMAX:
    case XW_PLUS_B:
    case ARGMAX:
    case ARGMIN:
    case CELL_CAST:
    case EXPAND:
    case AVG:
    case COUNT:
    case MAX:
    case MEDIAN:
    case MIN:
    case PROD:
    case SUM:
    case TRUE:
    case FALSE:
    case IDENTIFIER:{
      value = expression();
cells.add(value);
      break;
      }
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void tensorCell(TensorType type, java.util.Map cells) throws ParseException {ExpressionNode value;
    TensorAddress.Builder addressBuilder = new TensorAddress.Builder(type);
    jj_consume_token(LCURLY);
    label_12:
    while (true) {
      switch (jj_nt.kind) {
      case IF:
      case IN:
      case F:
      case ABS:
      case ACOS:
      case ASIN:
      case ATAN:
      case CEIL:
      case COS:
      case COSH:
      case ELU:
      case EXP:
      case FABS:
      case FLOOR:
      case ISNAN:
      case LOG:
      case LOG10:
      case RELU:
      case ROUND:
      case SIGMOID:
      case SIGN:
      case SIN:
      case SINH:
      case SQUARE:
      case SQRT:
      case TAN:
      case TANH:
      case ERF:
      case ATAN2:
      case FMOD:
      case LDEXP:
      case POW:
      case BIT:
      case HAMMING:
      case MAP:
      case REDUCE:
      case JOIN:
      case MERGE:
      case RENAME:
      case CONCAT:
      case TENSOR:
      case RANGE:
      case DIAG:
      case RANDOM:
      case L1_NORMALIZE:
      case L2_NORMALIZE:
      case EUCLIDEAN_DISTANCE:
      case COSINE_SIMILARITY:
      case MATMUL:
      case SOFTMAX:
      case XW_PLUS_B:
      case ARGMAX:
      case ARGMIN:
      case CELL_CAST:
      case EXPAND:
      case AVG:
      case COUNT:
      case MAX:
      case MEDIAN:
      case MIN:
      case PROD:
      case SUM:
      case TRUE:
      case FALSE:
      case IDENTIFIER:{
        break;
        }
      default:
        jj_la1[46] = jj_gen;
        break label_12;
      }
      labelAndDimension(addressBuilder);
    }
    label_13:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[47] = jj_gen;
        break label_13;
      }
      jj_consume_token(COMMA);
      labelAndDimension(addressBuilder);
    }
    jj_consume_token(RCURLY);
    jj_consume_token(COLON);
    value = expression();
cells.put(addressBuilder.build(), value);
}

  final public void labelAndDimension(TensorAddress.Builder addressBuilder) throws ParseException {String dimension, label;
    dimension = identifier();
    jj_consume_token(COLON);
    label = label();
addressBuilder.add(dimension, label);
}

  final public void labelAndDimensionValues(List addressValues) throws ParseException {String dimension;
    Slice.DimensionValue dimensionValue;
    dimension = identifier();
    jj_consume_token(COLON);
    dimensionValue = dimensionValue(Optional.of(dimension));
addressValues.add(dimensionValue);
}

/** A tensor address (possibly on short form) represented as a list because the tensor type is not available */
  final public List valueAddress() throws ParseException {List dimensionValues = new ArrayList();
    ExpressionNode valueExpression;
    Slice.DimensionValue dimensionValue;
    switch (jj_nt.kind) {
    case LSQUARE:{
      jj_consume_token(LSQUARE);
      valueExpression = expression();
dimensionValues.add(new Slice.DimensionValue(TensorFunctionNode.wrapScalar(valueExpression)));
      jj_consume_token(RSQUARE);
      break;
      }
    default:
      jj_la1[50] = jj_gen;
      if (jj_2_12(3)) {
        jj_consume_token(LCURLY);
        label_14:
        while (true) {
          labelAndDimensionValues(dimensionValues);
          switch (jj_nt.kind) {
          case IF:
          case IN:
          case F:
          case ABS:
          case ACOS:
          case ASIN:
          case ATAN:
          case CEIL:
          case COS:
          case COSH:
          case ELU:
          case EXP:
          case FABS:
          case FLOOR:
          case ISNAN:
          case LOG:
          case LOG10:
          case RELU:
          case ROUND:
          case SIGMOID:
          case SIGN:
          case SIN:
          case SINH:
          case SQUARE:
          case SQRT:
          case TAN:
          case TANH:
          case ERF:
          case ATAN2:
          case FMOD:
          case LDEXP:
          case POW:
          case BIT:
          case HAMMING:
          case MAP:
          case REDUCE:
          case JOIN:
          case MERGE:
          case RENAME:
          case CONCAT:
          case TENSOR:
          case RANGE:
          case DIAG:
          case RANDOM:
          case L1_NORMALIZE:
          case L2_NORMALIZE:
          case EUCLIDEAN_DISTANCE:
          case COSINE_SIMILARITY:
          case MATMUL:
          case SOFTMAX:
          case XW_PLUS_B:
          case ARGMAX:
          case ARGMIN:
          case CELL_CAST:
          case EXPAND:
          case AVG:
          case COUNT:
          case MAX:
          case MEDIAN:
          case MIN:
          case PROD:
          case SUM:
          case TRUE:
          case FALSE:
          case IDENTIFIER:{
            break;
            }
          default:
            jj_la1[48] = jj_gen;
            break label_14;
          }
        }
        label_15:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:{
            break;
            }
          default:
            jj_la1[49] = jj_gen;
            break label_15;
          }
          jj_consume_token(COMMA);
          labelAndDimensionValues(dimensionValues);
        }
        jj_consume_token(RCURLY);
      } else {
        switch (jj_nt.kind) {
        case LCURLY:{
          jj_consume_token(LCURLY);
          dimensionValue = dimensionValue(Optional.empty());
dimensionValues.add(dimensionValue);
          jj_consume_token(RCURLY);
          break;
          }
        default:
          jj_la1[51] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return dimensionValues;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Slice.DimensionValue dimensionValue(Optional dimensionName) throws ParseException {ExpressionNode value;
    value = expression();
if (value instanceof ReferenceNode && ((ReferenceNode)value).reference().isIdentifier()) // A label
            {if ("" != null) return new Slice.DimensionValue(dimensionName, ((ReferenceNode)value).reference().name());}
        else if (value instanceof ConstantNode && ((ConstantNode)value).getValue() instanceof StringValue) // A quoted label
            {if ("" != null) return new Slice.DimensionValue(dimensionName, ((StringValue)((ConstantNode)value).getValue()).asString());}
        else
            {if ("" != null) return new Slice.DimensionValue(dimensionName, TensorFunctionNode.wrapScalar(value));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String label() throws ParseException {String label;
    switch (jj_nt.kind) {
    case INTEGER:
    case SUB:
    case IF:
    case IN:
    case F:
    case ABS:
    case ACOS:
    case ASIN:
    case ATAN:
    case CEIL:
    case COS:
    case COSH:
    case ELU:
    case EXP:
    case FABS:
    case FLOOR:
    case ISNAN:
    case LOG:
    case LOG10:
    case RELU:
    case ROUND:
    case SIGMOID:
    case SIGN:
    case SIN:
    case SINH:
    case SQUARE:
    case SQRT:
    case TAN:
    case TANH:
    case ERF:
    case ATAN2:
    case FMOD:
    case LDEXP:
    case POW:
    case BIT:
    case HAMMING:
    case MAP:
    case REDUCE:
    case JOIN:
    case MERGE:
    case RENAME:
    case CONCAT:
    case TENSOR:
    case RANGE:
    case DIAG:
    case RANDOM:
    case L1_NORMALIZE:
    case L2_NORMALIZE:
    case EUCLIDEAN_DISTANCE:
    case COSINE_SIMILARITY:
    case MATMUL:
    case SOFTMAX:
    case XW_PLUS_B:
    case ARGMAX:
    case ARGMIN:
    case CELL_CAST:
    case EXPAND:
    case AVG:
    case COUNT:
    case MAX:
    case MEDIAN:
    case MIN:
    case PROD:
    case SUM:
    case TRUE:
    case FALSE:
    case IDENTIFIER:{
      label = tag();
      break;
      }
    case STRING:{
      label = string();
      break;
      }
    default:
      jj_la1[52] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return label;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String string() throws ParseException {
    jj_consume_token(STRING);
{if ("" != null) return token.image.substring(1, token.image.length() - 1);}
    throw new IllegalStateException ("Missing return statement in function");
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_3R_60()
 {
    if (jj_3R_70()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_147()
 {
    if (jj_scan_token(RANGE)) return true;
    if (jj_3R_170()) return true;
    return false;
  }

  private boolean jj_3R_148()
 {
    if (jj_scan_token(DIAG)) return true;
    if (jj_3R_170()) return true;
    return false;
  }

  private boolean jj_3R_18()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_27()) {
    jj_scanpos = xsp;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3R_28()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_27()
 {
    if (jj_scan_token(LSQUARE)) return true;
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_scan_token(LCURLY)) return true;
    Token xsp;
    if (jj_3R_25()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_25()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_149()
 {
    if (jj_scan_token(RANDOM)) return true;
    if (jj_3R_170()) return true;
    return false;
  }

  private boolean jj_3R_28()
 {
    if (jj_scan_token(LCURLY)) return true;
    if (jj_3R_62()) return true;
    return false;
  }

  private boolean jj_3R_25()
 {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_150()
 {
    if (jj_scan_token(L1_NORMALIZE)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_62()
 {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_151()
 {
    if (jj_scan_token(L2_NORMALIZE)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_56()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) return true;
    }
    return false;
  }

  private boolean jj_3R_68()
 {
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3R_152()
 {
    if (jj_scan_token(EUCLIDEAN_DISTANCE)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_131()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_153()
 {
    if (jj_scan_token(COSINE_SIMILARITY)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_69()
 {
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3R_154()
 {
    if (jj_scan_token(MATMUL)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_155()
 {
    if (jj_scan_token(SOFTMAX)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_156()
 {
    if (jj_scan_token(XW_PLUS_B)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_160()
 {
    if (jj_scan_token(EXPAND)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_157()
 {
    if (jj_scan_token(ARGMAX)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_3R_169()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_158()
 {
    if (jj_scan_token(ARGMIN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_3R_169()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_159()
 {
    if (jj_scan_token(CELL_CAST)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_66()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_170()
 {
    if (jj_3R_180()) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_181()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_182()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_181()
 {
    if (jj_3R_189()) return true;
    return false;
  }

  private boolean jj_3R_182()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_189()) return true;
    return false;
  }

  private boolean jj_3R_180()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_188()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_188()
 {
    if (jj_scan_token(LESS)) return true;
    if (jj_3R_70()) return true;
    if (jj_scan_token(GREATER)) return true;
    return false;
  }

  private boolean jj_3R_189()
 {
    if (jj_3R_70()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_20()
 {
    if (jj_3R_31()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_168()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_205()
 {
    if (jj_scan_token(LCURLY)) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(LSQUARE)) return true;
    if (jj_scan_token(RSQUARE)) return true;
    return false;
  }

  private boolean jj_3R_206()
 {
    if (jj_scan_token(LSQUARE)) return true;
    return false;
  }

  private boolean jj_3R_168()
 {
    if (jj_scan_token(IN)) return true;
    return false;
  }

  private boolean jj_3R_21()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_32()
 {
    if (jj_scan_token(F)) return true;
    return false;
  }

  private boolean jj_3R_33()
 {
    if (jj_scan_token(MAP)) return true;
    return false;
  }

  private boolean jj_3R_31()
 {
    if (jj_3R_65()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_178()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_34()
 {
    if (jj_scan_token(REDUCE)) return true;
    return false;
  }

  private boolean jj_3R_35()
 {
    if (jj_scan_token(JOIN)) return true;
    return false;
  }

  private boolean jj_3R_36()
 {
    if (jj_scan_token(MERGE)) return true;
    return false;
  }

  private boolean jj_3R_37()
 {
    if (jj_scan_token(RENAME)) return true;
    return false;
  }

  private boolean jj_3R_38()
 {
    if (jj_scan_token(CONCAT)) return true;
    return false;
  }

  private boolean jj_3R_39()
 {
    if (jj_scan_token(TENSOR)) return true;
    return false;
  }

  private boolean jj_3R_178()
 {
    if (jj_3R_187()) return true;
    return false;
  }

  private boolean jj_3R_40()
 {
    if (jj_scan_token(RANGE)) return true;
    return false;
  }

  private boolean jj_3R_41()
 {
    if (jj_scan_token(DIAG)) return true;
    return false;
  }

  private boolean jj_3R_42()
 {
    if (jj_scan_token(RANDOM)) return true;
    return false;
  }

  private boolean jj_3R_187()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_190()) {
    jj_scanpos = xsp;
    if (jj_3R_191()) {
    jj_scanpos = xsp;
    if (jj_3R_192()) {
    jj_scanpos = xsp;
    if (jj_3R_193()) {
    jj_scanpos = xsp;
    if (jj_3R_194()) {
    jj_scanpos = xsp;
    if (jj_3R_195()) {
    jj_scanpos = xsp;
    if (jj_3R_196()) {
    jj_scanpos = xsp;
    if (jj_3R_197()) {
    jj_scanpos = xsp;
    if (jj_3R_198()) {
    jj_scanpos = xsp;
    if (jj_3R_199()) {
    jj_scanpos = xsp;
    if (jj_3R_200()) {
    jj_scanpos = xsp;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_3R_202()) {
    jj_scanpos = xsp;
    if (jj_3R_203()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_43()
 {
    if (jj_scan_token(L1_NORMALIZE)) return true;
    return false;
  }

  private boolean jj_3R_44()
 {
    if (jj_scan_token(L2_NORMALIZE)) return true;
    return false;
  }

  private boolean jj_3R_45()
 {
    if (jj_scan_token(EUCLIDEAN_DISTANCE)) return true;
    return false;
  }

  private boolean jj_3R_190()
 {
    if (jj_scan_token(OR)) return true;
    return false;
  }

  private boolean jj_3R_46()
 {
    if (jj_scan_token(COSINE_SIMILARITY)) return true;
    return false;
  }

  private boolean jj_3R_191()
 {
    if (jj_scan_token(AND)) return true;
    return false;
  }

  private boolean jj_3R_47()
 {
    if (jj_scan_token(MATMUL)) return true;
    return false;
  }

  private boolean jj_3R_192()
 {
    if (jj_scan_token(GREATEREQUAL)) return true;
    return false;
  }

  private boolean jj_3R_48()
 {
    if (jj_scan_token(SOFTMAX)) return true;
    return false;
  }

  private boolean jj_3R_193()
 {
    if (jj_scan_token(GREATER)) return true;
    return false;
  }

  private boolean jj_3R_49()
 {
    if (jj_scan_token(XW_PLUS_B)) return true;
    return false;
  }

  private boolean jj_3R_194()
 {
    if (jj_scan_token(LESSEQUAL)) return true;
    return false;
  }

  private boolean jj_3R_50()
 {
    if (jj_scan_token(ARGMAX)) return true;
    return false;
  }

  private boolean jj_3R_195()
 {
    if (jj_scan_token(LESS)) return true;
    return false;
  }

  private boolean jj_3R_51()
 {
    if (jj_scan_token(ARGMIN)) return true;
    return false;
  }

  private boolean jj_3R_196()
 {
    if (jj_scan_token(APPROX)) return true;
    return false;
  }

  private boolean jj_3R_52()
 {
    if (jj_scan_token(CELL_CAST)) return true;
    return false;
  }

  private boolean jj_3R_197()
 {
    if (jj_scan_token(NOTEQUAL)) return true;
    return false;
  }

  private boolean jj_3R_53()
 {
    if (jj_scan_token(EXPAND)) return true;
    return false;
  }

  private boolean jj_3R_198()
 {
    if (jj_scan_token(EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_54()
 {
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3R_199()
 {
    if (jj_scan_token(ADD)) return true;
    return false;
  }

  private boolean jj_3R_200()
 {
    if (jj_scan_token(SUB)) return true;
    return false;
  }

  private boolean jj_3R_201()
 {
    if (jj_scan_token(DIV)) return true;
    return false;
  }

  private boolean jj_3R_202()
 {
    if (jj_scan_token(MUL)) return true;
    return false;
  }

  private boolean jj_3R_203()
 {
    if (jj_scan_token(MOD)) return true;
    return false;
  }

  private boolean jj_3R_63()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_93()) {
    jj_scanpos = xsp;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) {
    jj_scanpos = xsp;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) {
    jj_scanpos = xsp;
    if (jj_3R_99()) {
    jj_scanpos = xsp;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    if (jj_3R_101()) {
    jj_scanpos = xsp;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) {
    jj_scanpos = xsp;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) {
    jj_scanpos = xsp;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) {
    jj_scanpos = xsp;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) {
    jj_scanpos = xsp;
    if (jj_3R_114()) {
    jj_scanpos = xsp;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3R_116()) {
    jj_scanpos = xsp;
    if (jj_3R_117()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_93()
 {
    if (jj_scan_token(ABS)) return true;
    return false;
  }

  private boolean jj_3R_204()
 {
    if (jj_scan_token(POWOP)) return true;
    return false;
  }

  private boolean jj_3R_94()
 {
    if (jj_scan_token(ACOS)) return true;
    return false;
  }

  private boolean jj_3R_95()
 {
    if (jj_scan_token(ASIN)) return true;
    return false;
  }

  private boolean jj_3R_96()
 {
    if (jj_scan_token(ATAN)) return true;
    return false;
  }

  private boolean jj_3R_97()
 {
    if (jj_scan_token(CEIL)) return true;
    return false;
  }

  private boolean jj_3R_98()
 {
    if (jj_scan_token(COS)) return true;
    return false;
  }

  private boolean jj_3R_99()
 {
    if (jj_scan_token(COSH)) return true;
    return false;
  }

  private boolean jj_3R_100()
 {
    if (jj_scan_token(ELU)) return true;
    return false;
  }

  private boolean jj_3R_101()
 {
    if (jj_scan_token(EXP)) return true;
    return false;
  }

  private boolean jj_3R_102()
 {
    if (jj_scan_token(FABS)) return true;
    return false;
  }

  private boolean jj_3R_103()
 {
    if (jj_scan_token(FLOOR)) return true;
    return false;
  }

  private boolean jj_3R_65()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_126()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_1()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_127()) {
    jj_scanpos = xsp;
    if (jj_3R_128()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_4()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_104()
 {
    if (jj_scan_token(ISNAN)) return true;
    return false;
  }

  private boolean jj_3R_105()
 {
    if (jj_scan_token(LOG)) return true;
    return false;
  }

  private boolean jj_3R_106()
 {
    if (jj_scan_token(LOG10)) return true;
    return false;
  }

  private boolean jj_3R_107()
 {
    if (jj_scan_token(RELU)) return true;
    return false;
  }

  private boolean jj_3R_108()
 {
    if (jj_scan_token(ROUND)) return true;
    return false;
  }

  private boolean jj_3R_109()
 {
    if (jj_scan_token(SIGMOID)) return true;
    return false;
  }

  private boolean jj_3R_126()
 {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(SUB)) return true;
    return false;
  }

  private boolean jj_3R_110()
 {
    if (jj_scan_token(SIGN)) return true;
    return false;
  }

  private boolean jj_3R_111()
 {
    if (jj_scan_token(SIN)) return true;
    return false;
  }

  private boolean jj_3R_127()
 {
    if (jj_3R_161()) return true;
    return false;
  }

  private boolean jj_3R_112()
 {
    if (jj_scan_token(SINH)) return true;
    return false;
  }

  private boolean jj_3R_128()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_113()
 {
    if (jj_scan_token(SQUARE)) return true;
    return false;
  }

  private boolean jj_3R_114()
 {
    if (jj_scan_token(SQRT)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3R_115()
 {
    if (jj_scan_token(TAN)) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_116()
 {
    if (jj_scan_token(TANH)) return true;
    return false;
  }

  private boolean jj_3R_117()
 {
    if (jj_scan_token(ERF)) return true;
    return false;
  }

  private boolean jj_3R_162()
 {
    if (jj_3R_176()) return true;
    return false;
  }

  private boolean jj_3R_163()
 {
    if (jj_3R_177()) return true;
    return false;
  }

  private boolean jj_3R_164()
 {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_64()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_118()) {
    jj_scanpos = xsp;
    if (jj_3R_119()) {
    jj_scanpos = xsp;
    if (jj_3R_120()) {
    jj_scanpos = xsp;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3R_122()) {
    jj_scanpos = xsp;
    if (jj_3R_123()) {
    jj_scanpos = xsp;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_118()
 {
    if (jj_scan_token(ATAN2)) return true;
    return false;
  }

  private boolean jj_3R_119()
 {
    if (jj_scan_token(FMOD)) return true;
    return false;
  }

  private boolean jj_3R_120()
 {
    if (jj_scan_token(LDEXP)) return true;
    return false;
  }

  private boolean jj_3R_121()
 {
    if (jj_scan_token(MAX)) return true;
    return false;
  }

  private boolean jj_3R_122()
 {
    if (jj_scan_token(MIN)) return true;
    return false;
  }

  private boolean jj_3R_123()
 {
    if (jj_scan_token(POW)) return true;
    return false;
  }

  private boolean jj_3R_124()
 {
    if (jj_scan_token(BIT)) return true;
    return false;
  }

  private boolean jj_3R_125()
 {
    if (jj_scan_token(HAMMING)) return true;
    return false;
  }

  private boolean jj_3R_16()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_176()
 {
    if (jj_3R_70()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_207()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_208()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_177()
 {
    if (jj_scan_token(DOLLAR)) return true;
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_207()
 {
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_3R_21()) return true;
    return false;
  }

  private boolean jj_3R_70()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) {
    jj_scanpos = xsp;
    if (jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3R_137()) {
    jj_scanpos = xsp;
    if (jj_3R_138()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_132()
 {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_133()
 {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_134()
 {
    if (jj_scan_token(IF)) return true;
    return false;
  }

  private boolean jj_3R_135()
 {
    if (jj_scan_token(IN)) return true;
    return false;
  }

  private boolean jj_3R_136()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_137()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_138()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_17()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) return true;
    }
    return false;
  }

  private boolean jj_3R_208()
 {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_130()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_165()) {
    jj_scanpos = xsp;
    if (jj_3R_166()) {
    jj_scanpos = xsp;
    if (jj_3R_167()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_165()
 {
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_166()
 {
    if (jj_scan_token(SUB)) return true;
    if (jj_scan_token(INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_167()
 {
    if (jj_scan_token(INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_19()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_29()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) return true;
    }
    return false;
  }

  private boolean jj_3R_29()
 {
    if (jj_3R_63()) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_30()
 {
    if (jj_3R_64()) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_169()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_179()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_179()
 {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_161()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_173()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_174()) {
    jj_scanpos = xsp;
    if (jj_3R_175()) return true;
    }
    return false;
  }

  private boolean jj_3R_61()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_173()
 {
    if (jj_scan_token(SUB)) return true;
    return false;
  }

  private boolean jj_3R_174()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    if (jj_3R_186()) return true;
    }
    return false;
  }

  private boolean jj_3R_71()
 {
    if (jj_3R_139()) return true;
    return false;
  }

  private boolean jj_3R_185()
 {
    if (jj_scan_token(INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_72()
 {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_175()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(97)) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_186()
 {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_73()
 {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_74()
 {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_75()
 {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_76()
 {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_77()
 {
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_79()
 {
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3R_80()
 {
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_81()
 {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_82()
 {
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_83()
 {
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3R_184()
 {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_84()
 {
    if (jj_3R_152()) return true;
    return false;
  }

  private boolean jj_3R_85()
 {
    if (jj_3R_153()) return true;
    return false;
  }

  private boolean jj_3R_86()
 {
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3R_87()
 {
    if (jj_3R_155()) return true;
    return false;
  }

  private boolean jj_3R_88()
 {
    if (jj_3R_156()) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_3R_22()) return true;
    return false;
  }

  private boolean jj_3R_89()
 {
    if (jj_3R_157()) return true;
    return false;
  }

  private boolean jj_3R_90()
 {
    if (jj_3R_158()) return true;
    return false;
  }

  private boolean jj_3R_91()
 {
    if (jj_3R_159()) return true;
    return false;
  }

  private boolean jj_3R_92()
 {
    if (jj_3R_160()) return true;
    return false;
  }

  private boolean jj_3R_26()
 {
    if (jj_3R_61()) return true;
    return false;
  }

  private boolean jj_3R_139()
 {
    if (jj_scan_token(MAP)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_22()
 {
    if (jj_scan_token(LCURLY)) return true;
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_140()
 {
    if (jj_scan_token(REDUCE)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_141()
 {
    if (jj_3R_66()) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_3R_169()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_23()) return true;
    return false;
  }

  private boolean jj_3R_55()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) return true;
    }
    return false;
  }

  private boolean jj_3R_142()
 {
    if (jj_scan_token(JOIN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_129()
 {
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3R_143()
 {
    if (jj_scan_token(MERGE)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_23()
 {
    if (jj_3R_56()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_57()
 {
    if (jj_scan_token(LSQUARE)) return true;
    return false;
  }

  private boolean jj_3R_144()
 {
    if (jj_scan_token(RENAME)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_145()
 {
    if (jj_scan_token(CONCAT)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_24()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) return true;
    }
    return false;
  }

  private boolean jj_3R_58()
 {
    if (jj_scan_token(LSQUARE)) return true;
    return false;
  }

  private boolean jj_3R_59()
 {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_146()
 {
    if (jj_scan_token(TENSOR)) return true;
    if (jj_3R_170()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) return true;
    }
    return false;
  }

  private boolean jj_3R_67()
 {
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_171()
 {
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3R_172()
 {
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_183()
 {
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_24()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public RankingExpressionParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[53];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x0,0x7f1bc000,0x7f1bc000,0x0,0x200100,0x80208144,0x400000,0x100,0x40000,0x40000,0x44,0x400000,0x80208144,0x0,0x0,0x0,0x800100,0x0,0x0,0x400000,0x8000000,0x1000,0x400,0x0,0x0,0x0,0x8000,0x44,0x8000,0x0,0x0,0x400000,0x100,0x8004,0x400000,0x8000,0x44,0x80000000,0x80000044,0x1400,0x1000,0x400000,0x400000,0x80008004,0x80208544,0x0,0x400000,0x0,0x400000,0x400,0x1000,0x80008004,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0xffffffc7,0x2,0x30,0x30,0x8,0xffffffc7,0xffffffc7,0x0,0x0,0x0,0x0,0xffffffc7,0x0,0xffffffcf,0x0,0xffffffc0,0x0,0x0,0x0,0xffffffc7,0x0,0x0,0x0,0x0,0x4,0x7fffffc0,0x80000000,0x0,0x0,0x0,0xffffffc3,0xffffffc7,0x0,0xffffffc7,0xffffffc7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffc7,0xffffffcf,0xffffffc7,0x0,0xffffffc7,0x0,0x0,0x0,0xffffffc7,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0xffffffff,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0xffffffff,0x0,0xffffffff,0xffffffe0,0x5000001f,0xffffffe0,0x0,0xfc000000,0xffffffff,0x0,0x0,0x0,0x0,0xffffffe0,0x0,0x5000001f,0x0,0x0,0x0,0x5000001f,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0xffffffff,0x0,0xffffffff,0x0,0x0,0x0,0xffffffff,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0xf,0x0,0x0,0x0,0x0,0xf,0xf,0x0,0x0,0x0,0x0,0xf,0x0,0xf,0x1,0x0,0x1,0x0,0x1,0xf,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0xe,0xf,0x0,0xf,0xf,0x0,0x0,0x0,0x6,0x6,0x0,0x0,0x0,0x0,0xf,0xf,0xf,0x0,0xf,0x0,0x0,0x0,0xf,};
	}
  private final JJCalls[] jj_2_rtns = new JJCalls[12];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /**
   * Constructor with InputStream and supplied encoding
   * @param stream input stream
   * @param encoding charset to be used. May not be <code>null</code>.
   */
  public RankingExpressionParser(final java.io.InputStream stream, final String encoding) {
   try {
     jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
   } catch(final java.io.UnsupportedEncodingException e) {
     throw new IllegalStateException(e);
   }
	 token_source = new RankingExpressionParserTokenManager(jj_input_stream);
	 token = new Token();
   jj_nt = token_source.getNextToken();
   token.next = jj_nt;
	 jj_gen = 0;
	 for (int i = 0; i < 53; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param stream input stream
   * @param encoding charset to be used. May not be <code>null</code>.
   */
  public void ReInit(final java.io.InputStream stream, final String encoding) {
	  try {
      jj_input_stream.reInit(stream, encoding, 1, 1);
    } catch(final java.io.UnsupportedEncodingException e) { 
      throw new IllegalStateException(e);
    }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
   jj_nt = token_source.getNextToken();
   token.next = jj_nt;
	 jj_gen = 0;
	 for (int i = 0; i < 53; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with InputStream.
   * @param stream char stream
   */
  public RankingExpressionParser(final java.io.Reader stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new RankingExpressionParserTokenManager(jj_input_stream);
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
   for (int i = 0; i < 53; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param stream char stream
   */
  public void ReInit(final java.io.Reader stream) {
	if (jj_input_stream == null) {
	  jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	  jj_input_stream.reInit(stream, 1, 1);
  }
	if (token_source == null) {
 token_source = new RankingExpressionParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
   for (int i = 0; i < 53; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with generated Token Manager.
   * @param tm Token manager to use
   */
  public RankingExpressionParser(final RankingExpressionParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
	 for (int i = 0; i < 53; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param tm Token manager to use
   */
  public void ReInit(final RankingExpressionParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
	 for (int i = 0; i < 53; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(final int kind) throws ParseException {
    final Token oldToken = token;
    token = jj_nt;
    if (token.next != null)
      jj_nt = jj_nt.next;
    else {
      jj_nt.next = token_source.getNextToken();
      jj_nt = jj_nt.next;
    }
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen)
              c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    jj_nt = token;
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  private static final class LookaheadSuccess extends IllegalStateException {}
  private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		   jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		   jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


  /**
   * @return the next Token.
   */
  public final Token getNextToken() {
   token = jj_nt;
   if (token.next != null)
     jj_nt = jj_nt.next;
   else
     jj_nt = jj_nt.next = token_source.getNextToken();
	 jj_gen++;
	 return token;
  }

  /**
   * @param index index to be retrieved
   * @return the specific Token.
   */
  public final Token getToken(final int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next == null)
        t.next = token_source.getNextToken();
      t = t.next;
    }
    return t;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
  if (pos >= 100) {
    return;
  }

  if (pos == jj_endpos + 1) {
    jj_lasttokens[jj_endpos++] = kind;
  } else if (jj_endpos != 0) {
    jj_expentry = new int[jj_endpos];

    for (int i = 0; i < jj_endpos; i++) {
      jj_expentry[i] = jj_lasttokens[i];
    }

    for (final int[] oldentry : jj_expentries) {
      if (oldentry.length == jj_expentry.length) {
        boolean isMatched = true;
        for (int i = 0; i < jj_expentry.length; i++) {
          if (oldentry[i] != jj_expentry[i]) {
            isMatched = false;
            break;
          }
        }
        if (isMatched) {
          jj_expentries.add(jj_expentry);
          break;
        }
      }
    }

    if (pos != 0) {
      jj_endpos = pos;
      jj_lasttokens[jj_endpos - 1] = kind;
    }
  }
}

  /**
   * Generate ParseException.
   * @return new Exception object. Never <code>null</code>
   */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[101];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 53; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 101; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /**
   * @return Always <code>false</code>.
   */
  public final boolean trace_enabled() {
    return false;
  }

  /** Enable tracing. */
  public final void enable_tracing() {}

  /** Disable tracing. */
  public final void disable_tracing() {}

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 12; i++) {
      try {
        JJCalls p = jj_2_rtns[i];
        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg;
            jj_scanpos = p.first;
            jj_lastpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
              case 6: jj_3_7(); break;
              case 7: jj_3_8(); break;
              case 8: jj_3_9(); break;
              case 9: jj_3_10(); break;
              case 10: jj_3_11(); break;
              case 11: jj_3_12(); break;
            }
          }
          p = p.next;
        } while (p != null);
      } catch(LookaheadSuccess ls) { /* ignore */ }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) {
        p.next = new JJCalls();
        p = p.next;
        break;
      }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
