/* TreeNetParser.java */
/* Generated by: ParserGeneratorCC: Do not edit this line. TreeNetParser.java */
package com.yahoo.searchlib.treenet.parser;

import com.yahoo.searchlib.rankingexpression.parser.RankingExpressionParser;
import com.yahoo.searchlib.treenet.rule.*;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeNetParser implements TreeNetParserConstants {

    void verifyCategoricalVar(String expected, String actual) throws ParseException {
        if (!expected.equals(actual)) {
            throw new ParseException("Expected variable '" + expected + "', got '" + actual + "'.");
        }
    }

    ComparisonCondition resolveCategoricalCondition(String var, Integer valA, Integer valB, String lblA, String lblB) {
        if (valA < valB)
            return new ComparisonCondition(var, valA + (valB - valA) / 2.0, lblA, lblB);
        else
            return new ComparisonCondition(var, valB + (valA - valB) / 2.0, lblB, lblA);
    }

  final public TreeNet treeNet() throws ParseException {String begin, label;
    Tree tree;
    Map<String,Tree> trees = new HashMap<String,Tree>();
    label_1:
    while (true) {
      switch (jj_nt.kind) {
      case INTEGER:
      case FLOAT:
      case STRING:
      case COMMA:
      case SEMICOLON:
      case EQ:
      case NL:
      case LBRACE:
      case RBRACE:
      case LCURLY:
      case RCURLY:
      case RETURN:
      case IDENTIFIER:{
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      ignoredCpp();
    }
    jj_consume_token(BEGIN);
    jj_consume_token(COLON);
    nl();
    jj_consume_token(LINK);
    jj_consume_token(IDENTIFIER);
begin = token.image;
    eol();
    jj_consume_token(PRED);
    jj_consume_token(EQ);
    jj_consume_token(TNSCORE);
    eol();
    jj_consume_token(RETURN);
    eol();
    label_2:
    while (true) {
      switch (jj_nt.kind) {
      case TNSCORE:
      case IDENTIFIER:{
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        break label_2;
      }
      tree = tree();
trees.put(tree.getName(), tree);
    }
    jj_consume_token(RETURN);
    jj_consume_token(SEMICOLON);
    label_3:
    while (true) {
      switch (jj_nt.kind) {
      case INTEGER:
      case FLOAT:
      case STRING:
      case COMMA:
      case SEMICOLON:
      case EQ:
      case NL:
      case LBRACE:
      case RBRACE:
      case LCURLY:
      case RCURLY:
      case RETURN:
      case IDENTIFIER:{
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_3;
      }
      ignoredCpp();
    }
    jj_consume_token(0);
{if ("" != null) return new TreeNet(begin, trees);}
    throw new IllegalStateException ("Missing return statement in function");
}

/** C++ code outside the model which we can ignore */
  final public void ignoredCpp() throws ParseException {
    switch (jj_nt.kind) {
    case RETURN:{
      jj_consume_token(RETURN);
      break;
      }
    case IDENTIFIER:{
      jj_consume_token(IDENTIFIER);
      break;
      }
    case FLOAT:{
      jj_consume_token(FLOAT);
      break;
      }
    case INTEGER:{
      jj_consume_token(INTEGER);
      break;
      }
    case STRING:{
      jj_consume_token(STRING);
      break;
      }
    case EQ:{
      jj_consume_token(EQ);
      break;
      }
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    case LBRACE:{
      jj_consume_token(LBRACE);
      break;
      }
    case RBRACE:{
      jj_consume_token(RBRACE);
      break;
      }
    case LCURLY:{
      jj_consume_token(LCURLY);
      break;
      }
    case RCURLY:{
      jj_consume_token(RCURLY);
      break;
      }
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      break;
      }
    case NL:{
      jj_consume_token(NL);
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public Tree tree() throws ParseException {String name;
    String begin = null, label;
    Double value = null;

    TreeNode node;
    Map<String,TreeNode> nodes = new HashMap<String,TreeNode>();
    switch (jj_nt.kind) {
    case TNSCORE:{
      value = tnScore();
      name = label();
      break;
      }
    case IDENTIFIER:{
      name = label();
      value = tnScore();
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_4:
    while (true) {
      if (jj_2_1(2147483647)) {
      } else {
        break label_4;
      }
      label = label();
if (begin == null) { begin = label; }
      switch (jj_nt.kind) {
      case IF:{
        node = condition();
nodes.put(label, node);
        break;
        }
      case RESPONSE:{
        node = response();
nodes.put(label, node);
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return new Tree(name, value, begin, nodes);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Double tnScore() throws ParseException {Double value = null;
    jj_consume_token(TNSCORE);
    jj_consume_token(EQ);
    switch (jj_nt.kind) {
    case INTEGER:
    case FLOAT:{
      value = floatVal();
      break;
      }
    case TNSCORE:{
      jj_consume_token(TNSCORE);
      jj_consume_token(ADD);
      jj_consume_token(RESPONSE);
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    eol();
{if ("" != null) return value;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Condition condition() throws ParseException {String var;
    Condition ret;
    jj_consume_token(IF);
    var = feature();
    switch (jj_nt.kind) {
    case LT:{
      ret = continuousCondition(var);
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      if (jj_2_2(8)) {
        ret = singleValueCategoricalCondition(var);
      } else {
        switch (jj_nt.kind) {
        case IN:{
          ret = setMembershipCondition(var);
          break;
          }
        default:
          jj_la1[8] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ComparisonCondition continuousCondition(String left) throws ParseException {Double right;
    String ift, iff;
    jj_consume_token(LT);
    right = floatVal();
    jj_consume_token(THEN);
    ift = jump();
    eol();
    jj_consume_token(ELSE);
    iff = jump();
    eol();
{if ("" != null) return new ComparisonCondition(left, right, ift, iff);}
    throw new IllegalStateException ("Missing return statement in function");
}

// Handle single-value IN expression as a regular comparison.
// This special case may be removed when IN support is implemented in ranking expressions in both C++ and Java
  final public ComparisonCondition singleValueCategoricalCondition(String varA) throws ParseException {Integer valA, valB;
    String lblA, lblB, varB;
    jj_consume_token(IN);
    jj_consume_token(LBRACE);
    valA = intVal();
    nl();
    jj_consume_token(RBRACE);
    jj_consume_token(THEN);
    lblA = jump();
    eol();
    jj_consume_token(ELSE);
    jj_consume_token(IF);
    varB = feature();
verifyCategoricalVar(varA, varB);
    jj_consume_token(IN);
    jj_consume_token(LBRACE);
    valB = intVal();
    nl();
    jj_consume_token(RBRACE);
    jj_consume_token(THEN);
    lblB = jump();
    eol();
{if ("" != null) return resolveCategoricalCondition(varA, valA, valB, lblA, lblB);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SetMembershipCondition setMembershipCondition(String testValue) throws ParseException {List<Object> setValues;
    String trueLabel, falseLabel;
    jj_consume_token(IN);
    jj_consume_token(LBRACE);
    setValues = valueList();
    jj_consume_token(RBRACE);
    jj_consume_token(THEN);
    trueLabel = jump();
    eol();
    jj_consume_token(ELSE);
    falseLabel = jump();
    eol();
{if ("" != null) return new SetMembershipCondition(testValue, setValues, trueLabel, falseLabel);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Response response() throws ParseException {Double val;
    String lbl;
    jj_consume_token(RESPONSE);
    jj_consume_token(EQ);
    val = floatVal();
    eol();
    lbl = jump();
    eol();
{if ("" != null) return new Response(val, lbl);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String feature() throws ParseException {String name;
    String arguments = null;
    String output = null;
    name = identifier();
    switch (jj_nt.kind) {
    case LBRACE:{
      jj_consume_token(LBRACE);
      arguments = featureArguments();
      jj_consume_token(RBRACE);
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case DOT:{
      jj_consume_token(DOT);
      output = featureOutputs();
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      ;
    }
{if ("" != null) return name + (arguments != null ? "(" + arguments + ")" : "") + (output !=null ? "." + output : "");}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String featureArguments() throws ParseException {String argument;
    StringBuilder arguments = new StringBuilder();
    argument = featureArgument();
arguments.append(argument);
    label_5:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMA);
      argument = featureArgument();
arguments.append(",").append(argument);
    }
{if ("" != null) return arguments.toString();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String featureArgument() throws ParseException {String argument;
    switch (jj_nt.kind) {
    case STRING:{
      argument = string();
      break;
      }
    case INTEGER:
    case FLOAT:{
      argument = floatImage();
      break;
      }
    case IDENTIFIER:{
      argument = feature();
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return argument;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String featureOutputs() throws ParseException {StringBuilder outputs = new StringBuilder();
    String output;
    output = featureOutput();
outputs.append(output);
    label_6:
    while (true) {
      switch (jj_nt.kind) {
      case DOT:{
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        break label_6;
      }
      jj_consume_token(DOT);
      output = featureOutput();
outputs.append(output);
    }
{if ("" != null) return outputs.toString();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String featureOutput() throws ParseException {String name;
    switch (jj_nt.kind) {
    case INTEGER:{
      jj_consume_token(INTEGER);
{if ("" != null) return token.image;}
      break;
      }
    case FLOAT:{
      jj_consume_token(FLOAT);
{if ("" != null) return token.image;}
      break;
      }
    case IDENTIFIER:{
      name = identifier();
{if ("" != null) return name;}
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String label() throws ParseException {String ret;
    ret = identifier();
    jj_consume_token(COLON);
    nl();
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void eol() throws ParseException {
    jj_consume_token(SEMICOLON);
    nl();
}

  final public void nl() throws ParseException {
    label_7:
    while (true) {
      jj_consume_token(NL);
      switch (jj_nt.kind) {
      case NL:{
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        break label_7;
      }
    }
}

  final public String jump() throws ParseException {
    jj_consume_token(GOTO);
    jj_consume_token(IDENTIFIER);
{if ("" != null) return token.image;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String identifier() throws ParseException {
    jj_consume_token(IDENTIFIER);
{if ("" != null) return token.image;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String spaceSeparatedIdentifiers() throws ParseException {StringBuilder identifiers = new StringBuilder();
    String identifier;
    identifier = identifier();
identifiers.append(identifier);
    label_8:
    while (true) {
      switch (jj_nt.kind) {
      case IDENTIFIER:{
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        break label_8;
      }
      identifier = identifier();
identifiers.append(identifier);
    }
{if ("" != null) return identifiers.toString();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<Object> valueList() throws ParseException {List<Object> values = new ArrayList<Object>();
    Object value;
    value = value();
values.add(value);
    label_9:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        break label_9;
      }
      jj_consume_token(COMMA);
      value = value();
values.add(value);
    }
{if ("" != null) return values;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Object value() throws ParseException {Object value;
    switch (jj_nt.kind) {
    case IDENTIFIER:{
      value = spaceSeparatedIdentifiers();
      break;
      }
    case INTEGER:{
      value = intVal();
      break;
      }
    case STRING:{
      value = string();
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return value;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String string() throws ParseException {
    jj_consume_token(STRING);
{if ("" != null) return token.image;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Integer intVal() throws ParseException {
    jj_consume_token(INTEGER);
{if ("" != null) return Integer.valueOf(token.image);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Double floatVal() throws ParseException {
    switch (jj_nt.kind) {
    case INTEGER:{
      jj_consume_token(INTEGER);
      break;
      }
    case FLOAT:{
      jj_consume_token(FLOAT);
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return Double.valueOf(token.image);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String floatImage() throws ParseException {
    switch (jj_nt.kind) {
    case INTEGER:{
      jj_consume_token(INTEGER);
      break;
      }
    case FLOAT:{
      jj_consume_token(FLOAT);
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return token.image;}
    throw new IllegalStateException ("Missing return statement in function");
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_3R_25()
 {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_29()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_45()
 {
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_49()
 {
    if (jj_3R_14()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_50()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_13()
 {
    if (jj_scan_token(IN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_18()) return true;
    if (jj_3R_15()) return true;
    if (jj_scan_token(RBRACE)) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_24()) return true;
    if (jj_scan_token(ELSE)) return true;
    if (jj_scan_token(IF)) return true;
    if (jj_3R_20()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_18()) return true;
    if (jj_3R_15()) return true;
    if (jj_scan_token(RBRACE)) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_21()
 {
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3R_30()
 {
    if (jj_3R_34()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_35()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_22()
 {
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_50()
 {
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_35()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_34()) return true;
    return false;
  }

  private boolean jj_3R_31()
 {
    if (jj_3R_36()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_37()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_34()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_41()
 {
    if (jj_scan_token(INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_28()
 {
    if (jj_scan_token(IN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_31()) return true;
    if (jj_scan_token(RBRACE)) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_24()) return true;
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_42()
 {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_37()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_36()) return true;
    return false;
  }

  private boolean jj_3R_43()
 {
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_39()
 {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3R_46()
 {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_36()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_10()
 {
    if (jj_3R_14()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_15()) return true;
    return false;
  }

  private boolean jj_3R_44()
 {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_17()
 {
    if (jj_scan_token(RESPONSE)) return true;
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_23()) return true;
    if (jj_3R_24()) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_47()
 {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_24()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_15()) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_10()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_11()) {
    jj_scanpos = xsp;
    if (jj_3R_12()) return true;
    }
    return false;
  }

  private boolean jj_3R_18()
 {
    if (jj_scan_token(INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_15()
 {
    Token xsp;
    if (jj_scan_token(25)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(25)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_20()
 {
    if (jj_3R_14()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_25()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_26()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_23()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) return true;
    }
    return false;
  }

  private boolean jj_3R_19()
 {
    if (jj_scan_token(GOTO)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_11()
 {
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3R_16()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_3R_20()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_21()) {
    jj_scanpos = xsp;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3R_22()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_40()
 {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_48()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) return true;
    }
    return false;
  }

  private boolean jj_3R_14()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_29()
 {
    if (jj_3R_32()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_33()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_26()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_30()) return true;
    return false;
  }

  private boolean jj_3R_33()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_32()) return true;
    return false;
  }

  private boolean jj_3R_27()
 {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_23()) return true;
    if (jj_scan_token(THEN)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_24()) return true;
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_19()) return true;
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_12()
 {
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_32()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_38()
 {
    if (jj_3R_47()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public TreeNetParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[21];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x7a0d0a20,0x0,0x7a0d0a20,0x7a0d0a20,0x0,0x80200000,0x220,0x1000000,0x400000,0x8000000,0x20000,0x10000,0xa20,0x20000,0x220,0x2000000,0x0,0x10000,0x820,0x220,0x220,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x9,0xc,0x9,0x9,0xc,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x8,0x0,0x8,0x0,0x8,0x0,0x0,};
	}
  private final JJCalls[] jj_2_rtns = new JJCalls[2];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /**
   * Constructor with InputStream and supplied encoding
   * @param stream input stream
   * @param encoding charset to be used. May not be <code>null</code>.
   */
  public TreeNetParser(final java.io.InputStream stream, final String encoding) {
   try {
     jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
   } catch(final java.io.UnsupportedEncodingException e) {
     throw new IllegalStateException(e);
   }
	 token_source = new TreeNetParserTokenManager(jj_input_stream);
	 token = new Token();
   jj_nt = token_source.getNextToken();
   token.next = jj_nt;
	 jj_gen = 0;
	 for (int i = 0; i < 21; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param stream input stream
   * @param encoding charset to be used. May not be <code>null</code>.
   */
  public void ReInit(final java.io.InputStream stream, final String encoding) {
	  try {
      jj_input_stream.reInit(stream, encoding, 1, 1);
    } catch(final java.io.UnsupportedEncodingException e) { 
      throw new IllegalStateException(e);
    }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
   jj_nt = token_source.getNextToken();
   token.next = jj_nt;
	 jj_gen = 0;
	 for (int i = 0; i < 21; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with InputStream.
   * @param stream char stream
   */
  public TreeNetParser(final java.io.Reader stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new TreeNetParserTokenManager(jj_input_stream);
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
   for (int i = 0; i < 21; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param stream char stream
   */
  public void ReInit(final java.io.Reader stream) {
	if (jj_input_stream == null) {
	  jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	  jj_input_stream.reInit(stream, 1, 1);
  }
	if (token_source == null) {
 token_source = new TreeNetParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
   for (int i = 0; i < 21; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with generated Token Manager.
   * @param tm Token manager to use
   */
  public TreeNetParser(final TreeNetParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
	 for (int i = 0; i < 21; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param tm Token manager to use
   */
  public void ReInit(final TreeNetParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
	 for (int i = 0; i < 21; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(final int kind) throws ParseException {
    final Token oldToken = token;
    token = jj_nt;
    if (token.next != null)
      jj_nt = jj_nt.next;
    else {
      jj_nt.next = token_source.getNextToken();
      jj_nt = jj_nt.next;
    }
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen)
              c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    jj_nt = token;
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  private static final class LookaheadSuccess extends IllegalStateException {}
  private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		   jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		   jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


  /**
   * @return the next Token.
   */
  public final Token getNextToken() {
   token = jj_nt;
   if (token.next != null)
     jj_nt = jj_nt.next;
   else
     jj_nt = jj_nt.next = token_source.getNextToken();
	 jj_gen++;
	 return token;
  }

  /**
   * @param index index to be retrieved
   * @return the specific Token.
   */
  public final Token getToken(final int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next == null)
        t.next = token_source.getNextToken();
      t = t.next;
    }
    return t;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
  if (pos >= 100) {
    return;
  }

  if (pos == jj_endpos + 1) {
    jj_lasttokens[jj_endpos++] = kind;
  } else if (jj_endpos != 0) {
    jj_expentry = new int[jj_endpos];

    for (int i = 0; i < jj_endpos; i++) {
      jj_expentry[i] = jj_lasttokens[i];
    }

    for (final int[] oldentry : jj_expentries) {
      if (oldentry.length == jj_expentry.length) {
        boolean isMatched = true;
        for (int i = 0; i < jj_expentry.length; i++) {
          if (oldentry[i] != jj_expentry[i]) {
            isMatched = false;
            break;
          }
        }
        if (isMatched) {
          jj_expentries.add(jj_expentry);
          break;
        }
      }
    }

    if (pos != 0) {
      jj_endpos = pos;
      jj_lasttokens[jj_endpos - 1] = kind;
    }
  }
}

  /**
   * Generate ParseException.
   * @return new Exception object. Never <code>null</code>
   */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[36];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 21; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 36; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /**
   * @return Always <code>false</code>.
   */
  public final boolean trace_enabled() {
    return false;
  }

  /** Enable tracing. */
  public final void enable_tracing() {}

  /** Disable tracing. */
  public final void disable_tracing() {}

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 2; i++) {
      try {
        JJCalls p = jj_2_rtns[i];
        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg;
            jj_scanpos = p.first;
            jj_lastpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
            }
          }
          p = p.next;
        } while (p != null);
      } catch(LookaheadSuccess ls) { /* ignore */ }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) {
        p.next = new JJCalls();
        p = p.next;
        break;
      }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
