/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation;

import com.yahoo.document.GlobalId;
import com.yahoo.searchlib.aggregation.Hit;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FS4Hit
extends Hit {
    private static final Logger log = Logger.getLogger(FS4Hit.class.getName());
    public static final int classId = FS4Hit.registerClass((int)16479, FS4Hit.class, FS4Hit::new);
    private int path = 0;
    private GlobalId globalId = new GlobalId(new byte[12]);
    private int distributionKey = -1;

    public FS4Hit() {
    }

    public FS4Hit(int path, GlobalId globalId, double rank) {
        this(path, globalId, rank, -1);
    }

    public FS4Hit(int path, GlobalId globalId, double rank, int distributionKey) {
        super(rank);
        this.path = path;
        this.globalId = globalId;
        this.distributionKey = distributionKey;
    }

    public int getPath() {
        return this.path;
    }

    public void setPath(int value) {
        this.path = value;
    }

    public GlobalId getGlobalId() {
        return this.globalId;
    }

    public int getDistributionKey() {
        return this.distributionKey;
    }

    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putInt(null, this.path);
        buf.put(null, this.globalId.getRawId());
        buf.putInt(null, this.distributionKey);
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        this.path = buf.getInt(null);
        this.globalId = new GlobalId(buf.getBytes(null, 12));
        this.distributionKey = buf.getInt(null);
        if (this.distributionKey < 0) {
            log.log(Level.WARNING, "Distribution key is negative: " + String.valueOf((Object)this));
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.path + this.globalId.hashCode() + this.distributionKey;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        FS4Hit rhs = (FS4Hit)((Object)obj);
        if (this.path != rhs.path) {
            return false;
        }
        if (!this.globalId.equals((Object)rhs.globalId)) {
            return false;
        }
        return this.distributionKey == rhs.distributionKey;
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("path", (Object)this.path);
        visitor.visit("globalId", (Object)this.globalId.toString());
        visitor.visit("distributionKey", (Object)this.distributionKey);
    }
}

