/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.DocumentAccessorNode;
import com.yahoo.searchlib.expression.ExpressionNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public final class DocumentFieldNode
extends DocumentAccessorNode {
    public static final int classId = DocumentFieldNode.registerClass((int)16440, DocumentFieldNode.class, DocumentFieldNode::new);
    private String fieldName;
    private ResultNode result;

    public DocumentFieldNode() {
    }

    public DocumentFieldNode(String fieldName) {
        this.setDocumentFieldName(fieldName);
    }

    public String getDocumentFieldName() {
        return this.fieldName;
    }

    void setDocumentFieldName(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name can not be null.");
        }
        this.fieldName = fieldName;
    }

    @Override
    public ResultNode getResult() {
        return this.result;
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        this.putUtf8(buf, this.fieldName);
        DocumentFieldNode.serializeOptional((Serializer)buf, (Identifiable)this.result);
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        this.fieldName = this.getUtf8(buf);
        this.result = (ResultNode)DocumentFieldNode.deserializeOptional((Deserializer)buf);
    }

    public int hashCode() {
        return super.hashCode() + this.fieldName.hashCode();
    }

    @Override
    protected boolean equalsExpression(ExpressionNode obj) {
        DocumentFieldNode rhs = (DocumentFieldNode)obj;
        if (!this.fieldName.equals(rhs.fieldName)) {
            return false;
        }
        return DocumentFieldNode.equals((Object)this.result, (Object)rhs.result);
    }

    @Override
    public DocumentFieldNode clone() {
        DocumentFieldNode obj = (DocumentFieldNode)super.clone();
        if (this.result != null) {
            obj.result = (ResultNode)this.result.clone();
        }
        return obj;
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("fieldName", (Object)this.fieldName);
        visitor.visit("result", (Object)this.result);
    }
}

