/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.cd.commons;

import ai.vespa.hosted.cd.Deployment;
import ai.vespa.hosted.cd.Endpoint;
import ai.vespa.hosted.cd.EndpointAuthenticator;
import ai.vespa.hosted.cd.commons.HttpEndpoint;
import java.net.URI;
import java.time.Instant;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class HttpDeployment
implements Deployment {
    private final Map<String, Endpoint> endpoints;
    private final String platform;
    private final long revision;
    private final Instant deployedAt;

    public HttpDeployment(String platform, long revision, Instant deployedAt, Map<String, URI> endpoints, EndpointAuthenticator authenticator) {
        this.platform = platform;
        this.revision = revision;
        this.deployedAt = deployedAt;
        this.endpoints = endpoints.entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> (String)entry.getKey(), entry -> new HttpEndpoint((URI)entry.getValue(), authenticator)));
    }

    public Endpoint endpoint(String id) {
        if (!this.endpoints.containsKey(id)) {
            throw new NoSuchElementException("No cluster with id '" + id + "'");
        }
        return this.endpoints.get(id);
    }

    public String platform() {
        return this.platform;
    }

    public long revision() {
        return this.revision;
    }

    public Instant deployedAt() {
        return this.deployedAt;
    }
}

