/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib;

import com.yahoo.document.BucketId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BucketDistribution {
    private static final Logger log = Logger.getLogger(BucketDistribution.class.getName());
    private final int[] bucketToColumn;
    private int numColumns;
    private final int numBucketBits;

    public BucketDistribution(int numColumns, int numBucketBits) {
        this.numBucketBits = numBucketBits;
        this.bucketToColumn = new int[this.getNumBuckets()];
        this.reset();
        this.setNumColumns(numColumns);
    }

    public BucketDistribution(BucketDistribution other) {
        this.bucketToColumn = (int[])other.bucketToColumn.clone();
        this.numColumns = other.numColumns;
        this.numBucketBits = other.numBucketBits;
    }

    private static int getNumBuckets(int numBucketBits) {
        return 1 << numBucketBits;
    }

    private static List<Integer> getBucketCount(int numColumns, int numBucketBits) {
        ArrayList<Integer> ret = new ArrayList<Integer>(numColumns);
        int cnt = BucketDistribution.getNumBuckets(numBucketBits) / numColumns;
        int rst = BucketDistribution.getNumBuckets(numBucketBits) % numColumns;
        for (int i = 0; i < numColumns; ++i) {
            ret.add(cnt + (i < rst ? 1 : 0));
        }
        return ret;
    }

    private static List<Integer> getBucketMigrateCount(int numColumns, int numBucketBits) {
        List<Integer> ret = BucketDistribution.getBucketCount(numColumns++, numBucketBits);
        int cnt = BucketDistribution.getNumBuckets(numBucketBits) / numColumns;
        int rst = BucketDistribution.getNumBuckets(numBucketBits) % numColumns;
        for (int i = 0; i < numColumns - 1; ++i) {
            ret.set(i, ret.get(i) - (cnt + (i < rst ? 1 : 0)));
        }
        return ret;
    }

    public void reset() {
        Arrays.fill(this.bucketToColumn, 0);
        this.numColumns = 1;
    }

    private void addColumn() {
        int newColumns = this.numColumns + 1;
        List<Integer> migrate = BucketDistribution.getBucketMigrateCount(this.numColumns, this.numBucketBits);
        int numBuckets = BucketDistribution.getNumBuckets(this.numBucketBits);
        for (int i = 0; i < numBuckets; ++i) {
            int old = this.bucketToColumn[i];
            if (migrate.get(old) <= 0) continue;
            this.bucketToColumn[i] = this.numColumns;
            migrate.set(old, migrate.get(old) - 1);
        }
        this.numColumns = newColumns;
    }

    public synchronized void setNumColumns(int numColumns) {
        if (numColumns < this.numColumns) {
            this.reset();
        }
        if (numColumns == this.numColumns) {
            return;
        }
        int i = numColumns - this.numColumns;
        while (--i >= 0) {
            this.addColumn();
        }
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public int getNumBuckets() {
        return BucketDistribution.getNumBuckets(this.numBucketBits);
    }

    public int getColumn(BucketId bucketId) {
        int ret = (int)(bucketId.getId() & (long)(BucketDistribution.getNumBuckets(this.numBucketBits) - 1));
        if (ret >= this.bucketToColumn.length) {
            log.log(Level.SEVERE, "The bucket distribution map is not in sync with the number of bucket bits. This should never happen! Distribution is broken!!");
            return 0;
        }
        return this.bucketToColumn[ret];
    }
}

