/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib;

import com.yahoo.data.access.helpers.MatchFeatureData;
import com.yahoo.vespa.objects.BufferSerializer;
import com.yahoo.vespa.objects.Deserializer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class SearchResult {
    private final int totalHits;
    private final Hit[] hits;
    private final TreeMap<Integer, byte[]> aggregatorList;
    private final TreeMap<Integer, byte[]> groupingList;
    private static final int EXTENSION_FLAGS_PRESENT = -1;
    private static final int MATCH_FEATURES_PRESENT_MASK = 1;

    public SearchResult(Deserializer buf) {
        int i;
        int i2;
        BufferSerializer bser = (BufferSerializer)buf;
        bser.order(ByteOrder.BIG_ENDIAN);
        this.totalHits = buf.getInt(null);
        int numHits = buf.getInt(null);
        int extensionFlags = 0;
        if (SearchResult.hasExtensionFlags(numHits)) {
            extensionFlags = buf.getInt(null);
            numHits = buf.getInt(null);
        }
        this.hits = new Hit[numHits];
        if (numHits != 0) {
            int docIdBufferLength = buf.getInt(null);
            byte[] cArr = bser.getBuf().array();
            int start = bser.getBuf().arrayOffset() + bser.position();
            for (i2 = 0; i2 < numHits; ++i2) {
                int end = start;
                while (cArr[end++] != 0) {
                }
                this.hits[i2] = new Hit(new String(cArr, start, end - start - 1, StandardCharsets.UTF_8), 0.0);
                start = end;
            }
            bser.position(start - bser.getBuf().arrayOffset());
            for (i2 = 0; i2 < numHits; ++i2) {
                this.hits[i2].setRank(buf.getDouble(null));
            }
        }
        int numSortBlobs = buf.getInt(null);
        int[] size = new int[numSortBlobs];
        for (i = 0; i < numSortBlobs; ++i) {
            size[i] = buf.getInt(null);
        }
        for (i = 0; i < numSortBlobs; ++i) {
            this.hits[i] = new HitWithSortBlob(this.hits[i], buf.getBytes(null, size[i]));
        }
        int numAggregators = buf.getInt(null);
        this.aggregatorList = new TreeMap();
        for (i2 = 0; i2 < numAggregators; ++i2) {
            int aggrId = buf.getInt(null);
            int aggrLength = buf.getInt(null);
            this.aggregatorList.put(aggrId, buf.getBytes(null, aggrLength));
        }
        int numGroupings = buf.getInt(null);
        this.groupingList = new TreeMap();
        for (int i3 = 0; i3 < numGroupings; ++i3) {
            int aggrId = buf.getInt(null);
            int aggrLength = buf.getInt(null);
            this.groupingList.put(aggrId, buf.getBytes(null, aggrLength));
        }
        if (SearchResult.hasMatchFeatures(extensionFlags)) {
            this.deserializeMatchFeatures(buf, numHits);
        }
    }

    private void deserializeMatchFeatures(Deserializer buf, int numHits) {
        ArrayList<String> featureNames = new ArrayList<String>();
        int numFeatures = buf.getInt(null);
        for (int i = 0; i < numFeatures; ++i) {
            featureNames.add(buf.getString(null));
        }
        MatchFeatureData factory = new MatchFeatureData(featureNames);
        for (int i = 0; i < numHits; ++i) {
            MatchFeatureData.HitValue matchFeatures = factory.addHit();
            for (int j = 0; j < numFeatures; ++j) {
                byte featureType = buf.getByte(null);
                if (SearchResult.isDoubleFeature(featureType)) {
                    matchFeatures.set(j, buf.getDouble(null));
                    continue;
                }
                int bufLength = buf.getInt(null);
                matchFeatures.set(j, buf.getBytes(null, bufLength));
            }
            this.hits[i].setMatchFeatures(matchFeatures);
        }
    }

    private static boolean hasExtensionFlags(int numHits) {
        return numHits == -1;
    }

    private static boolean hasMatchFeatures(int extensionFlags) {
        return (extensionFlags & 1) != 0;
    }

    private static boolean isDoubleFeature(byte featureType) {
        return featureType == 0;
    }

    public final int getHitCount() {
        return this.hits.length;
    }

    public final int getTotalHitCount() {
        return this.totalHits != 0 ? this.totalHits : this.getHitCount();
    }

    public final Hit getHit(int hitNo) {
        return this.hits[hitNo];
    }

    public final Map<Integer, byte[]> getGroupingList() {
        return this.groupingList;
    }

    public static class Hit
    implements Comparable<Hit> {
        private final String docId;
        private double rank;
        private MatchFeatureData.HitValue matchFeatures;

        public Hit(Hit h) {
            this.docId = h.docId;
            this.rank = h.rank;
            this.matchFeatures = h.matchFeatures;
        }

        public Hit(String docId, double rank) {
            this.rank = rank;
            this.docId = docId;
            this.matchFeatures = null;
        }

        public final String getDocId() {
            return this.docId;
        }

        public final double getRank() {
            return this.rank;
        }

        public final Optional<MatchFeatureData.HitValue> getMatchFeatures() {
            return Optional.ofNullable(this.matchFeatures);
        }

        public final void setRank(double rank) {
            this.rank = rank;
        }

        public final void setMatchFeatures(MatchFeatureData.HitValue matchFeatures) {
            this.matchFeatures = matchFeatures;
        }

        @Override
        public int compareTo(Hit h) {
            return h.rank < this.rank ? -1 : (h.rank > this.rank ? 1 : 0);
        }
    }

    public static class HitWithSortBlob
    extends Hit {
        private final byte[] sortBlob;

        public HitWithSortBlob(Hit h, byte[] sb) {
            super(h);
            this.sortBlob = sb;
        }

        public final byte[] getSortBlob() {
            return this.sortBlob;
        }

        @Override
        public int compareTo(Hit h) {
            HitWithSortBlob b = (HitWithSortBlob)h;
            int m = Math.min(this.sortBlob.length, b.sortBlob.length);
            for (int i = 0; i < m; ++i) {
                if (this.sortBlob[i] == b.sortBlob[i]) continue;
                return (this.sortBlob[i] & 0xFF) < (b.sortBlob[i] & 0xFF) ? -1 : 1;
            }
            return this.sortBlob.length - b.sortBlob.length;
        }
    }
}

