/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib.state;

import com.yahoo.text.StringUtilities;
import com.yahoo.vdslib.state.Diff;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import java.text.ParseException;
import java.util.Locale;
import java.util.StringTokenizer;

public class NodeState
implements Cloneable {
    public static final String ORCHESTRATOR_RESERVED_DESCRIPTION = "Orchestrator";
    private final NodeType type;
    private State state;
    private String description = "";
    private float capacity = 1.0f;
    private float initProgress = 1.0f;
    private int minUsedBits = 16;
    private long startTimestamp = 0L;

    public static float getListingBucketsInitProgressLimit() {
        return 0.01f;
    }

    public NodeState(NodeType type, State state) {
        this.type = type;
        this.state = state;
    }

    public NodeState clone() {
        try {
            return (NodeState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Does not happen");
        }
    }

    public boolean above(NodeState other) {
        return this.state.ordinal() > other.state.ordinal();
    }

    public boolean equals(Object o) {
        if (!(o instanceof NodeState)) {
            return false;
        }
        NodeState ns = (NodeState)o;
        return this.state == ns.state && !((double)Math.abs(this.capacity - ns.capacity) > 1.0E-10) && !((double)Math.abs(this.initProgress - ns.initProgress) > 1.0E-10) && this.startTimestamp == ns.startTimestamp && this.minUsedBits == ns.minUsedBits;
    }

    public int hashCode() {
        return this.state.hashCode() ^ Double.valueOf(this.capacity).hashCode();
    }

    public boolean similarTo(Object o) {
        if (!(o instanceof NodeState)) {
            return false;
        }
        return this.similarToImpl((NodeState)o, true);
    }

    public boolean similarToIgnoringInitProgress(NodeState other) {
        return this.similarToImpl(other, false);
    }

    private boolean similarToImpl(NodeState other, boolean considerInitProgress) {
        if (this.state != other.state) {
            return false;
        }
        if ((double)Math.abs(this.capacity - other.capacity) > 1.0E-10) {
            return false;
        }
        if (this.startTimestamp != other.startTimestamp) {
            return false;
        }
        return !considerInitProgress || !this.type.equals((Object)NodeType.STORAGE) || !(this.initProgress < NodeState.getListingBucketsInitProgressLimit() ^ other.initProgress < NodeState.getListingBucketsInitProgressLimit());
    }

    public Diff getDiff(NodeState other) {
        Diff diff = new Diff();
        if (!this.state.equals((Object)other.state)) {
            diff.add(new Diff.Entry("", (Object)this.state, (Object)other.state).bold());
        }
        if ((double)Math.abs(this.capacity - other.capacity) > 1.0E-9) {
            diff.add(new Diff.Entry("capacity", Float.valueOf(this.capacity), Float.valueOf(other.capacity)));
        }
        if (this.minUsedBits != other.minUsedBits) {
            diff.add(new Diff.Entry("minUsedBits", this.minUsedBits, other.minUsedBits));
        }
        if ((double)Math.abs(this.initProgress - other.initProgress) > 1.0E-9 && this.state.equals((Object)State.INITIALIZING) && other.state.equals((Object)State.INITIALIZING)) {
            diff.add(new Diff.Entry("initProgress", Float.valueOf(this.initProgress), Float.valueOf(other.initProgress)));
        }
        if (this.startTimestamp != other.startTimestamp) {
            diff.add(new Diff.Entry("startTimestamp", this.startTimestamp, other.startTimestamp));
        }
        if (!this.description.equals(other.description)) {
            diff.add(new Diff.Entry("description", this.description, other.description));
        }
        return diff;
    }

    public String getTextualDifference(NodeState other) {
        return this.getDiff(other).toString();
    }

    public NodeState setCapacity(float c) {
        this.capacity = c;
        return this;
    }

    public NodeState setInitProgress(float p) {
        this.initProgress = p;
        return this;
    }

    public NodeState setDescription(String desc) {
        this.description = desc;
        return this;
    }

    public NodeState setMinUsedBits(int u) {
        this.minUsedBits = u;
        return this;
    }

    public NodeState setState(State state) {
        this.state = state;
        return this;
    }

    public NodeState setStartTimestamp(long ts) {
        this.startTimestamp = ts;
        return this;
    }

    public double getCapacity() {
        return this.capacity;
    }

    public double getInitProgress() {
        return this.initProgress;
    }

    public boolean hasDescription() {
        return this.description.length() > 0;
    }

    public String getDescription() {
        return this.description;
    }

    public State getState() {
        return this.state;
    }

    public int getMinUsedBits() {
        return this.minUsedBits;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean compact) {
        StringBuilder sb = new StringBuilder();
        if (compact) {
            sb.append(this.state.serialize().toUpperCase());
        } else {
            sb.append((Object)this.state);
        }
        if (Math.abs((double)this.capacity - 1.0) > 1.0E-9) {
            sb.append(compact ? ", c " : ", capacity ").append(compact ? String.format(Locale.ENGLISH, "%.3g", Float.valueOf(this.capacity)) : Float.valueOf(this.capacity));
        }
        if (this.state.equals((Object)State.INITIALIZING)) {
            sb.append(compact ? ", i " : ", init progress ").append(compact ? String.format(Locale.ENGLISH, "%.3g", Float.valueOf(this.initProgress)) : Float.valueOf(this.initProgress));
            if (this.type.equals((Object)NodeType.STORAGE)) {
                if (this.initProgress < NodeState.getListingBucketsInitProgressLimit()) {
                    sb.append(compact ? " (ls)" : " (listing files)");
                } else {
                    sb.append(compact ? " (read)" : " (reading file headers)");
                }
            }
        }
        if (this.startTimestamp > 0L) {
            sb.append(compact ? ", t " : ", start timestamp ").append(this.startTimestamp);
        }
        if (this.minUsedBits != 16) {
            sb.append(compact ? ", b " : ", minimum used bits ").append(this.minUsedBits);
        }
        if (this.description.length() > 0) {
            sb.append(": ").append(this.description);
        }
        return sb.toString();
    }

    public String serialize() {
        return this.serialize(-1, false);
    }

    public String serialize(boolean verbose) {
        return this.serialize(-1, verbose);
    }

    public String serialize(int nodeIdx, boolean verbose) {
        Object prefix;
        boolean empty = true;
        StringBuilder sb = new StringBuilder();
        Object object = prefix = nodeIdx == -1 ? "" : "." + nodeIdx + ".";
        if (this.state != State.UP) {
            empty = false;
            sb.append((String)prefix).append("s:").append(this.state.serialize());
        }
        if (Math.abs((double)this.capacity - 1.0) > 1.0E-9) {
            if (empty) {
                empty = false;
            } else {
                sb.append(' ');
            }
            sb.append((String)prefix).append("c:").append(this.capacity);
        }
        if (this.state == State.INITIALIZING) {
            sb.append(' ');
            sb.append((String)prefix).append("i:").append(this.initProgress);
        }
        if (this.startTimestamp != 0L) {
            if (empty) {
                empty = false;
            } else {
                sb.append(' ');
            }
            sb.append((String)prefix).append("t:").append(this.startTimestamp);
        }
        if (nodeIdx == -1 && this.minUsedBits != 16) {
            if (empty) {
                empty = false;
            } else {
                sb.append(' ');
            }
            sb.append((String)prefix).append("b:").append(this.minUsedBits);
        }
        if ((verbose || nodeIdx == -1) && this.description.length() > 0) {
            if (!empty) {
                sb.append(' ');
            }
            sb.append((String)prefix).append("m:").append(StringUtilities.escape((String)this.description, (char)' '));
        }
        return sb.toString();
    }

    public static NodeState deserialize(NodeType type, String serialized) throws ParseException {
        NodeState newState = new NodeState(type, State.UP);
        StringTokenizer st = new StringTokenizer(serialized, " \t\r\f\n", false);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int index = token.indexOf(58);
            if (index < 0) {
                throw new ParseException("Token " + token + " does not contain ':': " + serialized, 0);
            }
            String key = token.substring(0, index);
            String value = token.substring(index + 1);
            if (key.length() > 0) {
                switch (key.charAt(0)) {
                    case 's': {
                        if (key.length() > 1) break;
                        newState.setState(State.get(value));
                        break;
                    }
                    case 'b': {
                        if (key.length() > 1) break;
                        newState.setMinUsedBits(Integer.parseInt(value));
                        break;
                    }
                    case 'c': {
                        if (key.length() > 1 || type != null && !type.equals((Object)NodeType.STORAGE)) break;
                        try {
                            newState.setCapacity(Float.parseFloat(value));
                            break;
                        }
                        catch (Exception e) {
                            throw new ParseException("Illegal capacity '" + value + "'. Capacity must be a positive floating point number", 0);
                        }
                    }
                    case 'i': {
                        if (key.length() > 1) break;
                        try {
                            newState.setInitProgress(Float.parseFloat(value));
                            break;
                        }
                        catch (Exception e) {
                            throw new ParseException("Illegal init progress '" + value + "'. Init progress must be a floating point number from 0.0 to 1.0", 0);
                        }
                    }
                    case 't': {
                        if (key.length() > 1) break;
                        try {
                            newState.setStartTimestamp(Long.parseLong(value));
                            if (newState.getStartTimestamp() < 0L) {
                                throw new Exception();
                            }
                            break;
                        }
                        catch (Exception e) {
                            throw new ParseException("Illegal start timestamp " + value + ". Start timestamp must be 0 or a positive long.", 0);
                        }
                    }
                    case 'm': {
                        if (key.length() > 1) break;
                        newState.setDescription(StringUtilities.unescape((String)value));
                        break;
                    }
                    case 'd': {
                        int diskIndex;
                        if (type != null && !type.equals((Object)NodeType.STORAGE)) break;
                        int size = 0;
                        if (key.length() == 1) {
                            try {
                                size = Integer.parseInt(value);
                                break;
                            }
                            catch (Exception e) {
                                throw new ParseException("Invalid disk count '" + value + "'. Need a positive integer value", 0);
                            }
                        }
                        if (key.charAt(1) != '.') break;
                        int endp = key.indexOf(46, 2);
                        String indexStr = endp < 0 ? key.substring(2) : key.substring(2, endp);
                        try {
                            diskIndex = Integer.parseInt(indexStr);
                        }
                        catch (Exception e) {
                            throw new ParseException("Invalid disk index '" + indexStr + "'. need a positive integer value", 0);
                        }
                        if (diskIndex < size) break;
                        throw new ParseException("Cannot index disk " + diskIndex + " of " + size, 0);
                    }
                }
            }
        }
        return newState;
    }

    public void verifyValidInSystemState(NodeType type) {
        if (!this.state.validCurrentNodeState(type)) {
            throw new IllegalArgumentException("State " + String.valueOf((Object)this.state) + " cannot fit in system state for node of type: " + String.valueOf((Object)type));
        }
        if (type.equals((Object)NodeType.DISTRIBUTOR) && Math.abs((double)this.capacity - 1.0) > 1.0E-9) {
            throw new IllegalArgumentException("Capacity should not be set for a distributor node");
        }
    }
}

