/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib;

import com.yahoo.vespa.objects.BufferSerializer;
import com.yahoo.vespa.objects.Deserializer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public class DocumentSummary {
    private final Summary[] summaries;

    public DocumentSummary(Deserializer buf) {
        BufferSerializer bser = (BufferSerializer)buf;
        bser.order(ByteOrder.BIG_ENDIAN);
        buf.getInt(null);
        int numSummaries = buf.getInt(null);
        this.summaries = new Summary[numSummaries];
        if (numSummaries > 0) {
            int summaryBufferSize = buf.getInt(null);
            byte[] cArr = bser.getBuf().array();
            int start = bser.getBuf().arrayOffset() + bser.position();
            bser.position(bser.position() + summaryBufferSize);
            for (int i = 0; i < numSummaries; ++i) {
                int summarySize = buf.getInt(null);
                int end = start;
                while (cArr[end++] != 0) {
                }
                byte[] sb = new byte[summarySize];
                System.arraycopy(cArr, end, sb, 0, summarySize);
                this.summaries[i] = new Summary(new String(cArr, start, end - start - 1, StandardCharsets.UTF_8), sb);
                start = end + summarySize;
            }
        }
    }

    public final int getSummaryCount() {
        return this.summaries.length;
    }

    public final Summary getSummary(int hitNo) {
        return this.summaries[hitNo];
    }

    public static class Summary
    implements Comparable<Summary> {
        private final String docId;
        private byte[] summary;

        private Summary(String docId) {
            this.docId = docId;
        }

        public Summary(String docId, byte[] summary) {
            this(docId);
            this.summary = summary;
        }

        public final String getDocId() {
            return this.docId;
        }

        public final byte[] getSummary() {
            return this.summary;
        }

        @Override
        public int compareTo(Summary s) {
            return this.getDocId().compareTo(s.getDocId());
        }
    }
}

