/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client.impl;

import ai.vespa.feed.client.HttpResponse;
import ai.vespa.feed.client.OperationStats;
import ai.vespa.feed.client.impl.Cluster;
import ai.vespa.feed.client.impl.HttpRequest;
import java.time.Instant;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class BenchmarkingCluster
implements Cluster {
    private final Cluster delegate;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(runnable -> {
        Thread thread = new Thread(runnable, "cluster-stats-collector");
        thread.setDaemon(true);
        return thread;
    });
    private final AtomicLong requests = new AtomicLong();
    private long results = 0L;
    private long responses = 0L;
    private final long[] responsesByCode = new long[600];
    private long exceptions = 0L;
    private long totalLatencyMillis = 0L;
    private long minLatencyMillis = Long.MAX_VALUE;
    private long maxLatencyMillis = 0L;
    private long bytesSent = 0L;
    private long bytesReceived = 0L;

    public BenchmarkingCluster(Cluster delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void dispatch(HttpRequest request, CompletableFuture<HttpResponse> vessel) {
        this.requests.incrementAndGet();
        long startNanos = System.nanoTime();
        this.delegate.dispatch(request, vessel);
        vessel.whenCompleteAsync((response, thrown) -> {
            ++this.results;
            if (thrown == null) {
                ++this.responses;
                int n = response.code();
                this.responsesByCode[n] = this.responsesByCode[n] + 1L;
                long latency = (System.nanoTime() - startNanos) / 1000000L;
                this.totalLatencyMillis += latency;
                this.minLatencyMillis = Math.min(this.minLatencyMillis, latency);
                this.maxLatencyMillis = Math.max(this.maxLatencyMillis, latency);
                this.bytesSent += request.body() == null ? 0L : (long)request.body().length;
                this.bytesReceived += response.body() == null ? 0L : (long)response.body().length;
            } else {
                ++this.exceptions;
            }
        }, (Executor)this.executor);
    }

    @Override
    public OperationStats stats() {
        try {
            try {
                return this.executor.submit(this::getStats).get();
            }
            catch (RejectedExecutionException ignored) {
                this.executor.awaitTermination(10L, TimeUnit.SECONDS);
                return this.getStats();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private OperationStats getStats() {
        long requests = this.requests.get();
        HashMap<Integer, Long> responses = new HashMap<Integer, Long>();
        for (int code = 0; code < this.responsesByCode.length; ++code) {
            if (this.responsesByCode[code] <= 0L) continue;
            responses.put(code, this.responsesByCode[code]);
        }
        return new OperationStats(requests, responses, this.exceptions, requests - this.results, this.responses == 0L ? -1L : this.totalLatencyMillis / this.responses, this.responses == 0L ? -1L : this.minLatencyMillis, this.responses == 0L ? -1L : this.maxLatencyMillis, this.bytesSent, this.bytesReceived);
    }

    @Override
    public void close() {
        this.delegate.close();
        Instant doom = Instant.now().plusSeconds(10L);
        while (Instant.now().isBefore(doom) && this.getStats().inflight() != 0L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.executor.shutdown();
    }
}

