/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client.impl;

import ai.vespa.feed.client.HttpResponse;
import ai.vespa.feed.client.OperationStats;
import ai.vespa.feed.client.impl.Cluster;
import ai.vespa.feed.client.impl.HttpRequest;
import ai.vespa.feed.client.impl.HttpRequestStrategy;
import ai.vespa.feed.client.impl.Throttler;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class BenchmarkingCluster
implements Cluster {
    private final Cluster delegate;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(runnable -> {
        Thread thread = new Thread(runnable, "cluster-stats-collector");
        thread.setDaemon(true);
        return thread;
    });
    private final Supplier<Long> nanoClock;
    private final AtomicLong timeOfFirstDispatch = new AtomicLong(0L);
    private final AtomicLong requests = new AtomicLong();
    private final Throttler throttler;
    private final Map<Integer, ResponseSpecificStats> statsByCode = new HashMap<Integer, ResponseSpecificStats>(10);
    private long results = 0L;
    private long exceptions = 0L;
    private long bytesSent = 0L;
    private long operations = 0L;
    private long operationTotalLatencyMillis = 0L;
    private long operationMinLatencyMillis = Long.MAX_VALUE;
    private long operationMaxLatencyMillis = 0L;

    BenchmarkingCluster(Cluster delegate, Throttler throttler, Supplier<Long> nanoClock) {
        this.delegate = Objects.requireNonNull(delegate);
        this.throttler = throttler;
        this.nanoClock = Objects.requireNonNull(nanoClock);
    }

    @Override
    public void dispatch(HttpRequest request, CompletableFuture<HttpResponse> vessel) {
        this.dispatchInternal(request, vessel);
    }

    CompletableFuture<HttpResponse> dispatchInternal(HttpRequest request, CompletableFuture<HttpResponse> vessel) {
        this.requests.incrementAndGet();
        long startNanos = this.nanoClock.get();
        this.timeOfFirstDispatch.compareAndSet(0L, startNanos);
        request.onDispatch(startNanos);
        this.delegate.dispatch(request, vessel);
        return vessel.whenCompleteAsync((response, thrown) -> {
            ++this.results;
            if (thrown == null) {
                ResponseSpecificStats stats = this.statsByCode.computeIfAbsent(response.code(), __ -> new ResponseSpecificStats());
                Long completeNanos = this.nanoClock.get();
                long latency = (completeNanos - startNanos) / 1000000L;
                ++stats.count;
                stats.totalLatencyMillis += latency;
                stats.minLatencyMillis = Math.min(stats.minLatencyMillis, latency);
                stats.maxLatencyMillis = Math.max(stats.maxLatencyMillis, latency);
                stats.bytesReceived = stats.bytesReceived + (response.body() == null ? 0L : (long)response.body().length);
                this.bytesSent += request.body() == null ? 0L : (long)request.body().length;
                Long operationLatency = request.firstDispatchNanos().map(ns -> (completeNanos - ns) / 1000000L).orElse(-1L);
                if (operationLatency >= 0L && HttpRequestStrategy.isSuccess(response.code())) {
                    ++this.operations;
                    this.operationTotalLatencyMillis += operationLatency.longValue();
                    this.operationMinLatencyMillis = Math.min(this.operationMinLatencyMillis, operationLatency);
                    this.operationMaxLatencyMillis = Math.max(this.operationMaxLatencyMillis, operationLatency);
                }
            } else {
                ++this.exceptions;
            }
        }, (Executor)this.executor);
    }

    @Override
    public OperationStats stats() {
        try {
            try {
                return this.executor.submit(this::getStats).get();
            }
            catch (RejectedExecutionException ignored) {
                this.executor.awaitTermination(10L, TimeUnit.SECONDS);
                return this.getStats();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void resetStats() {
        try {
            this.executor.submit(() -> {
                this.requests.set(0L);
                this.results = 0L;
                this.exceptions = 0L;
                this.bytesSent = 0L;
                this.statsByCode.clear();
                this.operations = 0L;
                this.operationTotalLatencyMillis = 0L;
                this.operationMinLatencyMillis = Long.MAX_VALUE;
                this.operationMaxLatencyMillis = 0L;
                return null;
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private OperationStats getStats() {
        long requests = this.requests.get();
        double duration = (double)(System.nanoTime() - this.timeOfFirstDispatch.get()) * 1.0E-9;
        HashMap statsByCode = new HashMap();
        this.statsByCode.forEach((code, stats) -> statsByCode.put(code, new OperationStats.Response(stats.count, stats.totalLatencyMillis, stats.count == 0L ? -1L : stats.totalLatencyMillis / stats.count, stats.count == 0L ? -1L : stats.minLatencyMillis, stats.count == 0L ? -1L : stats.maxLatencyMillis, stats.bytesReceived, (double)stats.count / duration)));
        return new OperationStats(duration, requests, this.exceptions, requests - this.results, this.throttler.targetInflight(), this.bytesSent, this.operations == 0L ? -1L : this.operationTotalLatencyMillis / this.operations, this.operations == 0L ? -1L : this.operationMinLatencyMillis, this.operations == 0L ? -1L : this.operationMaxLatencyMillis, statsByCode);
    }

    @Override
    public void close() {
        this.delegate.close();
        Instant doom = Instant.now().plusSeconds(10L);
        while (Instant.now().isBefore(doom) && this.getStats().inflight() != 0L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.executor.shutdown();
    }

    private static class ResponseSpecificStats {
        long count = 0L;
        long totalLatencyMillis = 0L;
        long minLatencyMillis = Long.MAX_VALUE;
        long maxLatencyMillis = 0L;
        long bytesReceived = 0L;

        private ResponseSpecificStats() {
        }
    }
}

