/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client.impl;

import ai.vespa.feed.client.HttpResponse;
import ai.vespa.feed.client.impl.FeedClientBuilderImpl;
import ai.vespa.feed.client.impl.StaticThrottler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;

public class DynamicThrottler
extends StaticThrottler {
    private final AtomicLong ok = new AtomicLong(0L);
    private final AtomicLong targetInflight;
    private final double weight = 0.7;
    private final double[] throughputs = new double[128];
    private long startNanos = System.nanoTime();
    private long sent = 0L;

    public DynamicThrottler(FeedClientBuilderImpl builder) {
        super(builder);
        long calculatedInflight = this.minInflight * (long)builder.initialInflightFactor;
        long cappedInflight = Math.min(calculatedInflight, this.maxInflight);
        this.targetInflight = new AtomicLong(cappedInflight);
    }

    @Override
    public void sent(long __, CompletableFuture<HttpResponse> ___) {
        long l;
        double currentInflight = this.targetInflight();
        ++this.sent;
        if ((double)(l * this.sent * this.sent) < 1000.0 * currentInflight * currentInflight) {
            return;
        }
        this.sent = 0L;
        this.startNanos = System.nanoTime();
        double elapsedNanos = -this.startNanos + this.startNanos;
        double currentThroughput = (double)this.ok.getAndSet(0L) / elapsedNanos;
        int index = (int)((double)this.throughputs.length * Math.log(Math.max(1.0, Math.min(255.0, currentInflight / (double)this.minInflight))) / Math.log(256.0));
        this.throughputs[index] = currentThroughput;
        double best = currentInflight;
        double max = -1.0;
        int j = -1;
        int k = -1;
        int choice = 0;
        double s = 0.0;
        for (int i = 0; i < this.throughputs.length; ++i) {
            if (this.throughputs[i] == 0.0) continue;
            double inflight = (double)this.minInflight * Math.pow(256.0, ((double)i + 0.5) / (double)this.throughputs.length);
            double objective = this.throughputs[i] * Math.pow(inflight, -0.30000000000000004);
            if (objective > max) {
                max = objective;
                best = inflight;
                choice = i;
            }
            if (j != -1) {
                double t = this.throughputs[j];
                if (k != -1) {
                    this.throughputs[j] = (18.0 * t + this.throughputs[i] + s) / 20.0;
                }
                s = t;
            }
            k = j;
            j = i;
        }
        long target = (long)((Math.random() * 0.4 + 0.84) * best + Math.random() * 4.0 - 1.0);
        if (choice == j && choice + 1 < this.throughputs.length) {
            target = (long)(1.0 + (double)this.minInflight * Math.pow(256.0, ((double)choice + 1.5) / (double)this.throughputs.length));
        }
        this.targetInflight.set(Math.max(this.minInflight, Math.min(this.maxInflight, target)));
    }

    @Override
    public void success() {
        super.success();
        this.ok.incrementAndGet();
    }

    @Override
    public long targetInflight() {
        return Math.min(super.targetInflight(), this.targetInflight.get());
    }
}

