/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client.impl;

import ai.vespa.feed.client.HttpResponse;
import ai.vespa.feed.client.impl.FeedClientBuilderImpl;
import ai.vespa.feed.client.impl.Throttler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;

public class StaticThrottler
implements Throttler {
    protected final long maxInflight;
    protected final long minInflight;
    private final AtomicLong targetX10;

    public StaticThrottler(FeedClientBuilderImpl builder) {
        this.minInflight = 2L * (long)builder.connectionsPerEndpoint * (long)builder.endpoints.size();
        this.maxInflight = 256L * this.minInflight;
        this.targetX10 = new AtomicLong(10L * this.maxInflight);
    }

    @Override
    public void sent(long inflight, CompletableFuture<HttpResponse> vessel) {
    }

    @Override
    public void success() {
        this.targetX10.incrementAndGet();
    }

    @Override
    public void throttled(long inflight) {
        this.targetX10.set(Math.max(inflight * 5L, this.minInflight * 10L));
    }

    @Override
    public long targetInflight() {
        return Math.min(this.maxInflight, this.targetX10.get() / 10L);
    }
}

