/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client;

import com.yahoo.vespa.http.client.FeedClient;
import com.yahoo.vespa.http.client.config.SessionParams;
import com.yahoo.vespa.http.client.core.api.FeedClientImpl;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class FeedClientFactory {
    public static FeedClient create(SessionParams sessionParams, FeedClient.ResultCallback resultCallback) {
        return new FeedClientImpl(sessionParams, resultCallback, FeedClientFactory.createTimeoutExecutor());
    }

    static ScheduledThreadPoolExecutor createTimeoutExecutor() {
        ScheduledThreadPoolExecutor timeoutExecutor = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory("timeout-"));
        timeoutExecutor.setRemoveOnCancelPolicy(true);
        timeoutExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        timeoutExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return timeoutExecutor;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
        private final String prefix;

        private DaemonThreadFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = this.defaultThreadFactory.newThread(runnable);
            t.setDaemon(true);
            t.setName(this.prefix + t.getName());
            return t;
        }
    }
}

