/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client;

import com.yahoo.vespa.http.client.FeedClient;
import com.yahoo.vespa.http.client.Result;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleLoggerResultCallback
implements FeedClient.ResultCallback {
    private final Object monitor = new Object();
    private int resultCounter = 0;
    private int failureCounter = 0;
    private final AtomicInteger sentDocumentCounter;
    private final int printStatsForEveryXDocument;
    private Instant startSampleInstant = Instant.now();
    private int startSampleResultCount = 0;

    protected void println(String output) {
        System.err.println(output);
    }

    public SimpleLoggerResultCallback(AtomicInteger sentDocumentCounter, int printStatsForEveryXDocument) {
        this.sentDocumentCounter = sentDocumentCounter;
        this.printStatsForEveryXDocument = printStatsForEveryXDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printProgress() {
        Object object = this.monitor;
        synchronized (object) {
            DocumentRate docRate = this.newSamplingPeriod(Instant.now());
            this.println(new Date() + " Result received: " + this.resultCounter + " (" + this.failureCounter + " failed so far, " + this.sentDocumentCounter.get() + " sent, success rate " + docRate + ").");
        }
    }

    protected DocumentRate newSamplingPeriod(Instant now) {
        double docsDelta = this.resultCounter - this.failureCounter - this.startSampleResultCount;
        Duration duration = Duration.between(this.startSampleInstant, now);
        this.startSampleInstant = now;
        this.startSampleResultCount = this.resultCounter - this.failureCounter;
        long durationMilliSecs = duration.toMillis() + 1L;
        return new DocumentRate(1000.0 * docsDelta / (double)durationMilliSecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getResultCount() {
        Object object = this.monitor;
        synchronized (object) {
            return this.resultCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getFailedDocumentCount() {
        Object object = this.monitor;
        synchronized (object) {
            return this.failureCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompletion(String docId, Result documentResult) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.printStatsForEveryXDocument > 0 && this.resultCounter % this.printStatsForEveryXDocument == 0) {
                this.printProgress();
            }
            ++this.resultCounter;
            if (!documentResult.isSuccess()) {
                ++this.failureCounter;
                this.println("Failure: " + documentResult + (documentResult.getDetails().isEmpty() ? "" : ":"));
                for (Result.Detail detail : documentResult.getDetails()) {
                    this.println("    " + detail);
                }
            }
        }
    }

    static class DocumentRate {
        public final double rate;

        DocumentRate(double rate) {
            this.rate = rate;
        }

        public String toString() {
            return String.format(Locale.US, "%.2f docs/sec", this.rate);
        }
    }
}

