/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.config;

import com.yahoo.vespa.http.client.config.Cluster;
import com.yahoo.vespa.http.client.config.ConnectionParams;
import com.yahoo.vespa.http.client.config.Endpoint;
import com.yahoo.vespa.http.client.config.FeedParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class SessionParams {
    private final List<Cluster> clusters;
    private final FeedParams feedParams;
    private final ConnectionParams connectionParams;
    private final int clientQueueSize;
    private final ErrorReporter errorReport;
    private int throttlerMinSize;

    private SessionParams(Collection<Cluster> clusters, FeedParams feedParams, ConnectionParams connectionParams, int clientQueueSize, ErrorReporter errorReporter, int throttlerMinSize) {
        this.clusters = Collections.unmodifiableList(new ArrayList<Cluster>(clusters));
        this.feedParams = feedParams;
        this.connectionParams = connectionParams;
        this.clientQueueSize = clientQueueSize;
        this.errorReport = errorReporter;
        this.throttlerMinSize = throttlerMinSize;
    }

    public List<Cluster> getClusters() {
        return this.clusters;
    }

    public FeedParams getFeedParams() {
        return this.feedParams;
    }

    public ConnectionParams getConnectionParams() {
        return this.connectionParams;
    }

    public int getClientQueueSize() {
        return this.clientQueueSize;
    }

    public int getThrottlerMinSize() {
        return this.throttlerMinSize;
    }

    public ErrorReporter getErrorReport() {
        return this.errorReport;
    }

    public Builder toBuilder() {
        Builder b = new Builder();
        this.clusters.forEach(c -> b.addCluster((Cluster)c));
        b.setFeedParams(this.feedParams);
        b.setConnectionParams(this.connectionParams);
        b.setClientQueueSize(this.clientQueueSize);
        b.setErrorReporter(this.errorReport);
        b.setThrottlerMinSize(this.throttlerMinSize);
        return b;
    }

    public static final class Builder {
        private final List<Cluster> clusters = new LinkedList<Cluster>();
        private FeedParams feedParams = new FeedParams.Builder().build();
        private ConnectionParams connectionParams = new ConnectionParams.Builder().build();
        private int clientQueueSize = 10000;
        private ErrorReporter errorReporter = null;
        private int throttlerMinSize = 0;

        public Builder addCluster(Cluster cluster) {
            this.clusters.add(cluster);
            return this;
        }

        public Builder setFeedParams(FeedParams feedParams) {
            this.feedParams = feedParams;
            return this;
        }

        public Builder setConnectionParams(ConnectionParams connectionParams) {
            this.connectionParams = connectionParams;
            return this;
        }

        public Builder setErrorReporter(ErrorReporter errorReporter) {
            this.errorReporter = errorReporter;
            return this;
        }

        public Builder setClientQueueSize(int clientQueueSize) {
            this.clientQueueSize = clientQueueSize;
            return this;
        }

        public Builder setThrottlerMinSize(int throttlerMinSize) {
            this.throttlerMinSize = throttlerMinSize;
            return this;
        }

        public SessionParams build() {
            return new SessionParams(this.clusters, this.feedParams, this.connectionParams, this.clientQueueSize, this.errorReporter, this.throttlerMinSize);
        }

        public FeedParams getFeedParams() {
            return this.feedParams;
        }

        public ConnectionParams getConnectionParams() {
            return this.connectionParams;
        }

        public int getClientQueueSize() {
            return this.clientQueueSize;
        }

        public int getThrottlerMinSize() {
            return this.throttlerMinSize;
        }
    }

    public static interface ErrorReporter {
        public void onSessionError(Endpoint var1, String var2, String var3);
    }
}

