/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;

public final class Document {
    private final String documentId;
    private final ByteBuffer data;
    private final long createTimeMillis = System.currentTimeMillis();
    private String operationId = null;
    private final Object context;
    private long queueInsertTimestampMillis;

    public Document(String documentId, byte[] data, Object context) {
        this.documentId = documentId;
        this.context = context;
        this.data = ByteBuffer.wrap(data);
    }

    public Document(String documentId, String operationId, CharSequence data, Object context) {
        this.documentId = documentId;
        this.operationId = operationId;
        this.context = context;
        try {
            this.data = StandardCharsets.UTF_8.newEncoder().encode(CharBuffer.wrap(data));
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException("Error encoding document data into UTF8 " + documentId, e);
        }
    }

    public void resetQueueTime() {
        this.queueInsertTimestampMillis = System.currentTimeMillis();
    }

    public long timeInQueueMillis() {
        return System.currentTimeMillis() - this.queueInsertTimestampMillis;
    }

    public CharSequence getDataAsString() {
        return StandardCharsets.UTF_8.decode(this.data.asReadOnlyBuffer());
    }

    public Object getContext() {
        return this.context;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public ByteBuffer getData() {
        return this.data.asReadOnlyBuffer();
    }

    public int size() {
        return this.data.remaining();
    }

    public long createTimeMillis() {
        return this.createTimeMillis;
    }

    public String getOperationId() {
        if (this.operationId == null) {
            this.operationId = new BigInteger(64, ThreadLocalRandom.current()).toString(32);
        }
        return this.operationId;
    }

    public String toString() {
        return "document '" + this.documentId + "'";
    }

    public static class DocumentException
    extends IOException {
        private static final long serialVersionUID = 29832833292L;

        public DocumentException(String message) {
            super(message);
        }
    }
}

