/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core;

import com.google.common.base.Splitter;
import com.yahoo.vespa.http.client.core.Encoder;
import com.yahoo.vespa.http.client.core.ErrorCode;
import java.util.Iterator;

public final class OperationStatus {
    public static final String IS_CONDITION_NOT_MET = "IS-CONDITION-NOT-MET";
    public final String message;
    public final String operationId;
    public final ErrorCode errorCode;
    public final String traceMessage;
    public final boolean isConditionNotMet;
    private static final char EOL = '\n';
    private static final char SEPARATOR = ' ';
    private static final Splitter spaceSep = Splitter.on((char)' ');

    public OperationStatus(String message, String operationId, ErrorCode errorCode, boolean isConditionNotMet, String traceMessage) {
        this.isConditionNotMet = isConditionNotMet;
        this.message = message;
        this.operationId = operationId;
        this.errorCode = errorCode;
        this.traceMessage = traceMessage;
    }

    public static OperationStatus parse(String singleLine) {
        Iterator input = spaceSep.split((CharSequence)singleLine.trim()).iterator();
        String traceMessage = "";
        String operationId = Encoder.decode((String)input.next(), new StringBuilder()).toString();
        ErrorCode errorCode = ErrorCode.valueOf(Encoder.decode((String)input.next(), new StringBuilder()).toString());
        String message = Encoder.decode((String)input.next(), new StringBuilder()).toString();
        boolean isConditionNotMet = false;
        if (message.startsWith(IS_CONDITION_NOT_MET)) {
            message = message.replaceFirst(IS_CONDITION_NOT_MET, "");
            isConditionNotMet = true;
        }
        if (input.hasNext()) {
            traceMessage = Encoder.decode((String)input.next(), new StringBuilder()).toString();
        }
        return new OperationStatus(message, operationId, errorCode, isConditionNotMet, traceMessage);
    }

    public String render() {
        StringBuilder s = new StringBuilder();
        Encoder.encode(this.operationId, s).append(' ');
        Encoder.encode(this.errorCode.toString(), s).append(' ');
        Encoder.encode(this.isConditionNotMet ? IS_CONDITION_NOT_MET + this.message : this.message, s).append(' ');
        Encoder.encode(this.traceMessage, s).append('\n');
        return s.toString();
    }
}

