/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core;

import com.yahoo.vespa.http.client.FeedClient;
import java.util.concurrent.atomic.AtomicInteger;
import org.xml.sax.Attributes;
import org.xml.sax.ext.DefaultHandler2;

class SAXClientFeeder
extends DefaultHandler2 {
    public static final String CDATA_START = "<![CDATA[";
    public static final String CDATA_STOP = "]]>";
    private final FeedClient feedClient;
    int vespaIndent = 0;
    int documentIndent = 0;
    String documentId = null;
    StringBuilder content = new StringBuilder();
    final AtomicInteger numSent;
    boolean isCData = false;

    public SAXClientFeeder(FeedClient feedClient, AtomicInteger numSent) {
        this.feedClient = feedClient;
        this.numSent = numSent;
    }

    @Override
    public void startCDATA() {
        this.content.append(CDATA_START);
        this.isCData = true;
    }

    @Override
    public void endCDATA() {
        this.content.append(CDATA_STOP);
        this.isCData = false;
    }

    @Override
    public void comment(char[] ch, int start, int length) {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        switch (qName) {
            case "vespafeed": {
                ++this.vespaIndent;
                if (this.vespaIndent == 1 && this.documentIndent == 0) {
                    return;
                }
            }
            case "update": 
            case "remove": 
            case "document": {
                ++this.documentIndent;
                this.documentId = attributes.getValue("documentid");
                this.content = new StringBuilder();
            }
        }
        this.content.append("<" + qName);
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.content.append(" ").append(attributes.getQName(i)).append("=\"");
                String attributesValue = attributes.getValue(i);
                this.characters(attributesValue.toCharArray(), 0, attributesValue.length());
                this.content.append("\"");
            }
        }
        this.content.append(">");
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.content.append("</").append(qName).append(">");
        switch (qName) {
            case "vespafeed": {
                --this.vespaIndent;
                return;
            }
            case "update": 
            case "remove": 
            case "document": {
                --this.documentIndent;
                if (this.documentIndent != 0) break;
                if (this.documentId == null || this.documentId.isEmpty()) {
                    throw new IllegalArgumentException("no docid");
                }
                this.feedClient.stream(this.documentId, this.content);
                this.numSent.incrementAndGet();
            }
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) {
        if (this.isCData) {
            this.content.append(buf, offset, len);
            return;
        }
        block7: for (int x = offset; x < len + offset; ++x) {
            switch (buf[x]) {
                case '&': {
                    this.content.append("&amp;");
                    continue block7;
                }
                case '<': {
                    this.content.append("&lt;");
                    continue block7;
                }
                case '>': {
                    this.content.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    this.content.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    this.content.append("&apos;");
                    continue block7;
                }
                default: {
                    this.content.append(buf[x]);
                }
            }
        }
    }
}

