/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core;

public class ThrottlePolicy {
    public static final double SMALL_DIFFERENCE_IN_SUCCESSES_RATIO = 0.15;
    private static final double MINIMUM_DIFFERENCE = 0.05;

    public int calcNewMaxInFlight(double maxPerformanceChange, int numOk, int previousNumOk, int previousMaxInFlight, int maxInFlightNow, boolean messagesQueued) {
        boolean previousRunHadLessInFlight;
        double difference = ThrottlePolicy.calculateRuleBasedDifference(maxPerformanceChange, numOk, previousNumOk, previousMaxInFlight, maxInFlightNow);
        boolean previousRunWasBetter = numOk < previousNumOk;
        int delta = previousRunWasBetter == (previousRunHadLessInFlight = previousMaxInFlight < maxInFlightNow) ? (int)(-1.1 * difference * (double)maxInFlightNow) : (int)(difference * (double)maxInFlightNow);
        if (Math.abs(delta) < 2) {
            delta = -3;
        }
        if (!messagesQueued && delta > 0) {
            delta = -2;
        }
        return maxInFlightNow + delta;
    }

    private static double calculateRuleBasedDifference(double maxPerformanceChange, double numOk, double previousNumOk, double previousMaxInFlight, double maxInFlightNow) {
        double difference = Math.min(maxPerformanceChange, Math.abs((numOk - previousNumOk) / ThrottlePolicy.safeDenominator(previousNumOk)));
        if (Math.abs(previousMaxInFlight - maxInFlightNow) / ThrottlePolicy.safeDenominator(Math.min(previousMaxInFlight, maxInFlightNow)) < 0.15) {
            difference = Math.min(difference, 0.2);
        }
        return Math.max(difference, 0.05);
    }

    private static double safeDenominator(double x) {
        return x == 0.0 ? 1.0 : x;
    }
}

