/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core;

import com.yahoo.vespa.http.client.FeedClient;
import com.yahoo.vespa.http.client.core.SAXClientFeeder;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class XmlFeedReader {
    private XmlFeedReader() {
    }

    public static void read(InputStream inputStream, FeedClient feedClient, AtomicInteger numSent) throws Exception {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        parserFactory.setValidating(false);
        parserFactory.setNamespaceAware(false);
        SAXParser parser = parserFactory.newSAXParser();
        SAXClientFeeder saxClientFeeder = new SAXClientFeeder(feedClient, numSent);
        InputSource inputSource = new InputSource();
        inputSource.setEncoding(StandardCharsets.UTF_8.displayName());
        inputSource.setByteStream(inputStream);
        parser.setProperty("http://xml.org/sax/properties/lexical-handler", saxClientFeeder);
        parser.parse(inputSource, (DefaultHandler)saxClientFeeder);
    }
}

