/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core.communication;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;

class ByteBufferInputStream
extends InputStream {
    private final Deque<ByteBuffer> currentBuffers = new ArrayDeque<ByteBuffer>();

    ByteBufferInputStream(ByteBuffer[] buffers) {
        for (int i = buffers.length - 1; i > -1; --i) {
            this.currentBuffers.push(buffers[i]);
        }
    }

    @Override
    public int read() throws IOException {
        this.pop();
        if (this.currentBuffers.isEmpty()) {
            return -1;
        }
        return this.currentBuffers.peek().get();
    }

    private void pop() {
        if (this.currentBuffers.isEmpty()) {
            return;
        }
        while (!this.currentBuffers.isEmpty() && !this.currentBuffers.peek().hasRemaining()) {
            this.currentBuffers.pop();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.pop();
        if (this.currentBuffers.isEmpty()) {
            return -1;
        }
        int toRead = Math.min(len, this.currentBuffers.peek().remaining());
        this.currentBuffers.peek().get(b, off, toRead);
        return toRead;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("skip() not supported.");
    }

    @Override
    public int available() throws IOException {
        if (this.currentBuffers.isEmpty()) {
            return 0;
        }
        int size = 0;
        for (ByteBuffer b : this.currentBuffers) {
            size += b.remaining();
        }
        return size;
    }
}

