/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core.communication;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.vespa.http.client.config.Cluster;
import com.yahoo.vespa.http.client.config.ConnectionParams;
import com.yahoo.vespa.http.client.config.Endpoint;
import com.yahoo.vespa.http.client.config.FeedParams;
import com.yahoo.vespa.http.client.core.Document;
import com.yahoo.vespa.http.client.core.Exceptions;
import com.yahoo.vespa.http.client.core.communication.ApacheGatewayConnection;
import com.yahoo.vespa.http.client.core.communication.DocumentQueue;
import com.yahoo.vespa.http.client.core.communication.DryRunGatewayConnection;
import com.yahoo.vespa.http.client.core.communication.EndpointIOException;
import com.yahoo.vespa.http.client.core.communication.EndpointResultQueue;
import com.yahoo.vespa.http.client.core.communication.GatewayConnection;
import com.yahoo.vespa.http.client.core.communication.IOThread;
import com.yahoo.vespa.http.client.core.operationProcessor.OperationProcessor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ClusterConnection
implements AutoCloseable {
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final List<IOThread> ioThreads = new ArrayList<IOThread>();
    private final int clusterId;
    private final ThreadGroup ioThreadGroup;
    private final DocumentQueue documentQueue;
    private final Endpoint singleEndpoint;

    public ClusterConnection(OperationProcessor operationProcessor, FeedParams feedParams, ConnectionParams connectionParams, Cluster cluster, int clusterId, int clientQueueSizePerCluster, ScheduledThreadPoolExecutor timeoutExecutor) {
        if (cluster.getEndpoints().isEmpty()) {
            throw new IllegalArgumentException("At least a single endpoint is required in " + cluster);
        }
        this.clusterId = clusterId;
        int totalNumberOfEndpointsInThisCluster = cluster.getEndpoints().size() * connectionParams.getNumPersistentConnectionsPerEndpoint();
        if (totalNumberOfEndpointsInThisCluster == 0) {
            throw new IllegalArgumentException("At least 1 persistent connection per endpoint is required in " + cluster);
        }
        int maxInFlightPerSession = Math.max(1, feedParams.getMaxInFlightRequests() / totalNumberOfEndpointsInThisCluster);
        this.documentQueue = new DocumentQueue(clientQueueSizePerCluster);
        this.ioThreadGroup = operationProcessor.getIoThreadGroup();
        this.singleEndpoint = cluster.getEndpoints().size() == 1 ? cluster.getEndpoints().get(0) : null;
        for (Endpoint endpoint : cluster.getEndpoints()) {
            EndpointResultQueue endpointResultQueue = new EndpointResultQueue(operationProcessor, endpoint, clusterId, timeoutExecutor, feedParams.getServerTimeout(TimeUnit.MILLISECONDS) + feedParams.getClientTimeout(TimeUnit.MILLISECONDS));
            for (int i = 0; i < connectionParams.getNumPersistentConnectionsPerEndpoint(); ++i) {
                GatewayConnection gatewayConnection = connectionParams.isDryRun() ? new DryRunGatewayConnection(endpoint) : new ApacheGatewayConnection(endpoint, feedParams, cluster.getRoute(), connectionParams, new ApacheGatewayConnection.HttpClientFactory(connectionParams, endpoint.isUseSsl()), operationProcessor.getClientId());
                IOThread ioThread = new IOThread(operationProcessor.getIoThreadGroup(), endpointResultQueue, gatewayConnection, clusterId, feedParams.getMaxChunkSizeBytes(), maxInFlightPerSession, feedParams.getLocalQueueTimeOut(), this.documentQueue, feedParams.getMaxSleepTimeMs());
                this.ioThreads.add(ioThread);
            }
        }
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public void post(Document document) throws EndpointIOException {
        try {
            this.documentQueue.put(document, Thread.currentThread().getThreadGroup() == this.ioThreadGroup);
        }
        catch (Throwable t) {
            throw new EndpointIOException(this.singleEndpoint, "While sending", t);
        }
    }

    @Override
    public void close() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (IOThread ioThread : this.ioThreads) {
            try {
                ioThread.close();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (exceptions.isEmpty()) {
            return;
        }
        if (exceptions.size() == 1) {
            if (exceptions.get(0) instanceof RuntimeException) {
                throw (RuntimeException)exceptions.get(0);
            }
            throw new RuntimeException((Throwable)exceptions.get(0));
        }
        StringBuilder b = new StringBuilder();
        b.append("Exception thrown while closing one or more endpoints: ");
        for (int i = 0; i < exceptions.size(); ++i) {
            Exception e = (Exception)exceptions.get(i);
            b.append(Exceptions.toMessageString(e));
            if (i == exceptions.size() - 1) continue;
            b.append(", ");
        }
        throw new RuntimeException(b.toString(), (Throwable)exceptions.get(0));
    }

    public String getStatsAsJSon() throws IOException {
        StringWriter stringWriter = new StringWriter();
        JsonGenerator jsonGenerator = jsonFactory.createGenerator((Writer)stringWriter);
        jsonGenerator.writeStartObject();
        jsonGenerator.writeArrayFieldStart("session");
        for (IOThread ioThread : this.ioThreads) {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectFieldStart("endpoint");
            jsonGenerator.writeStringField("host", ioThread.getEndpoint().getHostname());
            jsonGenerator.writeNumberField("port", ioThread.getEndpoint().getPort());
            jsonGenerator.writeEndObject();
            jsonGenerator.writeFieldName("stats");
            IOThread.ConnectionStats connectionStats = ioThread.getConnectionStats();
            objectMapper.writeValue(jsonGenerator, (Object)connectionStats);
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
        jsonGenerator.close();
        return stringWriter.toString();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof ClusterConnection && this.clusterId == ((ClusterConnection)o).clusterId;
    }

    public int hashCode() {
        return this.clusterId;
    }
}

