/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core.communication;

import com.yahoo.vespa.http.client.FeedEndpointException;
import com.yahoo.vespa.http.client.config.Endpoint;
import com.yahoo.vespa.http.client.core.EndpointResult;
import com.yahoo.vespa.http.client.core.operationProcessor.EndPointResultFactory;
import com.yahoo.vespa.http.client.core.operationProcessor.OperationProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

class EndpointResultQueue {
    private static Logger log = Logger.getLogger(EndpointResultQueue.class.getName());
    private final OperationProcessor operationProcessor;
    private final Map<String, TimerFuture> futureByOperation = new HashMap<String, TimerFuture>();
    private final Endpoint endpoint;
    private final int clusterId;
    private final ScheduledThreadPoolExecutor timer;
    private final long totalTimeoutMs;

    EndpointResultQueue(OperationProcessor operationProcessor, Endpoint endpoint, int clusterId, ScheduledThreadPoolExecutor timer, long totalTimeoutMs) {
        this.operationProcessor = operationProcessor;
        this.endpoint = endpoint;
        this.clusterId = clusterId;
        this.timer = timer;
        this.totalTimeoutMs = totalTimeoutMs;
    }

    public synchronized void operationSent(String operationId) {
        DocumentTimerTask task = new DocumentTimerTask(operationId);
        ScheduledFuture<?> future = this.timer.schedule(task, this.totalTimeoutMs, TimeUnit.MILLISECONDS);
        this.futureByOperation.put(operationId, new TimerFuture(future));
    }

    public synchronized void failOperation(EndpointResult result, int clusterId) {
        this.resultReceived(result, clusterId, false);
    }

    public synchronized void resultReceived(EndpointResult result, int clusterId) {
        this.resultReceived(result, clusterId, true);
    }

    void onEndpointError(FeedEndpointException e) {
        this.operationProcessor.onEndpointError(e);
    }

    private synchronized void resultReceived(EndpointResult result, int clusterId, boolean duplicateGivesWarning) {
        this.operationProcessor.resultReceived(result, clusterId);
        TimerFuture timerFuture = this.futureByOperation.remove(result.getOperationId());
        if (timerFuture == null) {
            if (duplicateGivesWarning) {
                log.warning("Result for ID '" + result.getOperationId() + "' received from '" + this.endpoint + "', but we have no record of a sent operation. Either something is wrong on the server side (bad VIP usage?), or we have somehow received duplicate results, or operation was received _after_ client-side timeout.");
            }
            return;
        }
        timerFuture.getFuture().cancel(false);
    }

    private synchronized void timeout(String operationId) {
        TimerFuture timerFuture = this.futureByOperation.remove(operationId);
        if (timerFuture == null) {
            log.finer("Timeout of operation '" + operationId + "', but operation not found in map. Result was probably received just-in-time from server, while timeout task could not be cancelled.");
            return;
        }
        EndpointResult endpointResult = EndPointResultFactory.createTransientError(this.endpoint, operationId, new RuntimeException("Timed out waiting for reply from server."));
        this.operationProcessor.resultReceived(endpointResult, this.clusterId);
    }

    public synchronized int getPendingSize() {
        return this.futureByOperation.values().size();
    }

    public synchronized void failPending(Exception exception) {
        for (Map.Entry<String, TimerFuture> timerFutureEntry : this.futureByOperation.entrySet()) {
            timerFutureEntry.getValue().getFuture().cancel(false);
            this.failedOperationId(timerFutureEntry.getKey(), exception);
        }
        this.futureByOperation.clear();
    }

    private synchronized void failedOperationId(String operationId, Exception exception) {
        EndpointResult endpointResult = EndPointResultFactory.createError(this.endpoint, operationId, exception);
        this.operationProcessor.resultReceived(endpointResult, this.clusterId);
    }

    private class TimerFuture {
        private final ScheduledFuture<?> future;

        public TimerFuture(ScheduledFuture<?> future) {
            this.future = future;
        }

        private ScheduledFuture<?> getFuture() {
            return this.future;
        }
    }

    private class DocumentTimerTask
    implements Runnable {
        private final String operationId;

        private DocumentTimerTask(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public void run() {
            EndpointResultQueue.this.timeout(this.operationId);
        }
    }
}

