/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core.operationProcessor;

import java.util.concurrent.Semaphore;

public final class ConcurrentDocumentOperationBlocker {
    private static final int INITIAL_SIZE = 0;
    private final ReducableSemaphore semaphore = new ReducableSemaphore();
    private int maxConcurrency = 0;
    private final Object monitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxConcurrency(int maxConcurrency) {
        Object object = this.monitor;
        synchronized (object) {
            int deltaConcurrency = maxConcurrency - this.maxConcurrency;
            if (deltaConcurrency > 0) {
                this.semaphore.release(deltaConcurrency);
            }
            if (deltaConcurrency < 0) {
                this.semaphore.reducePermits(-1 * deltaConcurrency);
            }
            this.maxConcurrency = maxConcurrency;
        }
    }

    void operationDone() {
        this.semaphore.release();
    }

    void startOperation() throws InterruptedException {
        this.semaphore.acquire();
    }

    int availablePermits() {
        return this.semaphore.availablePermits();
    }

    private static final class ReducableSemaphore
    extends Semaphore {
        ReducableSemaphore() {
            super(0, true);
        }

        @Override
        protected void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }
}

