/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core.operationProcessor;

import com.yahoo.vespa.http.client.Result;
import com.yahoo.vespa.http.client.core.Document;
import java.util.HashMap;
import java.util.Map;

class DocumentSendInfo {
    private final Document document;
    private final Map<Integer, Result.Detail> detailByClusterId = new HashMap<Integer, Result.Detail>();
    private Map<Integer, Integer> attemptedRetriesByClusterId = null;
    private final StringBuilder localTrace;

    DocumentSendInfo(Document document, boolean traceThisDoc) {
        this.document = document;
        this.localTrace = traceThisDoc ? new StringBuilder("\n" + document.createTimeMillis() + " Trace starting \n") : null;
    }

    boolean addIfNotAlreadyThere(Result.Detail detail, int clusterId) {
        if (this.detailByClusterId.containsKey(clusterId)) {
            if (this.localTrace != null) {
                this.localTrace.append(System.currentTimeMillis() + " Got duplicate detail, ignoring this: " + detail.toString() + "\n");
            }
            return false;
        }
        if (this.localTrace != null) {
            this.localTrace.append(System.currentTimeMillis() + " Got detail: " + detail.toString() + "\n");
        }
        this.detailByClusterId.put(clusterId, detail);
        return true;
    }

    int detailCount() {
        return this.detailByClusterId.size();
    }

    public Result createResult() {
        return new Result(this.document, this.detailByClusterId.values(), this.localTrace);
    }

    int incRetries(int clusterId, Result.Detail detail) {
        if (this.attemptedRetriesByClusterId == null) {
            this.attemptedRetriesByClusterId = new HashMap<Integer, Integer>();
        }
        int retries = 0;
        if (this.attemptedRetriesByClusterId.containsKey(clusterId)) {
            retries = this.attemptedRetriesByClusterId.get(clusterId);
        }
        this.attemptedRetriesByClusterId.put(clusterId, ++retries);
        if (this.localTrace != null) {
            this.localTrace.append(System.currentTimeMillis() + " Asked about retrying for cluster ID " + clusterId + ", number of retries is " + retries + " Detail:\n" + detail.toString());
        }
        return retries;
    }

    Document getDocument() {
        return this.document;
    }
}

