/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core.operationProcessor;

import com.yahoo.vespa.http.client.core.ThrottlePolicy;
import com.yahoo.vespa.http.client.core.operationProcessor.ConcurrentDocumentOperationBlocker;
import java.util.concurrent.ThreadLocalRandom;

public class IncompleteResultsThrottler {
    private final ConcurrentDocumentOperationBlocker blocker = new ConcurrentDocumentOperationBlocker();
    private final int maxInFlightValue;
    private final int minInFlightValue;
    private final ThrottlePolicy policy;
    public final long phaseSizeMs = 9000 + ThreadLocalRandom.current().nextInt() % 2000;
    private final Clock clock;
    private final Object monitor = new Object();
    private long sampleStartTimeMs = 0L;
    private int previousNumOk = 0;
    private int previousMaxInFlight = 0;
    private int stabilizingPhasesLeft = 0;
    private int adjustCycleCount = 0;
    private int maxInFlightNow;
    private int numOk = 0;
    private int minWindowSizeCounter = 0;
    private int minPermitsAvailable = 0;
    protected static int INITIAL_MAX_IN_FLIGHT_VALUE = 200;
    protected static int SECOND_MAX_IN_FLIGHT_VALUE = 270;
    private StringBuilder debugMessage = new StringBuilder();

    public IncompleteResultsThrottler(int minInFlightValue, int maxInFlightValue, Clock clock, ThrottlePolicy policy) {
        this.maxInFlightValue = maxInFlightValue == 0 ? Integer.MAX_VALUE : maxInFlightValue;
        this.minInFlightValue = minInFlightValue == 0 ? this.maxInFlightValue : minInFlightValue;
        this.policy = policy;
        this.clock = clock;
        if (minInFlightValue != maxInFlightValue) {
            this.sampleStartTimeMs = clock.getTimeMillis();
        }
        this.setNewSemaphoreSize(INITIAL_MAX_IN_FLIGHT_VALUE);
    }

    public int availableCapacity() {
        return this.blocker.availablePermits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operationStart() {
        try {
            this.blocker.startOperation();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.maxInFlightValue != this.minInFlightValue) {
            Object object = this.monitor;
            synchronized (object) {
                this.adjustThrottling();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDebugMessage() {
        Object object = this.monitor;
        synchronized (object) {
            return this.debugMessage.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultReady(boolean success) {
        this.blocker.operationDone();
        if (!success) {
            return;
        }
        Object object = this.monitor;
        synchronized (object) {
            ++this.numOk;
            this.minPermitsAvailable = Math.min(this.minPermitsAvailable, this.blocker.availablePermits());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int waitingThreads() {
        Object object = this.monitor;
        synchronized (object) {
            return this.maxInFlightNow - this.blocker.availablePermits();
        }
    }

    private double getCeilingDifferencePerformance(int adjustCycle) {
        if (adjustCycle > 10) {
            return 0.7;
        }
        return 1.2;
    }

    private void adjustCycle() {
        ++this.adjustCycleCount;
        this.stabilizingPhasesLeft = this.adjustCycleCount < 5 ? 1 : 2 + ThreadLocalRandom.current().nextInt() % 2;
        double maxPerformanceChange = this.getCeilingDifferencePerformance(this.adjustCycleCount);
        boolean messagesQueued = this.minPermitsAvailable < 2;
        int newMaxInFlight = this.policy.calcNewMaxInFlight(maxPerformanceChange, this.numOk, this.previousNumOk, this.previousMaxInFlight, this.maxInFlightNow, messagesQueued);
        this.debugMessage = new StringBuilder();
        this.debugMessage.append("previousMaxInFlight: " + this.previousMaxInFlight + " maxInFlightNow: " + this.maxInFlightNow + " numOk: " + this.numOk + "  previousOk: " + this.previousNumOk + " new size is: " + newMaxInFlight);
        this.previousMaxInFlight = this.maxInFlightNow;
        this.previousNumOk = this.numOk;
        this.setNewSemaphoreSize(this.adjustCycleCount == 1 ? SECOND_MAX_IN_FLIGHT_VALUE : newMaxInFlight);
    }

    private void adjustThrottling() {
        if (this.clock.getTimeMillis() < this.sampleStartTimeMs + this.phaseSizeMs) {
            return;
        }
        this.sampleStartTimeMs += this.phaseSizeMs;
        if (this.stabilizingPhasesLeft-- == 0) {
            this.adjustCycle();
        }
        this.numOk = 0;
        this.minPermitsAvailable = this.maxInFlightNow;
    }

    private int tryBoostingSizeIfMinValueOverSeveralCycles(int size) {
        this.minWindowSizeCounter = size <= this.minInFlightValue ? ++this.minWindowSizeCounter : 0;
        if (this.minWindowSizeCounter == 4) {
            this.debugMessage.append(" (inc max in flight to get more data)");
            this.minWindowSizeCounter = 0;
            return size + 10;
        }
        return size;
    }

    private void setNewSemaphoreSize(int size) {
        this.maxInFlightNow = Math.max(this.minInFlightValue, Math.min(this.tryBoostingSizeIfMinValueOverSeveralCycles(size), this.maxInFlightValue));
        this.blocker.setMaxConcurrency(this.maxInFlightNow);
    }

    public static interface Clock {
        public long getTimeMillis();
    }
}

