/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core.operationProcessor;

import com.google.common.collect.ArrayListMultimap;
import com.yahoo.vespa.http.client.FeedClient;
import com.yahoo.vespa.http.client.FeedEndpointException;
import com.yahoo.vespa.http.client.Result;
import com.yahoo.vespa.http.client.config.Cluster;
import com.yahoo.vespa.http.client.config.SessionParams;
import com.yahoo.vespa.http.client.core.Document;
import com.yahoo.vespa.http.client.core.EndpointResult;
import com.yahoo.vespa.http.client.core.Exceptions;
import com.yahoo.vespa.http.client.core.communication.ClusterConnection;
import com.yahoo.vespa.http.client.core.communication.EndpointIOException;
import com.yahoo.vespa.http.client.core.operationProcessor.DocumentSendInfo;
import com.yahoo.vespa.http.client.core.operationProcessor.EndPointResultFactory;
import com.yahoo.vespa.http.client.core.operationProcessor.IncompleteResultsThrottler;
import com.yahoo.vespa.http.client.core.operationProcessor.OperationStats;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OperationProcessor {
    private static final Logger log = Logger.getLogger(OperationProcessor.class.getName());
    private final Map<String, DocumentSendInfo> docSendInfoByOperationId = new LinkedHashMap<String, DocumentSendInfo>();
    private final ArrayListMultimap<String, Document> blockedDocumentsByDocumentId = ArrayListMultimap.create();
    private final Set<String> inflightDocumentIds = new HashSet<String>();
    private final int numDestinations;
    private final FeedClient.ResultCallback resultCallback;
    private final Object monitor = new Object();
    private final IncompleteResultsThrottler incompleteResultsThrottler;
    private final List<ClusterConnection> clusters = new ArrayList<ClusterConnection>();
    private final ScheduledThreadPoolExecutor timeoutExecutor;
    private final OperationStats operationStats;
    private final int maxRetries;
    private final long minTimeBetweenRetriesMs;
    private final Random random = new SecureRandom();
    private final int traceEveryXOperation;
    private int traceCounter = 0;
    private final boolean traceToStderr;
    private final ThreadGroup ioThreadGroup;
    private final String clientId = new BigInteger(130, this.random).toString(32);

    public OperationProcessor(IncompleteResultsThrottler incompleteResultsThrottler, FeedClient.ResultCallback resultCallback, SessionParams sessionParams, ScheduledThreadPoolExecutor timeoutExecutor) {
        this.numDestinations = sessionParams.getClusters().size();
        this.resultCallback = resultCallback;
        this.incompleteResultsThrottler = incompleteResultsThrottler;
        this.timeoutExecutor = timeoutExecutor;
        this.ioThreadGroup = new ThreadGroup("operationprocessor");
        if (sessionParams.getClusters().isEmpty()) {
            throw new IllegalArgumentException("Cannot feed to 0 clusters.");
        }
        for (Cluster cluster : sessionParams.getClusters()) {
            if (!cluster.getEndpoints().isEmpty()) continue;
            throw new IllegalArgumentException("Cannot feed to empty cluster.");
        }
        for (int i = 0; i < sessionParams.getClusters().size(); ++i) {
            Cluster cluster;
            cluster = sessionParams.getClusters().get(i);
            this.clusters.add(new ClusterConnection(this, sessionParams.getFeedParams(), sessionParams.getConnectionParams(), cluster, i, sessionParams.getClientQueueSize() / sessionParams.getClusters().size(), timeoutExecutor));
        }
        this.operationStats = new OperationStats(sessionParams, this.clusters, incompleteResultsThrottler);
        this.maxRetries = sessionParams.getConnectionParams().getMaxRetries();
        this.minTimeBetweenRetriesMs = sessionParams.getConnectionParams().getMinTimeBetweenRetriesMs();
        this.traceEveryXOperation = sessionParams.getConnectionParams().getTraceEveryXOperation();
        this.traceToStderr = sessionParams.getConnectionParams().getPrintTraceToStdErr();
    }

    public ThreadGroup getIoThreadGroup() {
        return this.ioThreadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIncompleteResultQueueSize() {
        Object object = this.monitor;
        synchronized (object) {
            return this.docSendInfoByOperationId.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> oldestIncompleteResultId() {
        Object object = this.monitor;
        synchronized (object) {
            return this.docSendInfoByOperationId.isEmpty() ? Optional.empty() : Optional.of(this.docSendInfoByOperationId.keySet().iterator().next());
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    private boolean retriedThis(EndpointResult endpointResult, DocumentSendInfo documentSendInfo, int clusterId) {
        boolean retryThisOperation;
        String exceptionMessage;
        Result.Detail detail = endpointResult.getDetail();
        if (detail.getResultType() == Result.ResultType.OPERATION_EXECUTED) {
            return false;
        }
        int retries = documentSendInfo.incRetries(clusterId, detail);
        if (retries > this.maxRetries) {
            return false;
        }
        String string = exceptionMessage = detail.getException() == null ? "" : detail.getException().getMessage();
        if (exceptionMessage == null) {
            exceptionMessage = "";
        }
        boolean bl = retryThisOperation = detail.getResultType() == Result.ResultType.TRANSITIVE_ERROR || exceptionMessage.contains("SEND_QUEUE_CLOSED") || exceptionMessage.contains("ILLEGAL_ROUTE") || exceptionMessage.contains("NO_SERVICES_FOR_ROUTE") || exceptionMessage.contains("NETWORK_ERROR") || exceptionMessage.contains("SEQUENCE_ERROR") || exceptionMessage.contains("NETWORK_SHUTDOWN") || exceptionMessage.contains("TIMEOUT");
        if (retryThisOperation) {
            int waitTime = (int)((double)this.minTimeBetweenRetriesMs * (1.0 + this.random.nextDouble() / 3.0));
            log.finest("Retrying due to " + detail.toString() + " attempt " + retries + " in " + waitTime + " ms.");
            this.timeoutExecutor.schedule(() -> this.postToCluster(this.clusters.get(clusterId), documentSendInfo.getDocument()), (long)waitTime, TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result process(EndpointResult endpointResult, int clusterId) {
        Result result;
        Document blockedDocumentToSend = null;
        Object object = this.monitor;
        synchronized (object) {
            if (!this.docSendInfoByOperationId.containsKey(endpointResult.getOperationId())) {
                log.finer("Received out-of-order or too late result, discarding: " + endpointResult);
                return null;
            }
            DocumentSendInfo documentSendInfo = this.docSendInfoByOperationId.get(endpointResult.getOperationId());
            if (this.retriedThis(endpointResult, documentSendInfo, clusterId)) {
                return null;
            }
            if (!documentSendInfo.addIfNotAlreadyThere(endpointResult.getDetail(), clusterId)) {
                return null;
            }
            if (documentSendInfo.detailCount() != this.numDestinations) {
                return null;
            }
            result = documentSendInfo.createResult();
            this.docSendInfoByOperationId.remove(endpointResult.getOperationId());
            String documentId = documentSendInfo.getDocument().getDocumentId();
            List blockedDocuments = this.blockedDocumentsByDocumentId.get((Object)documentId);
            if (blockedDocuments.isEmpty()) {
                this.inflightDocumentIds.remove(documentId);
            } else {
                blockedDocumentToSend = (Document)blockedDocuments.remove(0);
            }
        }
        if (blockedDocumentToSend != null) {
            this.sendToClusters(blockedDocumentToSend);
        }
        return result;
    }

    public void resultReceived(EndpointResult endpointResult, int clusterId) {
        Result result = this.process(endpointResult, clusterId);
        if (result != null) {
            this.incompleteResultsThrottler.resultReady(result.isSuccess());
            this.resultCallback.onCompletion(result.getDocumentId(), result);
            if (this.traceToStderr && result.hasLocalTrace()) {
                System.err.println(result.toString());
            }
        }
    }

    public void onEndpointError(FeedEndpointException e) {
        this.resultCallback.onEndpointException(e);
    }

    public List<Exception> closeClusters() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (ClusterConnection cluster : this.clusters) {
            try {
                cluster.close();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        return exceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDocument(Document document) {
        this.incompleteResultsThrottler.operationStart();
        Object object = this.monitor;
        synchronized (object) {
            if (this.inflightDocumentIds.contains(document.getDocumentId())) {
                this.blockedDocumentsByDocumentId.put((Object)document.getDocumentId(), (Object)document);
                return;
            }
            this.inflightDocumentIds.add(document.getDocumentId());
        }
        this.sendToClusters(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToClusters(Document document) {
        Iterator<ClusterConnection> iterator = this.monitor;
        synchronized (iterator) {
            boolean traceThisDoc = this.traceEveryXOperation > 0 && this.traceCounter++ % this.traceEveryXOperation == 0;
            this.docSendInfoByOperationId.put(document.getOperationId(), new DocumentSendInfo(document, traceThisDoc));
        }
        for (ClusterConnection clusterConnection : this.clusters) {
            this.postToCluster(clusterConnection, document);
        }
    }

    private void postToCluster(ClusterConnection clusterConnection, Document document) {
        try {
            clusterConnection.post(document);
        }
        catch (EndpointIOException eio) {
            this.resultReceived(EndPointResultFactory.createError(eio.getEndpoint(), document.getOperationId(), eio), clusterConnection.getClusterId());
        }
    }

    public String getStatsAsJson() {
        return this.operationStats.getStatsAsJson();
    }

    public void close() {
        List<Exception> exceptions = this.closeClusters();
        try {
            this.closeExecutor();
        }
        catch (InterruptedException e) {
            exceptions.add(e);
        }
        if (exceptions.isEmpty()) {
            return;
        }
        if (exceptions.size() == 1) {
            if (exceptions.get(0) instanceof RuntimeException) {
                throw (RuntimeException)exceptions.get(0);
            }
            throw new RuntimeException(exceptions.get(0));
        }
        StringBuilder b = new StringBuilder();
        b.append("Exception thrown while closing one or more clusters: ");
        for (int i = 0; i < exceptions.size(); ++i) {
            Exception e = exceptions.get(i);
            b.append(Exceptions.toMessageString(e));
            if (i == exceptions.size() - 1) continue;
            b.append(", ");
        }
        throw new RuntimeException(b.toString(), exceptions.get(0));
    }

    private void closeExecutor() throws InterruptedException {
        log.log(Level.FINE, "Shutting down timeout executor.");
        this.timeoutExecutor.shutdownNow();
        log.log(Level.FINE, "Awaiting termination of already running timeout tasks.");
        if (!this.timeoutExecutor.awaitTermination(300L, TimeUnit.SECONDS)) {
            log.severe("Did not manage to shut down the executors within 300 secs, system stuck?");
            throw new RuntimeException("Did not manage to shut down retry threads. Please report problem.");
        }
    }
}

