/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core.operationProcessor;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.vespa.http.client.config.SessionParams;
import com.yahoo.vespa.http.client.core.communication.ClusterConnection;
import com.yahoo.vespa.http.client.core.operationProcessor.IncompleteResultsThrottler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class OperationStats {
    private static JsonFactory jsonFactory = new JsonFactory();
    private final String sessionParamsAsXmlString;
    private List<ClusterConnection> clusters;
    private IncompleteResultsThrottler throttler;

    public OperationStats(SessionParams sessionParams, List<ClusterConnection> clusters, IncompleteResultsThrottler throttler) {
        this.sessionParamsAsXmlString = this.generateSessionParamsAsXmlString(sessionParams);
        this.clusters = clusters;
        this.throttler = throttler;
    }

    private String generateSessionParamsAsXmlString(SessionParams sessionParams) {
        ObjectMapper objectMapper = new ObjectMapper();
        StringWriter stringWriter = new StringWriter();
        try {
            JsonGenerator jsonGenerator = jsonFactory.createGenerator((Writer)stringWriter);
            objectMapper.writeValue(jsonGenerator, (Object)sessionParams);
            return stringWriter.toString();
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public String getStatsAsJson() {
        try {
            StringWriter stringWriter = new StringWriter();
            JsonGenerator jsonGenerator = jsonFactory.createGenerator((Writer)stringWriter);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeArrayFieldStart("clusters");
            for (ClusterConnection cluster : this.clusters) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeNumberField("clusterid", cluster.getClusterId());
                jsonGenerator.writeFieldName("stats");
                jsonGenerator.writeRawValue(cluster.getStatsAsJSon());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeFieldName("sessionParams");
            jsonGenerator.writeRawValue(this.sessionParamsAsXmlString);
            jsonGenerator.writeFieldName("throttleDebugMessage");
            jsonGenerator.writeRawValue("\"" + this.throttler.getDebugMessage() + "\"");
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
            return stringWriter.toString();
        }
        catch (IOException e) {
            return "{ \"Error\" : \"" + e.getMessage() + "\"}";
        }
    }
}

