/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.runner;

import com.google.common.base.Splitter;
import com.yahoo.vespa.http.client.config.Cluster;
import com.yahoo.vespa.http.client.config.ConnectionParams;
import com.yahoo.vespa.http.client.config.Endpoint;
import com.yahoo.vespa.http.client.config.FeedParams;
import com.yahoo.vespa.http.client.config.SessionParams;
import io.airlift.command.Command;
import io.airlift.command.HelpOption;
import io.airlift.command.Option;
import io.airlift.command.SingleCommand;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.Header;
import org.apache.http.ParseException;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.message.BasicLineParser;

@Command(name="vespa-http-client", description="This is a tool for feeding xml or json data to a Vespa application.")
public class CommandLineArguments {
    @Inject
    private HelpOption helpOption;
    @Option(name={"--useV3Protocol"}, description="Use V3 protocol to gateway. This is the default protocol.")
    private boolean enableV3Protocol = true;
    @Option(name={"--file"}, description="The name of the input file to read.")
    private String fileArg = null;
    @Option(name={"--add-root-element-to-xml"}, description="Add <vespafeed> tag to XML document, makes it easier to feed raw data.")
    private boolean addRootElementToXml = false;
    @Option(name={"--route"}, description="(=default)The route to send the data to.")
    private String routeArg = "default";
    @Option(name={"--endpoint"}, description="Vespa endpoint.")
    private String endpointArg;
    @Option(name={"--host"}, description="The host(s) for the gateway. If using several, use comma to separate them.")
    private String hostArg;
    @Option(name={"--port"}, description="The port for the host of the gateway.")
    private int portArg = 4080;
    @Option(name={"--timeout"}, description="(=180) The time (in seconds) allowed for sending operations.")
    private long timeoutArg = 180L;
    @Option(name={"--useCompression"}, description="Use compression over network.")
    private boolean useCompressionArg = false;
    @Option(name={"--useDynamicThrottling"}, description="Try to maximize throughput by using dynamic throttling.")
    private boolean useDynamicThrottlingArg = false;
    @Option(name={"--maxpending"}, description="The maximum number of operations that are allowed to be pending at any given time.")
    private int maxPendingOperationCountArg = 10000;
    @Option(name={"-v", "--verbose"}, description="Enable verbose output of progress.")
    private boolean verboseArg = false;
    @Option(name={"--noretry"}, description="Turns off retries of recoverable failures..")
    private boolean noRetryArg = false;
    @Option(name={"--retrydelay"}, description="The time (in seconds) to wait between retries of a failed operation.")
    private int retrydelayArg = 1;
    @Option(name={"--trace"}, description="(=0 (=off)) The trace level of network traffic.")
    private int traceArg = 0;
    @Option(name={"--printTraceEveryXOperation"}, description="(=1) How often to to tracing.")
    private int traceEveryXOperation = 1;
    @Option(name={"--validate"}, description="Run validation tool on input files instead of feeding them.")
    private boolean validateArg = false;
    @Option(name={"--priority"}, description="Specify priority of sent messages, see documentation ")
    private String priorityArg = null;
    @Option(name={"--numPersistentConnectionsPerEndpoint"}, description="How many tcp connections to establish per endoint.)")
    private int numPersistentConnectionsPerEndpoint = 4;
    @Option(name={"--maxChunkSizeBytes"}, description="How much data to send to gateway in each message.")
    private int maxChunkSizeBytes = 20480;
    @Option(name={"--whenVerboseEnabledPrintMessageForEveryXDocuments"}, description="How often to print verbose message.)")
    private int whenVerboseEnabledPrintMessageForEveryXDocuments = 1000;
    @Option(name={"--useTls"}, description="Use TLS when connecting to endpoint")
    private boolean useTls = false;
    @Option(name={"--insecure", "--disable-hostname-verification"}, description="Skip hostname verification when using TLS")
    private boolean insecure = false;
    @Option(name={"--header"}, description="Add http header to every request. Header must have the format '<Name>: <Value>'. Use this parameter multiple times for multiple headers")
    private List<String> headers = new ArrayList<String>();
    @Option(name={"--vespaTls"}, description="BETA! Use Vespa TLS configuration from environment if available. Other HTTPS/TLS configuration will be ignored if this is set.")
    private boolean useTlsConfigFromEnvironment = false;
    @Option(name={"--connectionTimeToLive"}, description="Maximum time to live for persistent connections. Specified as integer, in seconds.")
    private long connectionTimeToLive = 15L;
    @Option(name={"--certificate"}, description="Path to a file containing a PEM encoded x509 certificate")
    private String certificatePath;
    @Option(name={"--privateKey"}, description="Path to a file containing a PEM encoded private key")
    private String privateKeyPath;
    @Option(name={"--caCertificates"}, description="Path to a file containing a PEM encoded CA certificates")
    private String caCertificatesPath;
    private final List<Header> parsedHeaders = new ArrayList<Header>();

    static CommandLineArguments build(String[] args) {
        CommandLineArguments cmdArgs;
        try {
            cmdArgs = (CommandLineArguments)SingleCommand.singleCommand(CommandLineArguments.class).parse(args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println("Use --help to show usage.\n");
            return null;
        }
        if (cmdArgs.helpOption.showHelpIfRequested()) {
            return null;
        }
        if (cmdArgs.endpointArg != null) {
            if (cmdArgs.hostArg != null) {
                System.err.println("Cannot set both '--host' and '--endpoint' ");
                return null;
            }
            try {
                URL e = new URL(cmdArgs.endpointArg);
            }
            catch (MalformedURLException e) {
                e.printStackTrace(System.err);
                return null;
            }
        } else if (cmdArgs.hostArg == null) {
            System.err.println("'--host' or '--endpoint' not set.");
            return null;
        }
        if (cmdArgs.priorityArg != null && !CommandLineArguments.checkPriorityFlag(cmdArgs.priorityArg)) {
            return null;
        }
        for (String header : cmdArgs.headers) {
            try {
                cmdArgs.parsedHeaders.add(BasicLineParser.parseHeader((String)header, null));
            }
            catch (ParseException e) {
                System.err.printf("Invalid header: '%s' (%s)%n", header, e.getMessage());
                return null;
            }
        }
        if (cmdArgs.privateKeyPath == null && cmdArgs.certificatePath != null || cmdArgs.privateKeyPath != null && cmdArgs.certificatePath == null) {
            System.err.println("Both '--privateKey' and '--certificate' must be set");
            return null;
        }
        return cmdArgs;
    }

    private static boolean checkPriorityFlag(String priorityArg) {
        switch (priorityArg) {
            case "HIGHEST": 
            case "VERY_HIGH": 
            case "HIGH_1": 
            case "HIGH_2": 
            case "HIGH_3": 
            case "NORMAL_1": 
            case "NORMAL_2": 
            case "NORMAL_3": 
            case "NORMAL_4": 
            case "NORMAL_5": 
            case "NORMAL_6": 
            case "LOW_1": 
            case "LOW_2": 
            case "LOW_3": 
            case "VERY_LOW": 
            case "LOWEST": {
                return true;
            }
        }
        System.err.println("Not valid value for priority. Allowed values are HIGHEST, VERY_HIGH, HIGH_[1-3], NORMAL_[1-6], LOW_[1-3], VERY_LOW, and LOWEST.");
        return false;
    }

    int getWhenVerboseEnabledPrintMessageForEveryXDocuments() {
        return this.whenVerboseEnabledPrintMessageForEveryXDocuments;
    }

    public String getFile() {
        return this.fileArg;
    }

    public boolean getVerbose() {
        return this.verboseArg;
    }

    public boolean getAddRootElementToXml() {
        return this.addRootElementToXml;
    }

    SessionParams createSessionParams(boolean useJson) {
        int minThrottleValue = this.useDynamicThrottlingArg ? 10 : 0;
        Path privateKeyPath = Optional.ofNullable(this.privateKeyPath).map(x$0 -> Paths.get(x$0, new String[0])).orElse(null);
        Path certificatePath = Optional.ofNullable(this.certificatePath).map(x$0 -> Paths.get(x$0, new String[0])).orElse(null);
        Path caCertificatesPath = Optional.ofNullable(this.caCertificatesPath).map(x$0 -> Paths.get(x$0, new String[0])).orElse(null);
        ConnectionParams.Builder connectionParamsBuilder = new ConnectionParams.Builder();
        this.parsedHeaders.forEach(header -> connectionParamsBuilder.addHeader(header.getName(), header.getValue()));
        SessionParams.Builder builder = new SessionParams.Builder().setFeedParams(new FeedParams.Builder().setDataFormat(useJson ? FeedParams.DataFormat.JSON_UTF8 : FeedParams.DataFormat.XML_UTF8).setRoute(this.routeArg).setMaxInFlightRequests(this.maxPendingOperationCountArg).setClientTimeout(this.timeoutArg, TimeUnit.SECONDS).setServerTimeout(this.timeoutArg, TimeUnit.SECONDS).setLocalQueueTimeOut(this.timeoutArg * 1000L).setPriority(this.priorityArg).setMaxChunkSizeBytes(this.maxChunkSizeBytes).build()).setConnectionParams(connectionParamsBuilder.setHostnameVerifier((HostnameVerifier)(this.insecure ? NoopHostnameVerifier.INSTANCE : SSLConnectionSocketFactory.getDefaultHostnameVerifier())).setUseCompression(this.useCompressionArg).setMaxRetries(this.noRetryArg ? 0 : 100).setMinTimeBetweenRetries(this.retrydelayArg, TimeUnit.SECONDS).setDryRun(this.validateArg).setTraceLevel(this.traceArg).setTraceEveryXOperation(this.traceEveryXOperation).setPrintTraceToStdErr(this.traceArg > 0).setNumPersistentConnectionsPerEndpoint(this.numPersistentConnectionsPerEndpoint).setCertificateAndPrivateKey(privateKeyPath, certificatePath).setCaCertificates(caCertificatesPath).setUseTlsConfigFromEnvironment(this.useTlsConfigFromEnvironment).setConnectionTimeToLive(Duration.ofSeconds(this.connectionTimeToLive)).build()).setThrottlerMinSize(minThrottleValue).setClientQueueSize(this.maxPendingOperationCountArg);
        if (this.endpointArg != null) {
            try {
                builder.addCluster(new Cluster.Builder().addEndpoint(Endpoint.create(new URL(this.endpointArg))).build());
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            Iterable hosts = Splitter.on((char)',').trimResults().split((CharSequence)this.hostArg);
            for (String host : hosts) {
                builder.addCluster(new Cluster.Builder().addEndpoint(Endpoint.create(host, this.portArg, this.useTls)).build());
            }
        }
        return builder.build();
    }
}

