/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client;

import com.yahoo.vespa.http.client.config.Endpoint;
import com.yahoo.vespa.http.client.core.Document;
import com.yahoo.vespa.http.client.core.Exceptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Deprecated
public class Result {
    private final Document document;
    private final boolean success;
    private final List<Detail> details;
    private final String localTrace;

    public Result(Document document, Collection<Detail> values, StringBuilder localTrace) {
        this.document = document;
        this.details = Collections.unmodifiableList(new ArrayList<Detail>(values));
        this.success = this.details.stream().allMatch(d -> d.getResultType() == ResultType.OPERATION_EXECUTED);
        this.localTrace = localTrace == null ? null : localTrace.toString();
    }

    public String getDocumentId() {
        return this.document.getDocumentId();
    }

    public String getOperationId() {
        return this.document.getOperationId();
    }

    public CharSequence getDocumentDataAsCharSequence() {
        return this.document.getDataAsString();
    }

    public Object getContext() {
        return this.document.getContext();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isSuccessOrConditionNotMet() {
        return this.isSuccess() || this.details.stream().allMatch(d -> d.getResultType() == ResultType.OPERATION_EXECUTED || d.getResultType() == ResultType.CONDITION_NOT_MET);
    }

    public List<Detail> getDetails() {
        return this.details;
    }

    public boolean hasLocalTrace() {
        return this.localTrace != null;
    }

    public String toString() {
        return "Result for " + this.document + " " + (this.localTrace != null ? this.localTrace : "");
    }

    public static final class Detail {
        private final ResultType resultType;
        private final Endpoint endpoint;
        private final Exception exception;
        private final String traceMessage;

        public Detail(Endpoint endpoint, ResultType resultType, String traceMessage, Exception e) {
            this.endpoint = endpoint;
            this.resultType = resultType;
            this.exception = e;
            this.traceMessage = traceMessage;
        }

        public Detail(Endpoint endpoint) {
            this.endpoint = endpoint;
            this.resultType = ResultType.OPERATION_EXECUTED;
            this.exception = null;
            this.traceMessage = null;
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public boolean isSuccess() {
            return this.resultType == ResultType.OPERATION_EXECUTED;
        }

        public ResultType getResultType() {
            return this.resultType;
        }

        public Exception getException() {
            return this.exception;
        }

        public String getTraceMessage() {
            return this.traceMessage;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("Detail ");
            b.append("resultType=").append((Object)this.resultType);
            if (this.exception != null) {
                b.append(" exception='").append(Exceptions.toMessageString(this.exception)).append("'");
            }
            if (this.traceMessage != null && !this.traceMessage.isEmpty()) {
                b.append(" trace='").append(this.traceMessage).append("'");
            }
            if (this.endpoint != null) {
                b.append(" endpoint=").append(this.endpoint);
            }
            return b.toString();
        }
    }

    public static enum ResultType {
        OPERATION_EXECUTED,
        TRANSITIVE_ERROR,
        CONDITION_NOT_MET,
        FATAL_ERROR;

    }
}

