/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client;

import com.yahoo.vespa.http.client.Session;
import com.yahoo.vespa.http.client.config.Cluster;
import com.yahoo.vespa.http.client.config.Endpoint;
import com.yahoo.vespa.http.client.config.SessionParams;
import com.yahoo.vespa.http.client.core.api.SessionImpl;
import java.time.Clock;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

@Deprecated
public final class SessionFactory {
    public static Session create(SessionParams params) {
        return SessionFactory.createInternal(params);
    }

    static Session createInternal(SessionParams params) {
        return new SessionImpl(params, SessionFactory.createTimeoutExecutor(), Clock.systemUTC());
    }

    static ScheduledThreadPoolExecutor createTimeoutExecutor() {
        ScheduledThreadPoolExecutor timeoutExecutor = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory("timeout-"));
        timeoutExecutor.setRemoveOnCancelPolicy(true);
        timeoutExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        timeoutExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return timeoutExecutor;
    }

    public static Session create(Endpoint endpoint) {
        return SessionFactory.createInternal(endpoint);
    }

    static Session createInternal(Endpoint endpoint) {
        SessionParams params = new SessionParams.Builder().addCluster(new Cluster.Builder().addEndpoint(endpoint).build()).build();
        return SessionFactory.create(params);
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
        private final String prefix;

        public DaemonThreadFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = this.defaultThreadFactory.newThread(runnable);
            t.setDaemon(true);
            t.setName(this.prefix + t.getName());
            return t;
        }
    }
}

