/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client;

import com.yahoo.vespa.http.client.FeedClient;
import com.yahoo.vespa.http.client.FeedClientFactory;
import com.yahoo.vespa.http.client.FeedEndpointException;
import com.yahoo.vespa.http.client.Result;
import com.yahoo.vespa.http.client.config.SessionParams;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

@Deprecated
public class SyncFeedClient
implements AutoCloseable {
    private final FeedClient wrappedClient;
    private final Callback callback = new Callback();

    public SyncFeedClient(SessionParams params) {
        if (params.getFeedParams().getIdlePollFrequency() == null) {
            params = params.toBuilder().setFeedParams(params.getFeedParams().toBuilder().setIdlePollFrequency(500.0).build()).build();
        }
        this.wrappedClient = FeedClientFactory.create(params, this.callback);
    }

    public SyncResult stream(List<SyncOperation> operations) {
        this.callback.expectResultsOf(operations);
        for (SyncOperation operation : operations) {
            this.wrappedClient.stream(operation.documentId, operation.operationId, operation.documentData, operation.context);
        }
        return this.callback.waitForResults();
    }

    @Override
    public void close() {
        this.wrappedClient.close();
    }

    private static class Callback
    implements FeedClient.ResultCallback {
        private final Object monitor = new Object();
        private int resultsReceived;
        private Exception exception = null;
        private LinkedHashMap<String, Result> results = null;

        private Callback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void expectResultsOf(List<SyncOperation> operations) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.results != null) {
                    throw new ConcurrentModificationException("A SyncFeedClient instance is used by multiple threads");
                }
                this.resultsReceived = 0;
                this.exception = null;
                this.results = new LinkedHashMap(operations.size());
                for (SyncOperation operation : operations) {
                    this.results.put(operation.operationId, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SyncResult waitForResults() {
            try {
                Object object = this.monitor;
                synchronized (object) {
                    while (!this.complete()) {
                        this.monitor.wait();
                    }
                    SyncResult syncResult = new SyncResult(new ArrayList<Result>(this.results.values()), this.exception);
                    this.results = null;
                    return syncResult;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for feeding results", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(String docId, Result documentResult) {
            Object object = this.monitor;
            synchronized (object) {
                if (!this.results.containsKey(documentResult.getOperationId())) {
                    return;
                }
                Result previousValue = this.results.put(documentResult.getOperationId(), documentResult);
                if (previousValue != null) {
                    throw new IllegalStateException("Received duplicate result for " + docId);
                }
                ++this.resultsReceived;
                if (this.complete()) {
                    this.monitor.notifyAll();
                }
            }
        }

        @Override
        public void onEndpointException(FeedEndpointException exception) {
            this.exception = exception;
        }

        private boolean complete() {
            return this.resultsReceived == this.results.size();
        }
    }

    public static class SyncOperation {
        private final String documentId;
        private final CharSequence documentData;
        private final Object context;
        private final String operationId;

        public SyncOperation(String documentId, CharSequence documentData) {
            this(documentId, documentData, null);
        }

        public SyncOperation(String documentId, CharSequence documentData, Object context) {
            this(documentId, documentData, new BigInteger(64, ThreadLocalRandom.current()).toString(32), context);
        }

        public SyncOperation(String documentId, CharSequence documentData, String operationId, Object context) {
            this.documentId = Objects.requireNonNull(documentId, "documentId");
            this.documentData = Objects.requireNonNull(documentData, "documentData");
            this.context = context;
            this.operationId = Objects.requireNonNull(operationId);
        }
    }

    public static class SyncResult {
        private final Exception exception;
        private final List<Result> results;

        private SyncResult(List<Result> results, Exception exception) {
            this.results = results;
            this.exception = exception;
        }

        public List<Result> results() {
            return this.results;
        }

        public Exception exception() {
            return this.exception;
        }

        public boolean isSuccess() {
            return this.results.stream().allMatch(Result::isSuccess);
        }
    }
}

