/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.config;

import com.yahoo.vespa.http.client.config.Endpoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class Cluster {
    private final List<Endpoint> endpoints;
    private final String route;

    private Cluster(List<Endpoint> endpoints, String route) {
        this.endpoints = Collections.unmodifiableList(new ArrayList<Endpoint>(endpoints));
        this.route = route;
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public String getRoute() {
        return this.route;
    }

    public String toString() {
        return "cluster with endpoints " + this.endpoints + " and route '" + this.route + "'";
    }

    public static final class Builder {
        private final List<Endpoint> endpoints = new LinkedList<Endpoint>();
        private String route = null;

        public Builder addEndpoint(Endpoint endpoint) {
            this.endpoints.add(endpoint);
            return this;
        }

        public Builder setRoute(String route) {
            this.route = route;
            return this;
        }

        public Cluster build() {
            return new Cluster(this.endpoints, this.route);
        }

        public String getRoute() {
            return this.route;
        }
    }
}

