/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;

public final class ConnectionParams {
    private final SSLContext sslContext;
    private final Path privateKey;
    private final Path certificate;
    private final Path caCertificates;
    private final HostnameVerifier hostnameVerifier;
    private final Multimap<String, String> headers = ArrayListMultimap.create();
    private final Map<String, HeaderProvider> headerProviders = new HashMap<String, HeaderProvider>();
    private final int numPersistentConnectionsPerEndpoint;
    private final String proxyHost;
    private final int proxyPort;
    private final boolean useCompression;
    private final int maxRetries;
    private final long minTimeBetweenRetriesMs;
    private final boolean dryRun;
    private final boolean runThreads;
    private final int traceLevel;
    private final int traceEveryXOperation;
    private final boolean printTraceToStdErr;
    private final boolean useTlsConfigFromEnvironment;
    private final Duration connectionTimeToLive;

    private ConnectionParams(SSLContext sslContext, Path privateKey, Path certificate, Path caCertificates, HostnameVerifier hostnameVerifier, Multimap<String, String> headers, Map<String, HeaderProvider> headerProviders, int numPersistentConnectionsPerEndpoint, String proxyHost, int proxyPort, boolean useCompression, int maxRetries, long minTimeBetweenRetriesMs, boolean dryRun, boolean runThreads, int traceLevel, int traceEveryXOperation, boolean printTraceToStdErr, boolean useTlsConfigFromEnvironment, Duration connectionTimeToLive) {
        this.sslContext = sslContext;
        this.privateKey = privateKey;
        this.certificate = certificate;
        this.caCertificates = caCertificates;
        this.hostnameVerifier = hostnameVerifier;
        this.useTlsConfigFromEnvironment = useTlsConfigFromEnvironment;
        this.connectionTimeToLive = connectionTimeToLive;
        this.headers.putAll(headers);
        this.headerProviders.putAll(headerProviders);
        this.numPersistentConnectionsPerEndpoint = numPersistentConnectionsPerEndpoint;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.useCompression = useCompression;
        this.maxRetries = maxRetries;
        this.minTimeBetweenRetriesMs = minTimeBetweenRetriesMs;
        this.dryRun = dryRun;
        this.runThreads = runThreads;
        this.traceLevel = traceLevel;
        this.traceEveryXOperation = traceEveryXOperation;
        this.printTraceToStdErr = printTraceToStdErr;
    }

    @JsonIgnore
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @JsonIgnore
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public Collection<Map.Entry<String, String>> getHeaders() {
        return Collections.unmodifiableCollection(this.headers.entries());
    }

    @JsonIgnore
    public Map<String, HeaderProvider> getDynamicHeaders() {
        return Collections.unmodifiableMap(this.headerProviders);
    }

    public int getNumPersistentConnectionsPerEndpoint() {
        return this.numPersistentConnectionsPerEndpoint;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public boolean getUseCompression() {
        return this.useCompression;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public long getMinTimeBetweenRetriesMs() {
        return this.minTimeBetweenRetriesMs;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean runThreads() {
        return this.runThreads;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public int getTraceEveryXOperation() {
        return this.traceEveryXOperation;
    }

    public boolean getPrintTraceToStdErr() {
        return this.printTraceToStdErr;
    }

    public boolean useTlsConfigFromEnvironment() {
        return this.useTlsConfigFromEnvironment;
    }

    public Duration getConnectionTimeToLive() {
        return this.connectionTimeToLive;
    }

    public Path getPrivateKey() {
        return this.privateKey;
    }

    public Path getCertificate() {
        return this.certificate;
    }

    public Path getCaCertificates() {
        return this.caCertificates;
    }

    public static interface HeaderProvider {
        public String getHeaderValue();
    }

    public static final class Builder {
        private SSLContext sslContext = null;
        private HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
        private final Multimap<String, String> headers = ArrayListMultimap.create();
        private final Map<String, HeaderProvider> headerProviders = new HashMap<String, HeaderProvider>();
        private int numPersistentConnectionsPerEndpoint = 1;
        private String proxyHost = null;
        private int proxyPort = 8080;
        private boolean useCompression = false;
        private int maxRetries = 100;
        private long minTimeBetweenRetriesMs = 700L;
        private boolean dryRun = false;
        private boolean runThreads = true;
        private int traceLevel = 0;
        private int traceEveryXOperation = 0;
        private boolean printTraceToStdErr = true;
        private boolean useTlsConfigFromEnvironment = false;
        private Duration connectionTimeToLive = Duration.ofSeconds(30L);
        private Path privateKey;
        private Path certificate;
        private Path caCertificates;

        public Builder setUseTlsConfigFromEnvironment(boolean useTlsConfigFromEnvironment) {
            this.useTlsConfigFromEnvironment = useTlsConfigFromEnvironment;
            return this;
        }

        public Builder setSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder setHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder setCertificateAndPrivateKey(Path privateKey, Path certificate) {
            this.privateKey = privateKey;
            this.certificate = certificate;
            return this;
        }

        public Builder setCaCertificates(Path caCertificates) {
            this.caCertificates = caCertificates;
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.headers.put((Object)key, (Object)value);
            return this;
        }

        public Builder addDynamicHeader(String headerName, HeaderProvider provider) {
            Objects.requireNonNull(headerName, "Header name cannot be null");
            Objects.requireNonNull(provider, "Header provider cannot be null");
            if (this.headerProviders.containsKey(headerName)) {
                throw new IllegalArgumentException("Provider already registered for name '" + headerName + "'");
            }
            this.headerProviders.put(headerName, provider);
            return this;
        }

        public Builder setNumPersistentConnectionsPerEndpoint(int numPersistentConnectionsPerEndpoint) {
            this.numPersistentConnectionsPerEndpoint = numPersistentConnectionsPerEndpoint;
            return this;
        }

        public Builder setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public Builder setProxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder setUseCompression(boolean useCompression) {
            this.useCompression = useCompression;
            return this;
        }

        public Builder setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder setDryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public Builder setRunThreads(boolean runThreads) {
            this.runThreads = runThreads;
            return this;
        }

        public Builder setMinTimeBetweenRetries(long minTimeBetweenRetries, TimeUnit unit) {
            this.minTimeBetweenRetriesMs = unit.toMillis(minTimeBetweenRetries);
            return this;
        }

        public long getMinTimeBetweenRetriesMs() {
            return this.minTimeBetweenRetriesMs;
        }

        public Builder setTraceLevel(int traceLevel) {
            this.traceLevel = traceLevel;
            return this;
        }

        public Builder setTraceEveryXOperation(int traceEveryXOperation) {
            this.traceEveryXOperation = traceEveryXOperation;
            return this;
        }

        public Builder setPrintTraceToStdErr(boolean printTraceToStdErr) {
            this.printTraceToStdErr = printTraceToStdErr;
            return this;
        }

        public Builder setConnectionTimeToLive(Duration connectionTimeToLive) {
            this.connectionTimeToLive = connectionTimeToLive;
            return this;
        }

        public ConnectionParams build() {
            return new ConnectionParams(this.sslContext, this.privateKey, this.certificate, this.caCertificates, this.hostnameVerifier, this.headers, this.headerProviders, this.numPersistentConnectionsPerEndpoint, this.proxyHost, this.proxyPort, this.useCompression, this.maxRetries, this.minTimeBetweenRetriesMs, this.dryRun, this.runThreads, this.traceLevel, this.traceEveryXOperation, this.printTraceToStdErr, this.useTlsConfigFromEnvironment, this.connectionTimeToLive);
        }

        public int getNumPersistentConnectionsPerEndpoint() {
            return this.numPersistentConnectionsPerEndpoint;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public boolean isDryRun() {
            return this.dryRun;
        }

        public boolean runThreads() {
            return this.runThreads;
        }

        public int getMaxRetries() {
            return this.maxRetries;
        }

        public int getTraceLevel() {
            return this.traceLevel;
        }

        public int getTraceEveryXOperation() {
            return this.traceEveryXOperation;
        }

        public boolean getPrintTraceToStdErr() {
            return this.printTraceToStdErr;
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        public SSLContext getSslContext() {
            return this.sslContext;
        }

        public HostnameVerifier getHostnameVerifier() {
            return this.hostnameVerifier;
        }

        public boolean useTlsConfigFromEnvironment() {
            return this.useTlsConfigFromEnvironment;
        }

        public Duration getConnectionTimeToLive() {
            return this.connectionTimeToLive;
        }

        public Path getPrivateKey() {
            return this.privateKey;
        }

        public Path getCertificate() {
            return this.certificate;
        }

        public Path getCaCertificates() {
            return this.caCertificates;
        }
    }
}

