/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.config;

import java.io.Serializable;
import java.net.URL;

public final class Endpoint
implements Serializable {
    private static final int DEFAULT_PORT = 4080;
    private final String hostname;
    private final int port;
    private final boolean useSsl;

    private Endpoint(String hostname, int port, boolean useSsl) {
        if (hostname.startsWith("https://")) {
            throw new RuntimeException("Hostname should be name of machine, not prefixed with protocol (https://)");
        }
        this.hostname = hostname.startsWith("http://") ? hostname.replaceFirst("http://", "") : hostname;
        this.port = port;
        this.useSsl = useSsl;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public String toString() {
        return this.hostname + ":" + this.port + " ssl=" + this.useSsl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Endpoint)) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        return this.port == endpoint.port && this.useSsl == endpoint.useSsl && this.hostname.equals(endpoint.hostname);
    }

    public int hashCode() {
        int result = this.hostname.hashCode();
        result = 31 * result + this.port;
        result = 31 * result + (this.useSsl ? 1 : 0);
        return result;
    }

    public static Endpoint create(String hostname) {
        return new Endpoint(hostname, 4080, false);
    }

    public static Endpoint create(String hostname, int port, boolean useSsl) {
        return new Endpoint(hostname, port, useSsl);
    }

    public static Endpoint create(URL url) {
        return new Endpoint(url.getHost(), url.getPort(), "https".equals(url.getProtocol()));
    }
}

