/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.config;

import java.util.concurrent.TimeUnit;

public final class FeedParams {
    private final DataFormat dataFormat;
    private final long serverTimeoutMillis;
    private final long clientTimeoutMillis;
    private final String route;
    private final int maxChunkSizeBytes;
    private final int maxInFlightRequests;
    private final long localQueueTimeOut;
    private final String priority;
    private final boolean denyIfBusyV3;
    private final long maxSleepTimeMs;
    private final boolean silentUpgrade;
    private final Double idlePollFrequency;

    public boolean getDenyIfBusyV3() {
        return this.denyIfBusyV3;
    }

    public long getMaxSleepTimeMs() {
        return this.maxSleepTimeMs;
    }

    public boolean getSilentUpgrade() {
        return this.silentUpgrade;
    }

    private FeedParams(DataFormat dataFormat, long serverTimeout, long clientTimeout, String route, int maxChunkSizeBytes, int maxInFlightRequests, long localQueueTimeOut, String priority, boolean denyIfBusyV3, long maxSleepTimeMs, boolean silentUpgrade, Double idlePollFrequency) {
        this.dataFormat = dataFormat;
        this.serverTimeoutMillis = serverTimeout;
        this.clientTimeoutMillis = clientTimeout;
        this.route = route;
        this.maxChunkSizeBytes = maxChunkSizeBytes;
        this.maxInFlightRequests = maxInFlightRequests;
        this.localQueueTimeOut = localQueueTimeOut;
        this.priority = priority;
        this.denyIfBusyV3 = denyIfBusyV3;
        this.maxSleepTimeMs = maxSleepTimeMs;
        this.silentUpgrade = silentUpgrade;
        this.idlePollFrequency = idlePollFrequency;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public String getRoute() {
        return this.route;
    }

    public long getServerTimeout(TimeUnit unit) {
        return unit.convert(this.serverTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    public long getClientTimeout(TimeUnit unit) {
        return unit.convert(this.clientTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    public int getMaxChunkSizeBytes() {
        return this.maxChunkSizeBytes;
    }

    public String getPriority() {
        return this.priority;
    }

    public String toUriParameters() {
        StringBuilder b = new StringBuilder();
        b.append("&dataformat=").append(this.dataFormat.name());
        return b.toString();
    }

    public int getMaxInFlightRequests() {
        return this.maxInFlightRequests;
    }

    public long getLocalQueueTimeOut() {
        return this.localQueueTimeOut;
    }

    public Double getIdlePollFrequency() {
        return this.idlePollFrequency;
    }

    public Builder toBuilder() {
        Builder b = new Builder();
        b.setDataFormat(this.dataFormat);
        b.setServerTimeout(this.serverTimeoutMillis, TimeUnit.MILLISECONDS);
        b.setClientTimeout(this.clientTimeoutMillis, TimeUnit.MILLISECONDS);
        b.setRoute(this.route);
        b.setMaxChunkSizeBytes(this.maxChunkSizeBytes);
        b.setMaxInFlightRequests(this.maxInFlightRequests);
        b.setPriority(this.priority);
        b.setDenyIfBusyV3(this.denyIfBusyV3);
        b.setMaxSleepTimeMs(this.maxSleepTimeMs);
        b.setSilentUpgrade(this.silentUpgrade);
        b.setIdlePollFrequency(this.idlePollFrequency);
        return b;
    }

    public static enum DataFormat {
        XML_UTF8,
        JSON_UTF8;

    }

    public static final class Builder {
        private DataFormat dataFormat = DataFormat.JSON_UTF8;
        private long serverTimeout = TimeUnit.SECONDS.toMillis(180L);
        private long clientTimeout = TimeUnit.SECONDS.toMillis(20L);
        private String route = null;
        private int maxChunkSizeBytes = 51200;
        private int maxInFlightRequests = 5000;
        private long localQueueTimeOut = 180000L;
        private String priority = null;
        private boolean denyIfBusyV3 = true;
        private long maxSleepTimeMs = 3000L;
        private boolean silentUpgrade = true;
        private Double idlePollFrequency = null;

        public Builder setSilentUpgrade(boolean silentUpgrade) {
            this.silentUpgrade = silentUpgrade;
            return this;
        }

        public Builder setMaxSleepTimeMs(long ms) {
            this.maxSleepTimeMs = ms;
            return this;
        }

        public Builder setDenyIfBusyV3(boolean value) {
            this.denyIfBusyV3 = value;
            return this;
        }

        public Builder setDataFormat(DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Builder setRoute(String route) {
            this.route = route;
            return this;
        }

        public Builder setServerTimeout(long serverTimeout, TimeUnit unit) {
            if (serverTimeout <= 0L) {
                throw new IllegalArgumentException("Server timeout cannot be zero or negative.");
            }
            this.serverTimeout = unit.toMillis(serverTimeout);
            return this;
        }

        public Builder setClientTimeout(long clientTimeout, TimeUnit unit) {
            if (clientTimeout <= 0L) {
                throw new IllegalArgumentException("Client timeout cannot be zero or negative.");
            }
            this.clientTimeout = unit.toMillis(clientTimeout);
            return this;
        }

        public Builder setMaxChunkSizeBytes(int maxChunkSizeBytes) {
            this.maxChunkSizeBytes = maxChunkSizeBytes;
            return this;
        }

        public Builder setMaxInFlightRequests(int maxInFlightRequests) {
            this.maxInFlightRequests = maxInFlightRequests;
            return this;
        }

        public Builder setLocalQueueTimeOut(long timeOutMs) {
            this.localQueueTimeOut = timeOutMs;
            return this;
        }

        public Builder setIdlePollFrequency(Double idlePollFrequency) {
            this.idlePollFrequency = idlePollFrequency;
            return this;
        }

        public Builder setPriority(String priority) {
            if (priority == null) {
                return this;
            }
            switch (priority) {
                case "HIGHEST": 
                case "VERY_HIGH": 
                case "HIGH_1": 
                case "HIGH_2": 
                case "HIGH_3": 
                case "NORMAL_1": 
                case "NORMAL_2": 
                case "NORMAL_3": 
                case "NORMAL_4": 
                case "NORMAL_5": 
                case "NORMAL_6": 
                case "LOW_1": 
                case "LOW_2": 
                case "LOW_3": 
                case "VERY_LOW": 
                case "LOWEST": {
                    this.priority = priority;
                    return this;
                }
            }
            throw new IllegalArgumentException("Unknown value for priority: " + priority + " Allowed values are HIGHEST, VERY_HIGH, HIGH_[1-3], NORMAL_[1-6], LOW_[1-3], VERY_LOW, and LOWEST.");
        }

        public FeedParams build() {
            return new FeedParams(this.dataFormat, this.serverTimeout, this.clientTimeout, this.route, this.maxChunkSizeBytes, this.maxInFlightRequests, this.localQueueTimeOut, this.priority, this.denyIfBusyV3, this.maxSleepTimeMs, this.silentUpgrade, this.idlePollFrequency);
        }

        public long getClientTimeout(TimeUnit unit) {
            return unit.convert(this.clientTimeout, TimeUnit.MILLISECONDS);
        }

        public long getServerTimeout(TimeUnit unit) {
            return unit.convert(this.serverTimeout, TimeUnit.MILLISECONDS);
        }

        public String getRoute() {
            return this.route;
        }

        public DataFormat getDataFormat() {
            return this.dataFormat;
        }

        public int getMaxChunkSizeBytes() {
            return this.maxChunkSizeBytes;
        }

        public int getMaxInFlightRequests() {
            return this.maxInFlightRequests;
        }
    }
}

