/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.http.client.core;

public abstract class Exceptions {
    public static String toMessageString(Throwable t) {
        StringBuilder b = new StringBuilder();
        String lastMessage = null;
        while (t != null) {
            String message = Exceptions.getMessage(t);
            if (message != null && !message.equals(lastMessage)) {
                if (b.length() > 0) {
                    b.append(": ");
                }
                b.append(message);
            }
            t = t.getCause();
            lastMessage = message;
        }
        return b.toString();
    }

    private static String getMessage(Throwable t) {
        String message = t.getMessage();
        if (t.getCause() == null) {
            if (message == null) {
                return t.getClass().getSimpleName();
            }
        } else {
            if (message == null) {
                return null;
            }
            if (message.equals(t.getCause().getClass().getName() + ": " + t.getCause().getMessage())) {
                return null;
            }
        }
        return message;
    }
}

